/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.descriptor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.util.ArrayUtil;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.WireContext;
import org.ow2.orchestra.pvm.internal.wire.WireDefinition;
import org.ow2.orchestra.pvm.internal.wire.WireException;
import org.ow2.orchestra.pvm.internal.wire.descriptor.AbstractDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ArgDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.EnvironmentTypeRefDescriptor;
import org.ow2.orchestra.pvm.internal.wire.operation.FieldOperation;
import org.ow2.orchestra.pvm.internal.wire.operation.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectDescriptor
extends AbstractDescriptor
implements Descriptor {
    private static final long serialVersionUID = 1L;
    private static Log log = Log.getLog(ObjectDescriptor.class.getName());
    private String className = null;
    private String factoryObjectName = null;
    private Descriptor factoryDescriptor = null;
    private String methodName = null;
    private List<ArgDescriptor> argDescriptors = null;
    private List<Operation> operations = null;
    private boolean isAutoWireEnabled = false;

    public ObjectDescriptor() {
    }

    public ObjectDescriptor(String className) {
        this.className = className;
    }

    public ObjectDescriptor(Class<?> clazz) {
        this.className = clazz.getName();
    }

    @Override
    public Object construct(WireContext wireContext) {
        Object[] args;
        Object object = null;
        Class<?> clazz = null;
        if (this.className != null) {
            try {
                ClassLoader classLoader = wireContext.getClassLoader();
                clazz = ReflectUtil.loadClass(classLoader, this.className);
            }
            catch (Exception e) {
                throw new WireException("couldn't create object" + (this.name != null ? " '" + this.name + "'" : "") + ": " + e.getMessage(), e);
            }
            if (this.methodName == null) {
                try {
                    args = ObjectDescriptor.getArgs(wireContext, this.argDescriptors);
                    Constructor<?> constructor = ReflectUtil.findConstructor(clazz, this.argDescriptors, args);
                    if (constructor == null) {
                        throw new WireException("couldn't find constructor " + clazz.getName() + " with args " + ArrayUtil.toString(args));
                    }
                    object = constructor.newInstance(args);
                }
                catch (WireException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WireException("couldn't create object '" + (this.name != null ? this.name : this.className) + "': " + e.getMessage(), e);
                }
            }
        } else if (this.factoryObjectName != null) {
            object = wireContext.get(this.factoryObjectName, false);
            if (object == null) {
                throw new WireException("can't invoke method '" + this.methodName + "' on null, resulted from fetching object '" + this.factoryObjectName + "' from this wiring environment");
            }
        } else if (this.factoryDescriptor != null && (object = wireContext.create(this.factoryDescriptor, false)) == null) {
            throw new WireException("created factory object is null, can't invoke method '" + this.methodName + "' on it");
        }
        if (this.methodName != null) {
            if (object != null) {
                clazz = object.getClass();
            }
            try {
                args = ObjectDescriptor.getArgs(wireContext, this.argDescriptors);
                Method method = ReflectUtil.findMethod(clazz, this.methodName, this.argDescriptors, args);
                if (method == null) {
                    throw new WireException("method " + ReflectUtil.getSignature(this.methodName, this.argDescriptors, args) + " is not available on " + (object != null ? "object " + object + " (" + clazz.getName() + ")" : "class " + clazz.getName()));
                }
                if (object == null && !Modifier.isStatic(method.getModifiers())) {
                    throw new WireException("method " + clazz.getName() + "." + ReflectUtil.getSignature(this.methodName, this.argDescriptors, args) + " is not static. It cannot be called on a null object.");
                }
                object = ReflectUtil.invoke(method, object, args);
            }
            catch (WireException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WireException("couldn't invoke factory method " + this.methodName + ": " + e.getMessage(), e);
            }
        }
        return object;
    }

    @Override
    public void initialize(Object object, WireContext wireContext) {
        try {
            if (this.isAutoWireEnabled) {
                this.autoWire(object, wireContext);
            }
            if (this.operations != null) {
                for (Operation operation : this.operations) {
                    operation.apply(object, wireContext);
                }
            }
        }
        catch (Exception e) {
            throw new WireException("couldn't initialize object '" + (this.name != null ? this.name : this.className) + "': " + e.getMessage(), e);
        }
    }

    @Override
    public Class<?> getType(WireDefinition wireDefinition) {
        Method method;
        Class<?> factoryClass;
        if (this.className != null) {
            try {
                return ReflectUtil.loadClass(wireDefinition.getClassLoader(), this.className);
            }
            catch (PvmException e) {
                throw new WireException("couldn't get type of '" + (this.name != null ? this.name : this.className) + "': " + e.getMessage(), e.getCause());
            }
        }
        Descriptor descriptor = null;
        if (this.factoryDescriptor != null) {
            descriptor = this.factoryDescriptor;
        } else if (this.factoryObjectName != null) {
            descriptor = wireDefinition.getDescriptor(this.factoryObjectName);
        }
        if (descriptor != null && (factoryClass = descriptor.getType(wireDefinition)) != null && (method = ReflectUtil.findMethod(factoryClass, this.methodName, this.argDescriptors, null)) != null) {
            return method.getReturnType();
        }
        return null;
    }

    protected void autoWire(Object object, WireContext wireContext) {
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] declaredFields = clazz.getDeclaredFields();
            if (declaredFields == null) continue;
            for (Field field : declaredFields) {
                Environment currentEnvironment;
                if (Modifier.isStatic(field.getModifiers())) continue;
                String fieldName = field.getName();
                Object autoWireValue = null;
                autoWireValue = "environment".equals(fieldName) ? Environment.getCurrent() : ("context".equals(fieldName) || "wireContext".equals(fieldName) ? wireContext : (wireContext.has(fieldName) ? wireContext.get(fieldName) : wireContext.get(field.getType())));
                if (autoWireValue == null && (currentEnvironment = Environment.getCurrent()) != null && (autoWireValue = currentEnvironment.get(fieldName)) == null) {
                    autoWireValue = currentEnvironment.get(field.getType());
                }
                if (autoWireValue == null) continue;
                try {
                    log.debug("auto wiring field " + fieldName + " in " + this.name);
                    ReflectUtil.set(field, object, autoWireValue);
                }
                catch (PvmException e) {
                    if (e.getCause() instanceof IllegalArgumentException) {
                        log.info("WARNING: couldn't auto wire " + fieldName + " (of type " + field.getType().getName() + ") " + "with value " + autoWireValue + " (of type " + autoWireValue.getClass().getName() + ")");
                        continue;
                    }
                    log.info("WARNING: couldn't auto wire " + fieldName + " with value " + autoWireValue);
                }
            }
        }
    }

    public static Object[] getArgs(WireContext wireContext, List<ArgDescriptor> argDescriptors) throws Exception {
        Object[] args = null;
        if (argDescriptors != null) {
            args = new Object[argDescriptors.size()];
            for (int i = 0; i < argDescriptors.size(); ++i) {
                ArgDescriptor argDescriptor = argDescriptors.get(i);
                try {
                    Object arg;
                    args[i] = arg = wireContext.create(argDescriptor.getDescriptor(), true);
                    continue;
                }
                catch (RuntimeException e) {
                    throw new Exception("couldn't create argument " + i + ": " + e.getMessage(), e);
                }
            }
        }
        return args;
    }

    public void addArgDescriptor(ArgDescriptor argDescriptor) {
        if (this.argDescriptors == null) {
            this.argDescriptors = new ArrayList<ArgDescriptor>();
        }
        this.argDescriptors.add(argDescriptor);
    }

    public void addOperation(Operation operation) {
        if (this.operations == null) {
            this.operations = new ArrayList<Operation>();
        }
        this.operations.add(operation);
    }

    public void addTypedInjection(String fieldName, Class<?> type) {
        this.addInjection(fieldName, new EnvironmentTypeRefDescriptor(type));
    }

    public void addInjection(String fieldName, Descriptor descriptor) {
        FieldOperation injectionOperation = new FieldOperation();
        injectionOperation.setFieldName(fieldName);
        injectionOperation.setDescriptor(descriptor);
        this.addOperation(injectionOperation);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<ArgDescriptor> getArgDescriptors() {
        return this.argDescriptors;
    }

    public void setArgDescriptors(List<ArgDescriptor> argDescriptors) {
        this.argDescriptors = argDescriptors;
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<Operation> operations) {
        this.operations = operations;
    }

    public Descriptor getFactoryDescriptor() {
        return this.factoryDescriptor;
    }

    public void setFactoryDescriptor(Descriptor factoryDescriptor) {
        this.factoryDescriptor = factoryDescriptor;
    }

    public String getFactoryObjectName() {
        return this.factoryObjectName;
    }

    public void setFactoryObjectName(String factoryObjectName) {
        this.factoryObjectName = factoryObjectName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public boolean isAutoWireEnabled() {
        return this.isAutoWireEnabled;
    }

    public void setAutoWireEnabled(boolean isAutoWireEnabled) {
        this.isAutoWireEnabled = isAutoWireEnabled;
    }
}

