/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.WireDefinition;
import org.ow2.orchestra.pvm.internal.wire.descriptor.AbstractDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ArgDescriptor;
import org.ow2.orchestra.pvm.internal.wire.xml.BindingParser;
import org.ow2.orchestra.pvm.internal.xml.Bindings;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireParser
extends Parser {
    public static final String PVM_WIRE_BINDINGS_RESOURCES = "org/ow2/orchestra/pvm/pvm.wire.bindings.xml";
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getLog(WireParser.class.getName());
    public static final String CATEGORY_DESCRIPTOR = "descriptor";
    public static final String CATEGORY_OPERATION = "operation";
    public static final String CATEGORY_INTERCEPTOR = "interceptor";
    private static WireParser instance;
    private static Bindings defaultBindings;

    public WireParser() {
        super(defaultBindings);
    }

    public static synchronized WireParser getInstance() {
        if (instance == null) {
            instance = new WireParser();
        }
        return instance;
    }

    public static WireDefinition parseXmlString(String xmlString) {
        return (WireDefinition)WireParser.getInstance().createParse().setString(xmlString).execute().checkProblems("wire definition xml string").getDocumentObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object parseDocumentElement(Element documentElement, Parse parse) {
        List elements = XmlUtil.elements((Element)documentElement);
        WireDefinition wireDefinition = new WireDefinition();
        wireDefinition.setClassLoader(this.classLoader);
        if (elements != null) {
            parse.pushObject(wireDefinition);
            try {
                for (Element descriptorElement : elements) {
                    this.parseElement(descriptorElement, parse, CATEGORY_DESCRIPTOR);
                }
            }
            finally {
                parse.popObject();
            }
        }
        return wireDefinition;
    }

    @Override
    public Object parseElement(Element element, Parse parse, String category) {
        if (element == null) {
            return null;
        }
        Object object = super.parseElement(element, parse, category);
        if (object != null && object instanceof Descriptor) {
            Descriptor descriptor = (Descriptor)object;
            if (descriptor instanceof AbstractDescriptor) {
                AbstractDescriptor abstractDescriptor = (AbstractDescriptor)descriptor;
                if (element.hasAttribute("name")) {
                    String name = element.getAttribute("name");
                    abstractDescriptor.setName(name);
                }
                if (element.hasAttribute("init")) {
                    String initText = element.getAttribute("init");
                    if ("eager".equalsIgnoreCase(initText)) {
                        abstractDescriptor.setInit('E');
                    } else if ("immediate".equalsIgnoreCase(initText)) {
                        abstractDescriptor.setInit('I');
                    } else if ("required".equalsIgnoreCase(initText)) {
                        abstractDescriptor.setInit('R');
                    } else {
                        abstractDescriptor.setInit('L');
                    }
                }
            }
            WireDefinition wireDefinition = parse.findObject(WireDefinition.class);
            wireDefinition.addDescriptor(descriptor);
        }
        return object;
    }

    public List<ArgDescriptor> parseArgs(List<Element> argElements, Parse parse) {
        ArrayList<ArgDescriptor> args = null;
        if (argElements != null) {
            if (argElements.size() > 0) {
                args = new ArrayList<ArgDescriptor>(argElements.size());
            }
            for (Element argElement : argElements) {
                ArgDescriptor argDescriptor = new ArgDescriptor();
                argDescriptor.setTypeName(XmlUtil.attribute((Element)argElement, (String)"type"));
                Element descriptorElement = XmlUtil.element((Element)argElement);
                if (descriptorElement == null) {
                    parse.addProblem("arg must contain exactly one descriptor element out of " + this.bindings.getTagNames(CATEGORY_DESCRIPTOR) + " as contents:" + XmlUtil.toString((Node)argElement.getParentNode()));
                } else {
                    Descriptor descriptor = (Descriptor)this.parseElement(descriptorElement, parse, CATEGORY_DESCRIPTOR);
                    argDescriptor.setDescriptor(descriptor);
                }
                args.add(argDescriptor);
            }
        }
        return args;
    }

    static {
        defaultBindings = new Bindings();
        BindingParser bindingParser = new BindingParser();
        Enumeration<URL> enumeration = ReflectUtil.getResources(null, PVM_WIRE_BINDINGS_RESOURCES);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                LOG.trace("parsing bindings from resource url: " + url);
                bindingParser.createParse().setUrl(url).pushObject(defaultBindings).execute().checkProblems("default wire bindings");
            }
        }
    }
}

