/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.StackObjectPool;
import org.ow2.orchestra.util.Misc;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlUtil {
    private static DocumentBuilderFactory documentBuilderFactory;
    private static TransformerFactory transformerFactory;
    private static ObjectPool transformerPool;
    private static ObjectPool documentBuilderPool;

    private XmlUtil() {
    }

    public static List<Element> elements(Element element, String tagName) {
        ArrayList<Element> elements = null;
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element childElement;
                String childTagName;
                Node child = nodeList.item(i);
                if (!Element.class.isAssignableFrom(child.getClass()) || !(childTagName = XmlUtil.getTagLocalName(childElement = (Element)child)).equals(tagName)) continue;
                if (elements == null) {
                    elements = new ArrayList<Element>();
                }
                elements.add(childElement);
            }
        }
        return elements;
    }

    public static List<Element> elements(Element element, Set<String> allowedTagNames) {
        ArrayList<Element> elements = null;
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element childElement;
                String childTagName;
                Node child = nodeList.item(i);
                if (!Element.class.isAssignableFrom(child.getClass()) || !allowedTagNames.contains(childTagName = XmlUtil.getTagLocalName(childElement = (Element)child))) continue;
                if (elements == null) {
                    elements = new ArrayList<Element>();
                }
                elements.add(childElement);
            }
        }
        return elements;
    }

    public static Element element(Element element, String tagName) {
        Element childElement = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength() && childElement == null; ++i) {
            Node child = nodeList.item(i);
            if (!Element.class.isAssignableFrom(child.getClass()) || !XmlUtil.getTagLocalName((Element)child).equals(tagName)) continue;
            childElement = (Element)child;
        }
        return childElement;
    }

    public static Element element(Element element, String ns, String localName) {
        Element childElement = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength() && childElement == null; ++i) {
            Node child = nodeList.item(i);
            if (!Element.class.isAssignableFrom(child.getClass()) || child.getLocalName() == null || !child.getLocalName().equals(localName) || child.getNamespaceURI() == null || !child.getNamespaceURI().equals(ns)) continue;
            childElement = (Element)child;
        }
        return childElement;
    }

    public static List<Element> elements(Element element) {
        NodeList nodeList;
        ArrayList<Element> elements = null;
        if (element != null && (nodeList = element.getChildNodes()) != null && nodeList.getLength() > 0) {
            elements = new ArrayList<Element>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                elements.add((Element)node);
            }
        }
        return elements;
    }

    public static List<Element> elements(Element father, String ns, String localName) {
        ArrayList<Element> matchingElements = new ArrayList<Element>();
        NodeList nl = father.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element) || n.getLocalName() == null || !n.getLocalName().equals(localName) || n.getNamespaceURI() == null || !n.getNamespaceURI().equals(ns)) continue;
            matchingElements.add((Element)n);
        }
        return matchingElements;
    }

    public static List<Element> elementsQName(Element element, Set<QName> allowedTagNames) {
        ArrayList<Element> elements = null;
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element childElement;
                QName childElementQName;
                Node child = nodeList.item(i);
                if (!Element.class.isAssignableFrom(child.getClass()) || !allowedTagNames.contains(childElementQName = new QName((childElement = (Element)child).getNamespaceURI(), childElement.getLocalName()))) continue;
                if (elements == null) {
                    elements = new ArrayList<Element>();
                }
                elements.add(childElement);
            }
        }
        return elements;
    }

    public static Element element(Element element) {
        Element onlyChild = null;
        List<Element> elements = XmlUtil.elements(element);
        if (elements != null) {
            onlyChild = elements.get(0);
        }
        return onlyChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Node node) {
        if (node == null) {
            return null;
        }
        DOMSource source = new DOMSource(node);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StreamResult result = new StreamResult(printWriter);
        Transformer transformer = null;
        try {
            transformer = XmlUtil.getTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            Misc.log(Level.WARNING, "couldn't transform dom element into string representation", new Object[0]);
            if (node instanceof Element) {
                String string = "<" + ((Element)node).getTagName() + " ... >...</" + ((Element)node).getTagName() + ">";
                return string;
            }
            String string = node.getTextContent();
            return string;
        }
        finally {
            XmlUtil.returnTransformer(transformer);
        }
        printWriter.close();
        return stringWriter.toString();
    }

    public static String getContentText(Element element) {
        StringBuffer buffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof CharacterData)) continue;
            CharacterData characterData = (CharacterData)node;
            buffer.append(characterData.getData());
        }
        return buffer.toString();
    }

    public static boolean isTextOnly(Element element) {
        boolean isTextOnly = true;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength() && isTextOnly; ++i) {
            if (!Element.class.isAssignableFrom(nodeList.item(i).getClass())) continue;
            isTextOnly = false;
        }
        return isTextOnly;
    }

    public static List<Attr> attributes(Element element) {
        NamedNodeMap attributeMap = element.getAttributes();
        if (attributeMap == null || attributeMap.getLength() == 0) {
            return null;
        }
        ArrayList<Attr> attributes = new ArrayList<Attr>();
        for (int i = 0; i < attributeMap.getLength(); ++i) {
            attributes.add((Attr)attributeMap.item(i));
        }
        return attributes;
    }

    public static String getTagLocalName(Element element) {
        if (element == null) {
            return null;
        }
        String localName = element.getLocalName();
        if (localName != null) {
            return localName;
        }
        return element.getTagName();
    }

    public static String attribute(Element element, String attributeName) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    public static Boolean parseBooleanValue(String valueText) {
        if (valueText != null) {
            if ("true".equals(valueText) || "enabled".equals(valueText) || "on".equals(valueText)) {
                return Boolean.TRUE;
            }
            if ("false".equals(valueText) || "disabled".equals(valueText) || "off".equals(valueText)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static String errorMessageAttribute(Element element, String attributeName, String attributeValue, String message) {
        return "attribute <" + XmlUtil.getTagLocalName(element) + " " + attributeName + "=\"" + attributeValue + "\" " + message;
    }

    public static List<String> parseList(Element element, String singularTagName) {
        String text = XmlUtil.attribute(element, singularTagName + "s");
        if ("*".equals(text)) {
            text = null;
        }
        if (element.hasAttribute(singularTagName)) {
            String eventText = element.getAttribute(singularTagName);
            text = text == null ? eventText : text + "," + eventText;
        }
        List<String> eventNames = XmlUtil.parseCommaSeparatedList(text);
        return eventNames;
    }

    public static List<String> parseCommaSeparatedList(String commaSeparatedListText) {
        ArrayList<String> entries = null;
        if (commaSeparatedListText != null && !"*".equals(commaSeparatedListText)) {
            StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListText, ", ");
            while (tokenizer.hasMoreTokens()) {
                if (entries == null) {
                    entries = new ArrayList<String>();
                }
                entries.add(tokenizer.nextToken());
            }
        }
        return entries;
    }

    public static NamespaceValue attributeNamespaceValue(Element element, String attributeName) {
        NamespaceValue namespaceValue = null;
        String text = XmlUtil.attribute(element, attributeName);
        if (text != null) {
            int colonIndex = text.indexOf(58);
            if (colonIndex == -1) {
                namespaceValue = new NamespaceValue(null, text);
            } else {
                String prefix = text.substring(0, colonIndex);
                String localPart = null;
                if (text.length() > colonIndex + 1) {
                    localPart = text.substring(colonIndex + 1);
                }
                namespaceValue = new NamespaceValue(prefix, localPart);
            }
        }
        return namespaceValue;
    }

    public static QName attributeQName(Element element, String attributeName) {
        QName qname = null;
        NamespaceValue namespaceValue = XmlUtil.attributeNamespaceValue(element, attributeName);
        String text = XmlUtil.attribute(element, attributeName);
        if (namespaceValue != null) {
            if (namespaceValue.getPrefix() == null) {
                qname = new QName(text);
            } else {
                String uri = element.lookupNamespaceURI(namespaceValue.getPrefix());
                if (uri == null) {
                    throw new IllegalStateException("unknown prefix in qname " + text);
                }
                if (namespaceValue.getLocalPart() == null) {
                    throw new IllegalStateException("no local part in qname " + text);
                }
                qname = new QName(uri, namespaceValue.getLocalPart(), namespaceValue.getPrefix());
            }
        }
        return qname;
    }

    private static DocumentBuilderFactory getDocumentBuilderFactory() {
        if (documentBuilderFactory == null) {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return documentBuilderFactory;
    }

    public static TransformerFactory getTransformerFactory() {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
            try {
                transformerFactory.setAttribute("indent-number", "2");
            }
            catch (IllegalArgumentException e) {
                Misc.log(Level.FINEST, "Attribute 'indent-number' not supported by current transformer factory. Xml output may not be indented correctly.", new Object[0]);
            }
        }
        return transformerFactory;
    }

    public static QName getQNameFromString(Element element, String qnameAsString) {
        if (qnameAsString == null || element == null) {
            return null;
        }
        int colonIndex = qnameAsString.indexOf(":");
        String prefix = qnameAsString.substring(0, colonIndex);
        String localName = qnameAsString.substring(colonIndex + 1);
        String ns = XmlUtil.getNamespaceURI(element, prefix);
        return new QName(ns, localName, prefix);
    }

    public static String getNamespaceURI(Node n, String prefix) {
        Node prefixDeclaration = n.getAttributes().getNamedItem("xmlns:" + prefix);
        if (prefixDeclaration != null) {
            return prefixDeclaration.getNodeValue();
        }
        return XmlUtil.getNamespaceURI(n.getParentNode(), prefix);
    }

    private static Transformer getTransformer() {
        try {
            return (Transformer)transformerPool.borrowObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void returnTransformer(Transformer transformer) {
        if (transformer != null) {
            try {
                transformerPool.returnObject((Object)transformer);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static DocumentBuilder getDocumentBuilder() {
        try {
            return (DocumentBuilder)documentBuilderPool.borrowObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static void returnDocumentBuilder(DocumentBuilder documentBuilder) {
        if (documentBuilder != null) {
            try {
                documentBuilderPool.returnObject((Object)documentBuilder);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Document getNewDocument() {
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = XmlUtil.getDocumentBuilder();
            Document document = documentBuilder.newDocument();
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            XmlUtil.returnDocumentBuilder(documentBuilder);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeXmlFile(Document doc, File file) {
        Transformer transformer;
        block9: {
            transformer = null;
            FileOutputStream fos = null;
            try {
                DOMSource source = new DOMSource(doc);
                fos = new FileOutputStream(file);
                StreamResult result = new StreamResult(fos);
                transformer = XmlUtil.getTransformer();
                transformer.transform(source, result);
                if (fos == null) break block9;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Exception caught while writing xml file", e);
                }
                catch (Throwable throwable) {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                    XmlUtil.returnTransformer(transformer);
                    throw throwable;
                }
            }
            try {
                fos.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        XmlUtil.returnTransformer(transformer);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ByteArrayOutputStream getNodeAsBAOS(Node n) {
        ByteArrayOutputStream byteArrayOutputStream;
        Transformer transformer = null;
        try {
            DOMSource source = new DOMSource(n);
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            StreamResult res = new StreamResult(byteStream);
            transformer = XmlUtil.getTransformer();
            transformer.transform(source, res);
            byteArrayOutputStream = byteStream;
        }
        catch (ClassCastException e) {
            try {
                throw new RuntimeException(e);
                catch (Exception e2) {
                    throw new RuntimeException("Exception caugth when transforming node to bytestream", e2);
                }
            }
            catch (Throwable throwable) {
                XmlUtil.returnTransformer(transformer);
                throw throwable;
            }
        }
        XmlUtil.returnTransformer(transformer);
        return byteArrayOutputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ByteArrayOutputStream getNodeAsBAOS(Node n, Integer deflateLevel) {
        ByteArrayOutputStream byteArrayOutputStream;
        Transformer transformer;
        block11: {
            transformer = null;
            OutputStream deflaterStream = null;
            try {
                DOMSource source = new DOMSource(n);
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                StreamResult res = null;
                if (deflateLevel == null) {
                    res = new StreamResult(byteStream);
                } else {
                    Deflater deflater = new Deflater(deflateLevel);
                    deflaterStream = new DeflaterOutputStream((OutputStream)byteStream, deflater);
                    res = new StreamResult(deflaterStream);
                }
                transformer = XmlUtil.getTransformer();
                transformer.transform(source, res);
                byteArrayOutputStream = byteStream;
                if (deflaterStream == null) break block11;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Exception caugth when transforming node to string", e);
                }
                catch (Throwable throwable) {
                    if (deflaterStream != null) {
                        try {
                            deflaterStream.close();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                    XmlUtil.returnTransformer(transformer);
                    throw throwable;
                }
            }
            try {
                deflaterStream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        XmlUtil.returnTransformer(transformer);
        return byteArrayOutputStream;
    }

    public static Document getDocumentFromString(String s) {
        String prolog = "<?xml";
        if (s.startsWith("<?xml")) {
            String prologEnd = "?>";
            int prologEndIndex = s.indexOf("?>");
            s = s.substring(prologEndIndex + "?>".length());
        }
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = XmlUtil.getDocumentBuilder();
            Document prologEndIndex = documentBuilder.parse(new InputSource(new StringReader(s)));
            return prologEndIndex;
        }
        catch (Exception e) {
            throw new RuntimeException("Esception while building a document from string : " + s, e);
        }
        finally {
            XmlUtil.returnDocumentBuilder(documentBuilder);
        }
    }

    public static Document getDocumentFromInputStream(InputStream is) {
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = XmlUtil.getDocumentBuilder();
            Document document = documentBuilder.parse(is);
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while building a document from input stream : " + is, e);
        }
        finally {
            XmlUtil.returnDocumentBuilder(documentBuilder);
        }
    }

    public static Document getDocumentFromReader(Reader r) {
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = XmlUtil.getDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(r));
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while building a document from reader : " + r, e);
        }
        finally {
            XmlUtil.returnDocumentBuilder(documentBuilder);
        }
    }

    public static Document getDocumentFromFile(File xmlFile) {
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = XmlUtil.getDocumentBuilder();
            Document document = documentBuilder.parse(xmlFile);
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse successfully xml file : " + xmlFile, e);
        }
        finally {
            XmlUtil.returnDocumentBuilder(documentBuilder);
        }
    }

    public static Document getDocumentFromURL(URL xmlUrl) {
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = XmlUtil.getDocumentBuilder();
            InputStream inStream = xmlUrl.openStream();
            Document document = documentBuilder.parse(inStream);
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse successfully xml url : " + xmlUrl, e);
        }
        finally {
            XmlUtil.returnDocumentBuilder(documentBuilder);
        }
    }

    public static Element getDocumentWithOneElement(QName elementQName) {
        Document document = XmlUtil.getNewDocument();
        Element rootElement = document.createElementNS(elementQName.getNamespaceURI(), elementQName.getLocalPart());
        document.appendChild(rootElement);
        return rootElement;
    }

    static {
        transformerPool = new StackObjectPool((PoolableObjectFactory)new PoolTransformerFactory());
        documentBuilderPool = new StackObjectPool((PoolableObjectFactory)new PoolDocumentBuilderFactory());
    }

    private static class PoolDocumentBuilderFactory
    extends BasePoolableObjectFactory {
        private PoolDocumentBuilderFactory() {
        }

        public Object makeObject() {
            try {
                DocumentBuilderFactory myDocumentBuilderFactory = XmlUtil.getDocumentBuilderFactory();
                myDocumentBuilderFactory.setNamespaceAware(true);
                myDocumentBuilderFactory.setExpandEntityReferences(false);
                return myDocumentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }

        public void passivateObject(Object obj) {
            ((DocumentBuilder)obj).reset();
        }
    }

    private static class PoolTransformerFactory
    extends BasePoolableObjectFactory {
        private PoolTransformerFactory() {
        }

        public Object makeObject() {
            try {
                return XmlUtil.getTransformerFactory().newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException(e);
            }
        }

        public void passivateObject(Object obj) {
            Transformer transformer = (Transformer)obj;
            transformer.setOutputProperties(null);
            transformer.clearParameters();
        }
    }

    public static class NamespaceValue {
        private String prefix;
        private String localPart;

        public NamespaceValue(String prefix, String localPart) {
            this.setPrefix(prefix);
            this.setLocalPart(localPart);
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setLocalPart(String localPart) {
            this.localPart = localPart;
        }

        public String getLocalPart() {
            return this.localPart;
        }
    }
}

