/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.xa;

import java.util.HashSet;
import java.util.Set;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.transaction.TransactionContext;
import net.sf.ehcache.transaction.xa.EhcacheXAException;
import net.sf.ehcache.transaction.xa.EhcacheXAResource;
import net.sf.ehcache.transaction.xa.EhcacheXAStore;
import net.sf.ehcache.transaction.xa.PreparedCommand;
import net.sf.ehcache.transaction.xa.PreparedContext;
import net.sf.ehcache.transaction.xa.TransactionXARequestProcessor;
import net.sf.ehcache.transaction.xa.VersionAwareCommand;
import net.sf.ehcache.transaction.xa.XARequest;
import net.sf.ehcache.transaction.xa.XARequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcacheXAResourceImpl
implements EhcacheXAResource {
    private static final int DEFAULT_TIMEOUT = 60;
    private static final Logger LOG = LoggerFactory.getLogger((String)EhcacheXAResourceImpl.class.getName());
    private final String cacheName;
    private final XARequestProcessor processor;
    private final EhcacheXAStore ehcacheXAStore;
    private final Store store;
    private final Store oldVersionStore;
    private final TransactionManager txnManager;
    private final Ehcache cache;
    private final ThreadLocal<Xid> currentXid = new ThreadLocal();
    private final Set<Xid> recoverySet = new HashSet<Xid>();
    private volatile int transactionTimeout = 60;

    public EhcacheXAResourceImpl(Ehcache cache, TransactionManager txnManager, EhcacheXAStore ehcacheXAStore) {
        this.cacheName = cache.getName();
        this.store = ehcacheXAStore.getUnderlyingStore();
        this.txnManager = txnManager;
        this.ehcacheXAStore = ehcacheXAStore;
        this.oldVersionStore = ehcacheXAStore.getOldVersionStore();
        this.cache = cache;
        this.processor = new TransactionXARequestProcessor(this);
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("xaResource.start called for Txn with flag: " + this.prettyPrintFlags(flags) + " and id: " + xid);
        }
        this.currentXid.set(xid);
    }

    public void end(Xid xid, int flags) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("xaResource.end called for Txn with flag: " + this.prettyPrintFlags(flags) + " and id: " + xid);
        }
        if (this.isFlagSet(flags, 0x20000000)) {
            if (this.ehcacheXAStore.isPrepared(xid)) {
                this.markContextForRollback(xid);
            } else {
                this.ehcacheXAStore.removeData(xid);
            }
        }
        this.currentXid.remove();
    }

    public int prepare(Xid xid) throws XAException {
        return this.processor.process(new XARequest(XARequest.RequestType.PREPARE, this.getCurrentTransaction(), xid, 0));
    }

    int prepareInternal(Xid xid) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("xaResource.prepare called for Txn with id: " + xid);
        }
        TransactionContext context = this.ehcacheXAStore.getTransactionContext(xid);
        CacheLockProvider storeLockProvider = (CacheLockProvider)this.store.getInternalContext();
        CacheLockProvider oldVersionStoreLockProvider = (CacheLockProvider)this.oldVersionStore.getInternalContext();
        this.validateCommands(context, xid);
        PreparedContext preparedContext = this.ehcacheXAStore.createPreparedContext();
        for (VersionAwareCommand command : context.getCommands()) {
            Object key = command.getKey();
            if (key == null) continue;
            this.prepareCommand(xid, oldVersionStoreLockProvider, preparedContext, command);
        }
        Sync[] syncForKeys = storeLockProvider.getAndWriteLockAllSyncForKeys(preparedContext.getUpdatedKeys().toArray());
        boolean writes = false;
        for (VersionAwareCommand command : context.getCommands()) {
            writes = command.execute(this.store) || writes;
        }
        this.ehcacheXAStore.prepare(xid, preparedContext);
        return writes ? 0 : 3;
    }

    public void forget(Xid xid) throws XAException {
        this.processor.process(new XARequest(XARequest.RequestType.FORGET, this.getCurrentTransaction(), xid));
    }

    void forgetInternal(Xid xid) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("xaResource.forget called for Txn with id: " + xid);
        }
        if (this.ehcacheXAStore.isPrepared(xid)) {
            this.markContextForRollback(xid);
        } else {
            this.ehcacheXAStore.removeData(xid);
        }
    }

    public Xid[] recover(int flags) throws XAException {
        Xid[] allPreparedXids;
        if (LOG.isDebugEnabled()) {
            LOG.debug("xaResource.recover called for Txn with flag: " + this.prettyPrintFlags(flags));
        }
        HashSet<Xid> xids = new HashSet<Xid>();
        if (this.isFlagSet(flags, 0x1000000)) {
            this.recoverySet.clear();
        }
        for (Xid preparedXid : allPreparedXids = this.ehcacheXAStore.getPreparedXids()) {
            if (!this.recoverySet.contains(preparedXid)) {
                xids.add(preparedXid);
            }
            this.recoverySet.add(preparedXid);
        }
        for (Xid preparedXid : xids) {
            this.markContextForRollback(preparedXid);
        }
        Xid[] toRecover = xids.toArray(new Xid[xids.size()]);
        if (this.isFlagSet(flags, 0x800000)) {
            this.recoverySet.clear();
        }
        return toRecover;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        Transaction txn = this.getCurrentTransaction();
        this.processor.process(new XARequest(XARequest.RequestType.COMMIT, txn, xid, 0, onePhase));
    }

    void commitInternal(Xid xid, boolean onePhase) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("xaResource.commit called for Txn with phase: " + (onePhase ? "onePhase" : "twoPhase") + " and id: " + xid);
        }
        if (onePhase) {
            this.onePhaseCommit(xid);
        } else {
            PreparedContext context = this.ehcacheXAStore.getPreparedContext(xid);
            CacheLockProvider storeProvider = (CacheLockProvider)this.store.getInternalContext();
            CacheLockProvider oldVersionStoreProvider = (CacheLockProvider)this.oldVersionStore.getInternalContext();
            Set<Object> preparedKeys = context.getUpdatedKeys();
            if (!context.isCommitted() && !context.isRolledBack()) {
                Sync[] syncForKeys = oldVersionStoreProvider.getAndWriteLockAllSyncForKeys(preparedKeys.toArray());
                for (PreparedCommand command : context.getPreparedCommands()) {
                    Object key = command.getKey();
                    if (key == null) continue;
                    this.ehcacheXAStore.checkin(key, xid, command.isWriteCommand());
                    this.oldVersionStore.remove(key);
                }
                storeProvider.unlockWriteLockForAllKeys(preparedKeys.toArray());
                oldVersionStoreProvider.unlockWriteLockForAllKeys(preparedKeys.toArray());
                context.setCommitted(true);
            } else if (context.isRolledBack()) {
                throw new EhcacheXAException("Transaction " + xid + " has been heuristically rolled back", 6);
            }
        }
        this.ehcacheXAStore.removeData(xid);
    }

    public void rollback(Xid xid) throws XAException {
        this.processor.process(new XARequest(XARequest.RequestType.ROLLBACK, this.getCurrentTransaction(), xid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackInternal(Xid xid) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("xaResource.rollback called for Txn with id: " + xid);
        }
        PreparedContext context = this.ehcacheXAStore.getPreparedContext(xid);
        if (this.ehcacheXAStore.isPrepared(xid) && !context.isRolledBack() && !context.isCommitted()) {
            context.setRolledBack(true);
            CacheLockProvider storeLockProvider = (CacheLockProvider)this.store.getInternalContext();
            CacheLockProvider oldVersionStoreLockProvider = (CacheLockProvider)this.oldVersionStore.getInternalContext();
            for (PreparedCommand command : context.getPreparedCommands()) {
                Object key = command.getKey();
                if (key == null) continue;
                Sync syncForKey = oldVersionStoreLockProvider.getSyncForKey(key);
                syncForKey.lock(LockType.WRITE);
                Element element = null;
                try {
                    element = this.oldVersionStore.remove(key);
                    if (element != null) {
                        this.store.put(element);
                        continue;
                    }
                    LOG.error("No element found in oldVersionStore for key '{}'", key);
                }
                finally {
                    syncForKey.unlock(LockType.WRITE);
                    if (element == null) continue;
                    storeLockProvider.getSyncForKey(key).unlock(LockType.WRITE);
                }
            }
        } else if (context != null && context.isCommitted()) {
            throw new EhcacheXAException("Transaction " + xid + " has been heuristically committed", 6);
        }
        this.ehcacheXAStore.removeData(xid);
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        return this == xaResource;
    }

    public boolean setTransactionTimeout(int i) throws XAException {
        if (i < 0) {
            throw new EhcacheXAException("time out has to be > 0, but was " + i, -5);
        }
        this.transactionTimeout = i == 0 ? 60 : i;
        return true;
    }

    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    public Store getStore() {
        return this.store;
    }

    public TransactionContext getOrCreateTransactionContext() throws SystemException, RollbackException {
        Transaction transaction = this.txnManager.getTransaction();
        if (transaction == null) {
            throw new CacheException("Cache " + this.cacheName + " can only be accessed within a JTA Transaction!");
        }
        if (transaction.getStatus() != 0) {
            throw new CacheException("Transaction not active!");
        }
        TransactionContext context = null;
        if (this.currentXid.get() != null) {
            context = this.ehcacheXAStore.getTransactionContext(this.currentXid.get());
        }
        if (context == null) {
            transaction.enlistResource((XAResource)this);
            if (this.cache.getWriterManager() != null) {
                try {
                    transaction.registerSynchronization((Synchronization)new CacheWriterManagerSynchronization(this.currentXid.get()));
                }
                catch (RollbackException e) {
                }
                catch (SystemException e) {
                    throw new CacheException("Couldn't register CacheWriter's Synchronization with the JTA Transaction : " + e.getMessage(), e);
                }
            }
            context = this.ehcacheXAStore.createTransactionContext(this.currentXid.get());
        }
        return context;
    }

    public Element get(Object key) {
        Element element = this.oldVersionStore.get(key);
        if (element == null) {
            element = this.store.get(key);
        }
        return element;
    }

    public Element getQuiet(Object key) {
        Element element = this.oldVersionStore.getQuiet(key);
        if (element == null) {
            element = this.store.getQuiet(key);
        }
        return element;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EhcacheXAResource) {
            EhcacheXAResource resource2 = (EhcacheXAResource)obj;
            return this.cacheName.equals(resource2.getCacheName());
        }
        return false;
    }

    public int hashCode() {
        return this.cacheName.hashCode();
    }

    private Transaction getCurrentTransaction() throws EhcacheXAException {
        Transaction txn;
        try {
            txn = this.txnManager.getTransaction();
        }
        catch (SystemException e) {
            throw new EhcacheXAException("Couldn't get to current Transaction: " + e.getMessage(), e.errorCode, e);
        }
        return txn;
    }

    private void onePhaseCommit(Xid xid) throws XAException {
        TransactionContext context = this.ehcacheXAStore.getTransactionContext(xid);
        CacheLockProvider storeLockProvider = (CacheLockProvider)this.store.getInternalContext();
        this.validateCommands(context, xid);
        Set<Object> keys = context.getUpdatedKeys();
        Sync[] syncForKeys = storeLockProvider.getAndWriteLockAllSyncForKeys(keys.toArray());
        LOG.debug("{} phase commit called for Txn with id: {} One", (Object)xid);
        boolean writes = false;
        for (VersionAwareCommand command : context.getCommands()) {
            boolean bl = writes = command.execute(this.store) || writes;
            Object key = command.getKey();
            if (key == null) continue;
            this.ehcacheXAStore.checkin(key, xid, command.isWriteCommand());
        }
        for (Sync syncForKey : syncForKeys) {
            syncForKey.unlock(LockType.WRITE);
        }
    }

    private void validateCommands(TransactionContext context, Xid xid) throws XAException {
        for (VersionAwareCommand command : context.getCommands()) {
            if (!command.isVersionAware() || this.ehcacheXAStore.isValid(command, xid)) continue;
            throw new EhcacheXAException("Invalid version for element: " + command.getKey(), 103);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareCommand(Xid xid, CacheLockProvider oldVersionStoreLockProvider, PreparedContext preparedContext, VersionAwareCommand command) throws EhcacheXAException {
        Sync syncForKey = oldVersionStoreLockProvider.getSyncForKey(command.getKey());
        syncForKey.lock(LockType.WRITE);
        try {
            if (!this.ehcacheXAStore.isValid(command, xid)) {
                for (PreparedCommand addedCommand : preparedContext.getPreparedCommands()) {
                    this.oldVersionStore.remove(addedCommand.getKey());
                }
                throw new EhcacheXAException("Invalid version for element: " + command.getKey(), 103);
            }
            this.oldVersionStore.put(this.store.get(command.getKey()));
            preparedContext.addCommand(command);
        }
        finally {
            syncForKey.unlock(LockType.WRITE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markContextForRollback(Xid preparedXid) throws EhcacheXAException {
        PreparedContext context = this.ehcacheXAStore.getPreparedContext(preparedXid);
        Set<Object> updatedKeys = context.getUpdatedKeys();
        if (!updatedKeys.isEmpty()) {
            boolean readLocked;
            Object someKey = updatedKeys.iterator().next();
            Sync syncForKey = ((CacheLockProvider)this.store.getInternalContext()).getSyncForKey(someKey);
            try {
                readLocked = syncForKey.tryLock(LockType.READ, 1L);
            }
            catch (InterruptedException e) {
                throw new EhcacheXAException("Interrupted testing for Xid's status: " + preparedXid, -7);
            }
            if (readLocked) {
                try {
                    for (Object updatedKey : updatedKeys) {
                        this.oldVersionStore.remove(updatedKey);
                    }
                    context.setRolledBack(true);
                    this.ehcacheXAStore.prepare(preparedXid, context);
                }
                finally {
                    syncForKey.unlock(LockType.READ);
                }
            }
        }
    }

    private boolean isFlagSet(int flags, int mask) {
        return mask == (flags & mask);
    }

    private String printFlag(int flags, int mask, String flagStr) {
        return this.isFlagSet(flags, mask) ? flagStr : "";
    }

    private String prettyPrintFlags(int flags) {
        StringBuffer flagStrings = new StringBuffer();
        flagStrings.append(this.printFlag(flags, 0x800000, "TMENDRSCAN "));
        flagStrings.append(this.printFlag(flags, 0x20000000, "TMFAIL "));
        flagStrings.append(this.printFlag(flags, 0x200000, "TMJOIN "));
        flagStrings.append(this.printFlag(flags, 0x40000000, "TMONEPHASE "));
        flagStrings.append(this.printFlag(flags, 0x8000000, "TMRESUME "));
        flagStrings.append(this.printFlag(flags, 0x1000000, "TMSTARTRSCAN "));
        flagStrings.append(this.printFlag(flags, 0x4000000, "TMSUCCESS "));
        flagStrings.append(this.printFlag(flags, 0x2000000, "TMSUSPEND "));
        String flagStr = flagStrings.toString();
        return flagStr.equals("") ? "TMNOFLAGS" : flagStr;
    }

    public String toString() {
        return "EhcacheXAResourceImpl [ " + this.getCacheName() + " ] ";
    }

    private class CacheWriterManagerSynchronization
    implements Synchronization {
        private Xid currentXid;

        public CacheWriterManagerSynchronization(Xid currentXid) {
            this.currentXid = currentXid;
        }

        public void beforeCompletion() {
            try {
                TransactionContext context = EhcacheXAResourceImpl.this.getOrCreateTransactionContext();
                for (VersionAwareCommand versionAwareCommand : context.getCommands()) {
                    versionAwareCommand.execute(EhcacheXAResourceImpl.this.cache.getWriterManager());
                }
            }
            catch (SystemException e) {
                throw new CacheException("Error synching writer", e);
            }
            catch (RollbackException rollbackException) {
                // empty catch block
            }
        }

        public void afterCompletion(int status) {
        }
    }
}

