/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade.data.runtime;

import java.util.Date;
import org.ow2.orchestra.facade.data.AbstractData;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;

public class TimerData
extends AbstractData {
    private final ActivityInstanceUUID activityInstanceUUID;
    private final ActivityDefinitionUUID activityDefinitionUUID;
    private final Date expectedStartedDate;

    public TimerData(TimerData waitingActivity) {
        this.activityInstanceUUID = waitingActivity.getActivityInstanceUUID();
        this.activityDefinitionUUID = waitingActivity.getActivityDefinitionUUID();
        this.expectedStartedDate = new Date(waitingActivity.getExpectedStartedDate().getTime());
    }

    public TimerData(ActivityInstanceUUID activityInstanceUUID, ActivityDefinitionUUID activityDefinitionUUID, Date expectedStartedDate) {
        this.activityInstanceUUID = activityInstanceUUID;
        this.activityDefinitionUUID = activityDefinitionUUID;
        this.expectedStartedDate = new Date(expectedStartedDate.getTime());
    }

    public ActivityInstanceUUID getActivityInstanceUUID() {
        return this.activityInstanceUUID;
    }

    public ActivityDefinitionUUID getActivityDefinitionUUID() {
        return this.activityDefinitionUUID;
    }

    public Date getExpectedStartedDate() {
        return new Date(this.expectedStartedDate.getTime());
    }
}

