/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade.exception;

import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;

public class BpelFaultException
extends OrchestraRuntimeException {
    private static final long serialVersionUID = 1L;
    protected QName faultName;

    protected BpelFaultException() {
    }

    public BpelFaultException(QName faultName) {
        this.faultName = faultName;
    }

    public BpelFaultException(QName faultName, String message) {
        super(message);
        this.faultName = faultName;
    }

    public BpelFaultException(QName faultName, String message, Exception e) {
        super(message, e);
        this.faultName = faultName;
    }

    public static BpelFaultException generateBpelFaultException(BpelFault fault) {
        if (fault != null) {
            return new BpelFaultException(fault.getQName());
        }
        return null;
    }

    public static BpelFaultException generateBpelFaultException(BpelFault fault, String message, Exception cause) {
        if (fault != null) {
            return new BpelFaultException(fault.getQName(), message, cause);
        }
        return null;
    }

    public QName getFaultName() {
        return this.faultName;
    }

    public BpelFaultException copy() {
        return new BpelFaultException(this.getFaultName(), this.getMessage());
    }

    public BpelFaultException fullCopy() {
        return this.copy();
    }

    public String toString() {
        return "BpelFaultException: " + this.getFaultName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BpelFault {
        completionConditionFailure,
        conflictingReceive,
        conflictingRequest,
        invalidReply,
        invalidVariables,
        joinFailure,
        mismatchedAssignmentFailure,
        missingReply,
        missingRequest,
        repeatedCompensation,
        scopeInitializationFailure,
        selectionFailure,
        subLanguageExecutionFault,
        uninitializedPartnerRole,
        uninitializedVariable,
        unsupportedReference,
        invalidExpressionValue,
        invalidBranchCondition,
        correlationViolation,
        xsltStylesheetNotFound;

        public static final String XMLNS_BPEL_2_0_EXECUTABLE = "http://docs.oasis-open.org/wsbpel/2.0/process/executable";

        public QName getQName() {
            return new QName(XMLNS_BPEL_2_0_EXECUTABLE, this.name());
        }
    }
}

