/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade.runtime.impl;

import java.util.Date;
import org.ow2.orchestra.facade.runtime.Message;
import org.ow2.orchestra.facade.runtime.VariableUpdate;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VariableUpdateImpl
implements VariableUpdate {
    private static final long serialVersionUID = -2069580133901045271L;
    private final ActivityInstanceUUID activityUUID;
    private final Date date;
    private final String name;
    private String xmlValue;
    private Message messageValue;

    public VariableUpdateImpl(VariableUpdate record) {
        this.activityUUID = record.getActivityUUID();
        this.date = new Date(record.getDate().getTime());
        this.name = record.getName();
        Object value = record.getValue();
        if (value != null) {
            if (value instanceof Message) {
                this.messageValue = (Message)((Message)value).copy();
            } else if (value instanceof Element) {
                this.xmlValue = XmlUtil.toString((Node)((Element)value));
            } else {
                Misc.unreachableStatement((String)"unknown variable type");
            }
        }
    }

    public ActivityInstanceUUID getActivityUUID() {
        return this.activityUUID;
    }

    public Date getDate() {
        return new Date(this.date.getTime());
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.xmlValue != null ? this.xmlValue : this.messageValue;
    }

    public String toString() {
        return "Update " + this.name + " at " + this.date + " by " + this.activityUUID + " to value [" + this.getValue() + "]";
    }

    public VariableUpdate copy() {
        return new VariableUpdateImpl(this);
    }
}

