/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.interceptor.description;

import org.ow2.petals.component.framework.api.Interceptor;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;

public final class InterceptorBuilder {
    private InterceptorBuilder() {
    }

    public static Interceptor loadInstance(String className) throws PEtALSCDKException {
        Interceptor interceptor = null;
        Class<?> clazz = InterceptorBuilder.loadClass(className);
        try {
            Object o = clazz.newInstance();
            if (!(o instanceof Interceptor)) {
                throw new PEtALSCDKException("Invalid class, " + className + " is not an interceptor");
            }
            interceptor = (Interceptor)o;
        }
        catch (InstantiationException e) {
            throw new PEtALSCDKException("Can not instanciate interceptor", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PEtALSCDKException("Illegal access to interceptor", (Throwable)e);
        }
        return interceptor;
    }

    protected static Class<?> loadClass(String className) throws PEtALSCDKException {
        Class<?> clazz;
        ClassLoader classloader = InterceptorBuilder.class.getClassLoader();
        try {
            clazz = classloader.loadClass(className);
            if (clazz == null) {
                throw new PEtALSCDKException("Could not find interceptor class : " + className);
            }
        }
        catch (ClassNotFoundException e) {
            throw new PEtALSCDKException("Class not found interceptor class : " + className, (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new PEtALSCDKException("Null class : " + className);
        }
        return clazz;
    }
}

