/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.notification;

import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfReferenceParametersType;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Message;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationWriter;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import java.util.logging.Logger;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.notification.NotificationBrokerController;
import org.ow2.petals.component.framework.api.notification.NotificationConsumer;
import org.ow2.petals.component.framework.api.notification.NotificationProducer;
import org.ow2.petals.component.framework.api.notification.Transformer;
import org.ow2.petals.component.framework.notification.ComponentNotificationConsumer;
import org.ow2.petals.component.framework.notification.ComponentNotificationProducer;
import org.ow2.petals.component.framework.notification.ComponentTransformer;
import org.ow2.petals.component.framework.notification.Sender;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ComponentNotificationBrokerController
implements NotificationBrokerController {
    private EndpointReferenceType publisherRegistrationReference = null;
    private EndpointReferenceType consumerReference = null;
    private Sender sender = null;
    private Transformer transformer = null;
    private NotificationProducer notificationProducer = null;
    private NotificationConsumer notificationConsumer = null;
    private WSNotificationWriter wsnWriter = WSNotificationWriter.getInstance();
    private Logger logger = null;

    public ComponentNotificationBrokerController(Logger logger, ComponentContext componentContext) throws WSNotificationException, WSDLException, WSAddressingException, WSNotificationExtensionException, MessagingException {
        this.sender = new Sender(componentContext);
        this.logger = logger;
        this.notificationProducer = new ComponentNotificationProducer(componentContext.getDeliveryChannel(), logger, this);
        this.notificationConsumer = new ComponentNotificationConsumer(componentContext.getDeliveryChannel(), logger);
        this.transformer = new ComponentTransformer(this.notificationProducer.getNotificationProducerSOAParameter(), this.notificationProducer.getSubscriptionManagerSOAParameter(), this.notificationConsumer.getNotificationConsumerSOAParameter());
    }

    public final Transformer getTransformer() {
        return this.transformer;
    }

    public final void destroyRegistration() throws WSNotificationException, WSNotificationExtensionException, WSAddressingException, MessagingException, PEtALSCDKException {
        this.logger.fine("Destroying the registration...");
        DestroyRegistration destroyRegistration = WSNotificationFactory.getInstance().createDestroyRegistration();
        if (this.publisherRegistrationReference != null) {
            ResourcesUuidType resourcesUuidType = WsnSpecificTypeHelper.getResourcesUuidType((ReferenceParametersType)((ReferenceParametersType)this.publisherRegistrationReference.getReferenceParameters()));
            WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)resourcesUuidType, (DestroyRegistration)destroyRegistration);
        } else {
            this.logger.fine("No publisher registration so no uuid provided for destroy registration");
        }
        this.sender.send(destroyRegistration);
        this.logger.fine("Registration destroyed");
    }

    public final String getCurrentMessage() throws WSNotificationException, MessagingException, PEtALSCDKException, WSAddressingException {
        throw new NotImplementedException();
    }

    public final void notify(Document document, String topic, EndpointReferenceType subscriptionReference) throws WSNotificationException, MessagingException, PEtALSCDKException, WSAddressingException, WSDLException, WSNotificationExtensionException {
        SOAParameterType soaParameter = null;
        Notify notify = WSNotificationFactory.getInstance().createNotify();
        NotificationMessageHolderType notificationMessageHolderType = WSNotificationFactory.getInstance().createNotificationMessageHolderType();
        notificationMessageHolderType.setSubscriptionReference(subscriptionReference);
        TopicExpressionType topicExpressionType = WSNotificationFactory.getInstance().createTopicExpressionType();
        topicExpressionType.addTopicNameSpace("petals", "http://petals.ow2.org/topic");
        topicExpressionType.setDialect("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete");
        topicExpressionType.setContent(topic);
        notificationMessageHolderType.setTopic(topicExpressionType);
        EndpointReferenceType producerReference = WSAddressingFactory.getInstance().newEndpointReferenceType();
        ReferenceParametersType referenceParametersType = (ReferenceParametersType)producerReference.newReferenceParameters();
        soaParameter = this.notificationProducer.getNotificationProducerSOAParameter();
        WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)soaParameter, (ReferenceParametersType)referenceParametersType);
        producerReference.setReferenceParameters((AbsItfReferenceParametersType)referenceParametersType);
        notificationMessageHolderType.setProducerReference(producerReference);
        Message msg = WSNotificationFactory.getInstance().createMessage();
        WsnSpecificTypeHelper.setContentToMessage((Element)document.getDocumentElement(), (Message)msg);
        notificationMessageHolderType.setMessage(msg);
        notify.addNotificationMessage(notificationMessageHolderType);
        this.sender.send(notify, this.consumerReference);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void registerPublisher() throws WSNotificationException, MessagingException, PEtALSCDKException, WSAddressingException, WSNotificationExtensionException {
        this.logger.fine("Registering as publisher...");
        RegisterPublisher registerPublisher = WSNotificationFactory.getInstance().createRegisterPublisher();
        registerPublisher = this.transformer.addNotificationProducerSOAParameter(registerPublisher);
        TopicExpressionType topic = WSNotificationFactory.getInstance().createTopicExpressionType();
        topic.addTopicNameSpace("petals", "http://petals.ow2.org/topic");
        topic.setDialect("http://www.w3.org/TR/1999/REC-xpath-19991116");
        topic.setContent("petals:component/cdk//*[@wstop:topic='true']");
        registerPublisher.addTopic(topic);
        registerPublisher.setDemand(Boolean.valueOf(true));
        RegisterPublisherResponse registerPublisherResponse = this.sender.send(registerPublisher);
        if (registerPublisherResponse == null) throw new PEtALSCDKException("No response from the broker");
        this.publisherRegistrationReference = registerPublisherResponse.getPublisherRegistrationReference();
        if (this.publisherRegistrationReference == null) throw new PEtALSCDKException("The publisher reference MUST appear because the demand component has value \"true\"");
        if (registerPublisherResponse.getConsumerReference() != null) {
            this.consumerReference = registerPublisherResponse.getConsumerReference();
        }
        this.logger.fine("Publisher registered");
    }

    public void renew() {
        throw new NotImplementedException();
    }

    public void subscribe() throws WSNotificationException, MessagingException, PEtALSCDKException, WSAddressingException {
        throw new NotImplementedException();
    }

    public void unsubscribe() throws WSNotificationException, MessagingException, PEtALSCDKException, WSAddressingException {
        throw new NotImplementedException();
    }

    public final boolean isBrokeredNotification(MessageExchange messageExchange) {
        if (messageExchange == null || messageExchange.getInterfaceName() == null || messageExchange.getInterfaceName().getNamespaceURI() == null) {
            return false;
        }
        return "http://docs.oasis-open.org/wsn/brw-2".equals(messageExchange.getInterfaceName().getNamespaceURI());
    }

    public final NotificationProducer getNotificationProducer() {
        return this.notificationProducer;
    }

    public final NotificationConsumer getNotificationConsumer() {
        return this.notificationConsumer;
    }

    public final void setNotificationBrokerReferenceAddress(String notificationBrokerReferenceAddress) {
        this.transformer.setNotificationBrokerReferenceAddress(notificationBrokerReferenceAddress);
    }

    public final void setPublisherRegistrationManagerReferenceAddress(String publisherRegistrationManagerReferenceAddress) {
        this.transformer.setPublisherRegistrationManagerReferenceAddress(publisherRegistrationManagerReferenceAddress);
    }

    public final void setSubscriptionManagerReferenceAddress(String subscriptionManagerReferenceAddress) {
        this.transformer.setSubscriptionManagerReferenceAddress(subscriptionManagerReferenceAddress);
    }

    public final boolean isInternalNotification(String address) {
        return "http://petals.ow2.org/cdk".equals(address);
    }

    public final WSNotificationWriter getWsnWriter() {
        return this.wsnWriter;
    }
}

