/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.notification;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.WsnbConstants;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.WsnbrConstants;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationReader;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationWriter;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import java.util.ArrayList;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.ow2.petals.component.framework.api.Constants;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.notification.NotificationServiceEndpoint;
import org.ow2.petals.component.framework.util.UtilFactory;
import org.w3c.dom.Document;

public class Sender {
    private ComponentContext componentContext = null;
    @Deprecated
    private MessageExchangeFactory notificationBrokerMessageExchangeFactory = null;
    @Deprecated
    private MessageExchangeFactory publisherRegistrationMessageExchangeFactory = null;
    @Deprecated
    private MessageExchangeFactory subscriptionManagerMessageExchangeFactory = null;
    private MessageExchangeFactory messageExchangeFactory = null;

    public Sender(ComponentContext componentContext) throws WSNotificationException, MessagingException {
        this.componentContext = componentContext;
        this.notificationBrokerMessageExchangeFactory = componentContext.getDeliveryChannel().createExchangeFactory(Constants.Notification.NOTIFICATION_BROKER_INTERFACE);
        this.publisherRegistrationMessageExchangeFactory = componentContext.getDeliveryChannel().createExchangeFactory(Constants.Notification.PUBLISHER_REGISTRATION_MANAGER_INTERFACE);
        this.subscriptionManagerMessageExchangeFactory = componentContext.getDeliveryChannel().createExchangeFactory(Constants.Notification.SUBSCRIPTION_INTERFACE);
        this.messageExchangeFactory = componentContext.getDeliveryChannel().createExchangeFactory();
    }

    @Deprecated
    public DestroyRegistrationResponse send(DestroyRegistration destroyRegistration) throws MessagingException, WSNotificationException, PEtALSCDKException {
        DestroyRegistrationResponse destroyRegistrationResponse = null;
        Document document = WSNotificationWriter.getInstance().writeDestroyRegistration(destroyRegistration);
        if ((document = this.send(document, (MessageExchange)this.publisherRegistrationMessageExchangeFactory.createInOutExchange(), WsnbrConstants.DESTROY_REGISTRATION_QNAME, true)) != null) {
            destroyRegistrationResponse = WSNotificationReader.getInstance().readDestroyRegistrationResponse(document);
        }
        return destroyRegistrationResponse;
    }

    public DestroyRegistrationResponse send(DestroyRegistration destroyRegistration, SOAParameterType soaParameterType) throws MessagingException, WSNotificationException, PEtALSCDKException {
        DestroyRegistrationResponse destroyRegistrationResponse = null;
        Document document = WSNotificationWriter.getInstance().writeDestroyRegistration(destroyRegistration);
        InOut messageExchange = this.messageExchangeFactory.createInOutExchange();
        ServiceEndpoint serviceEndpoint = this.componentContext.getEndpoint(soaParameterType.getService(), soaParameterType.getEndpoint());
        if (serviceEndpoint != null) {
            messageExchange.setEndpoint(serviceEndpoint);
            document = this.send(document, (MessageExchange)messageExchange, WsnbrConstants.DESTROY_REGISTRATION_QNAME, true);
            if (document != null) {
                destroyRegistrationResponse = WSNotificationReader.getInstance().readDestroyRegistrationResponse(document);
            }
        }
        return destroyRegistrationResponse;
    }

    private Document send(Document notification, MessageExchange messageExchange, QName operation, boolean synchronous) throws MessagingException, PEtALSCDKException {
        NormalizedMessage normalizedMessage = null;
        Source source = null;
        normalizedMessage = messageExchange.createMessage();
        notification.normalizeDocument();
        source = UtilFactory.getSourceUtil().createDOMSource(notification);
        normalizedMessage.setContent(source);
        messageExchange.setMessage(normalizedMessage, "in");
        messageExchange.setOperation(operation);
        if (!synchronous) {
            this.componentContext.getDeliveryChannel().send(messageExchange);
        } else if (this.componentContext.getDeliveryChannel().sendSync(messageExchange)) {
            if (ExchangeStatus.ERROR.equals(messageExchange.getStatus())) {
                throw new MessagingException((Throwable)messageExchange.getError());
            }
            if (ExchangeStatus.ACTIVE.equals(messageExchange.getStatus())) {
                normalizedMessage = messageExchange.getFault();
                if (normalizedMessage == null) {
                    normalizedMessage = messageExchange.getMessage("out");
                }
                messageExchange.setStatus(ExchangeStatus.DONE);
                this.componentContext.getDeliveryChannel().send(messageExchange);
                if (normalizedMessage != null && (source = normalizedMessage.getContent()) != null) {
                    return UtilFactory.getSourceUtil().createDocument(source);
                }
            }
        }
        return null;
    }

    public RegisterPublisherResponse send(RegisterPublisher registerPublisher) throws MessagingException, WSNotificationException, PEtALSCDKException {
        RegisterPublisherResponse registerPublisherResponse = null;
        Document document = WSNotificationWriter.getInstance().writeRegisterPublisher(registerPublisher);
        if ((document = this.send(document, (MessageExchange)this.notificationBrokerMessageExchangeFactory.createInOutExchange(), WsnbrConstants.REGISTER_PUBLISHER_QNAME, true)) != null) {
            registerPublisherResponse = WSNotificationReader.getInstance().readRegisterPublisherResponse(document);
        }
        return registerPublisherResponse;
    }

    public SubscribeResponse send(Subscribe subscribe) throws MessagingException, WSNotificationException, PEtALSCDKException {
        SubscribeResponse subscribeResponse = null;
        Document document = WSNotificationWriter.getInstance().writeSubscribe(subscribe);
        if ((document = this.send(document, (MessageExchange)this.notificationBrokerMessageExchangeFactory.createInOutExchange(), WsnbConstants.SUBSCRIBE_QNAME, true)) != null) {
            subscribeResponse = WSNotificationReader.getInstance().readSubscribeResponse(document);
        }
        return subscribeResponse;
    }

    public UnsubscribeResponse send(Unsubscribe unsubscribe) throws MessagingException, WSNotificationException, PEtALSCDKException {
        UnsubscribeResponse unsubscribeResponse = null;
        Document document = WSNotificationWriter.getInstance().writeUnsubscribe(unsubscribe);
        if ((document = this.send(document, (MessageExchange)this.subscriptionManagerMessageExchangeFactory.createInOutExchange(), WsnbConstants.UNSUBSCRIBE_QNAME, true)) != null) {
            unsubscribeResponse = WSNotificationReader.getInstance().readUnsubscribeResponse(document);
        }
        return unsubscribeResponse;
    }

    public void send(Notify notify, EndpointReferenceType consumerReference) throws WSAddressingException, WSNotificationExtensionException, WSNotificationException, MessagingException, PEtALSCDKException {
        SOAParameterType soaParameter = null;
        InOnly inOnly = this.notificationBrokerMessageExchangeFactory.createInOnlyExchange();
        if (consumerReference != null && consumerReference.getReferenceParameters() != null && (soaParameter = WsnSpecificTypeHelper.getSOAParameter((ReferenceParametersType)((ReferenceParametersType)consumerReference.getReferenceParameters()))) != null) {
            ArrayList<QName> interfaceList = new ArrayList<QName>(1);
            interfaceList.add(soaParameter.getInterface());
            NotificationServiceEndpoint serviceEndpoint = new NotificationServiceEndpoint(interfaceList, soaParameter.getService(), soaParameter.getEndpoint());
            inOnly.setEndpoint((ServiceEndpoint)serviceEndpoint);
        }
        Document document = WSNotificationWriter.getInstance().writeNotify(notify);
        this.send(document, (MessageExchange)inOnly, WsnbConstants.NOTIFY_QNAME, false);
    }
}

