/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.notification.notify;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPathExpressionException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.api.notification.NotificationBrokerController;
import org.ow2.petals.component.framework.notification.filter.messagecontent.EndpointFilter;
import org.ow2.petals.component.framework.notification.filter.messagecontent.XPathFilter;
import org.ow2.petals.component.framework.notification.filter.topicexpression.TopicExpressionFilter;
import org.ow2.petals.component.framework.notification.notify.ComponentNotify;
import org.ow2.petals.component.framework.notification.subscriptionpolicy.ContextSubscriptionPolicy;
import org.ow2.petals.component.framework.notification.subscriptionpolicy.ProcessSubscriptionPolicy;
import org.ow2.petals.component.framework.notification.subscriptionpolicy.XSLTSubscriptionPolicy;
import org.w3c.dom.Document;

public abstract class AbstractProducerComponentNotify
extends ComponentNotify {
    private TopicExpressionFilter topicExpressionFilter = null;
    private XPathFilter xPathFilter = null;
    private EndpointFilter endpointFilter = null;
    private XSLTSubscriptionPolicy xsltSubscriptionPolicy = null;
    protected ContextSubscriptionPolicy contextSubscriptionPolicy = null;
    private ProcessSubscriptionPolicy processSubscriptionPolicy = null;
    private EndpointReferenceType subscriptionReference = null;

    public AbstractProducerComponentNotify(EndpointReferenceType subscriptionReference, Subscribe subscribe, NotificationBrokerController notificationBrokerController, Logger logger) throws WSNotificationException, WSNotificationExtensionException, TransformerFactoryConfigurationError, TransformerException, ParserConfigurationException, XPathExpressionException {
        super(notificationBrokerController, logger);
        this.subscriptionReference = subscriptionReference;
        this.topicExpressionFilter = new TopicExpressionFilter(subscribe);
        this.xPathFilter = new XPathFilter(subscribe);
        this.endpointFilter = new EndpointFilter(subscribe);
        if (subscribe.getSubscriptionPolicy() != null) {
            this.xsltSubscriptionPolicy = new XSLTSubscriptionPolicy(subscribe, this.logger);
            this.processSubscriptionPolicy = new ProcessSubscriptionPolicy(subscribe);
            this.contextSubscriptionPolicy = new ContextSubscriptionPolicy(subscribe);
        }
    }

    public TopicExpressionFilter getTopicExpressionFilter() {
        return this.topicExpressionFilter;
    }

    protected void process(Exchange exchange, Document document) {
        boolean notify = true;
        if (exchange.isProviderRole() && (notify = this.xPathFilter.isNotifiable(document)) && (notify = this.endpointFilter.isNotifiable(exchange.getEndpoint()))) {
            document = this.xsltSubscriptionPolicy.applyPolicy(document);
            this.contextSubscriptionPolicy.setExchange(exchange);
            document = this.contextSubscriptionPolicy.applyPolicy(document);
            this.processSubscriptionPolicy.setExchange(exchange);
            document = this.processSubscriptionPolicy.applyPolicy(document);
            this.process(document, this.getTopic(), this.subscriptionReference);
        }
    }

    public abstract String getTopic();

    public abstract Exchange process(Exchange var1) throws MessagingException;
}

