/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.notification.notify;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import java.util.logging.Logger;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPathExpressionException;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.api.notification.NotificationBrokerController;
import org.ow2.petals.component.framework.notification.notify.AbstractProducerComponentNotify;
import org.ow2.petals.component.framework.util.UtilFactory;
import org.w3c.dom.Document;

public class FaultProducerComponentNotify
extends AbstractProducerComponentNotify {
    public FaultProducerComponentNotify(EndpointReferenceType subscriptionReference, Subscribe subscribe, NotificationBrokerController notificationBrokerController, Logger logger) throws WSNotificationException, WSNotificationExtensionException, XPathExpressionException, TransformerFactoryConfigurationError, TransformerException, ParserConfigurationException {
        super(subscriptionReference, subscribe, notificationBrokerController, logger);
    }

    @Override
    public String getTopic() {
        return "petals:component/cdk/producer/fault[@wstop:topic='true']";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized Exchange process(Exchange exchange) {
        Document document = null;
        Fault fault = null;
        if (exchange.isActiveStatus() && exchange.getFault() != null && (fault = exchange.getFault()) != null && (document = UtilFactory.getSourceUtil().createDocument(fault.getContent())) != null) {
            this.contextSubscriptionPolicy.setStatus(2);
            this.process(exchange, document);
        }
        if (document == null) return exchange;
        try {
            exchange.getFault().setContent((Source)UtilFactory.getSourceUtil().createStreamSource(document));
            return exchange;
        }
        catch (PEtALSCDKException e) {
            return exchange;
        }
        catch (MessagingException e) {}
        return exchange;
        catch (Exception e) {
            try {
                this.logger.info("Unable to send a notification");
                this.logger.fine("Detail on the notification error: " + e.getMessage());
                if (document == null) return exchange;
            }
            catch (Throwable throwable) {
                if (document == null) throw throwable;
                try {
                    exchange.getFault().setContent((Source)UtilFactory.getSourceUtil().createStreamSource(document));
                    throw throwable;
                }
                catch (PEtALSCDKException e2) {
                    throw throwable;
                }
                catch (MessagingException e3) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                exchange.getFault().setContent((Source)UtilFactory.getSourceUtil().createStreamSource(document));
                return exchange;
            }
            catch (PEtALSCDKException e4) {
                return exchange;
            }
            catch (MessagingException e5) {}
            return exchange;
        }
    }
}

