/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.mbean.RuntimeConfigurationNotifier;
import org.ow2.petals.component.framework.process.JBIProcessorManager;
import org.ow2.petals.component.framework.process.MessageExchangeAcceptor;

public class JBIAcceptorManager {
    protected final Logger logger;
    private ThreadPoolExecutor acceptorPool = null;
    protected final JBIProcessorManager jbiProcessorManager;
    protected final AbstractComponent component;

    public JBIAcceptorManager(AbstractComponent component, JBIProcessorManager jbiProcessorManager, RuntimeConfigurationNotifier runtimeConfiguration, Logger log) {
        this.component = component;
        this.jbiProcessorManager = jbiProcessorManager;
        this.logger = log;
        runtimeConfiguration.addNotificationListener(new RuntimeConfigurationListener(), null, null);
    }

    public void start() throws JBIException {
        this.acceptorPool = new ThreadPoolExecutor(this.component.getComponentConfiguration().getAcceptorPoolSize().getValue(), this.component.getComponentConfiguration().getAcceptorPoolSize().getValue(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), new JBIAcceptorThreadFactory());
        this.acceptorPool.prestartAllCoreThreads();
    }

    public void stop() {
        this.acceptorPool.shutdownNow();
    }

    private void setCorePoolSize(int size) {
        if (this.acceptorPool != null) {
            this.logger.info("Reset the acceptor thread pool size to " + size);
            this.acceptorPool.setCorePoolSize(size);
        }
    }

    private class RuntimeConfigurationListener
    implements NotificationListener {
        private RuntimeConfigurationListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object obj) {
            if (notification instanceof AttributeChangeNotification) {
                AttributeChangeNotification attrNotif = (AttributeChangeNotification)notification;
                String attrName = attrNotif.getAttributeName();
                JBIAcceptorManager.this.logger.log(Level.FINE, "Notification received for attribute : " + attrName);
                if (attrName.equals("acceptorPoolSize")) {
                    Integer newVal = (Integer)attrNotif.getNewValue();
                    JBIAcceptorManager.this.setCorePoolSize(newVal);
                }
            }
        }
    }

    private class JBIAcceptorThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final ThreadGroup group;

        public JBIAcceptorThreadFactory() {
            this.group = new ThreadGroup(Thread.currentThread().getThreadGroup(), JBIAcceptorManager.this.component.getContext().getComponentName() + "-JBIListener");
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = JBIAcceptorManager.this.component.getContext().getComponentName() + " -JBI Acceptor Thread #" + Integer.toString(this.threadNumber.getAndIncrement());
            JBIAcceptorManager.this.logger.log(Level.FINE, "Creating a new thread for JBIAcceptor Factory : " + name);
            MessageExchangeAcceptor meaProcessor = new MessageExchangeAcceptor(JBIAcceptorManager.this.component, JBIAcceptorManager.this.jbiProcessorManager.getThreadPool(), JBIAcceptorManager.this.jbiProcessorManager.getObjectPool(), JBIAcceptorManager.this.logger, this.group, name);
            meaProcessor.setDaemon(true);
            return meaProcessor;
        }
    }
}

