/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.su;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.util.PropertiesUtil;
import org.ow2.petals.component.framework.interceptor.MessageInterceptorManager;
import org.ow2.petals.component.framework.jbidescriptor.CDKJBIDescriptorException;
import org.ow2.petals.component.framework.jbidescriptor.JBIDescriptorBuilder;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.jbidescriptor.generated.SUInterceptors;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;
import org.ow2.petals.component.framework.util.ManagementMessageUtil;
import org.ow2.petals.component.framework.util.ServiceEndpointKey;
import org.ow2.petals.component.framework.util.StringHelper;
import org.ow2.petals.component.framework.util.UtilFactory;
import org.w3c.dom.Document;

public abstract class AbstractServiceUnitManager
implements ServiceUnitManager {
    protected final AbstractComponent component;
    protected Logger logger;
    private final ConcurrentMap<String, ServiceUnitDataHandler> serviceUnitDataHandlers;

    public AbstractServiceUnitManager(AbstractComponent component) {
        this.component = component;
        this.logger = component.getLogger();
        this.serviceUnitDataHandlers = new ConcurrentHashMap<String, ServiceUnitDataHandler>();
    }

    private static final Description getWsdlDescription(URL wsdlLocation, Provides provides) throws PEtALSCDKException {
        if (wsdlLocation != null) {
            try {
                return UtilFactory.getWSDLUtil().createWsdlDescription(wsdlLocation, false);
            }
            catch (WSDLException e) {
                throw new PEtALSCDKException((Throwable)e);
            }
        }
        try {
            return UtilFactory.getWSDLUtil().createLightWSDL20Description(provides.getInterfaceName(), provides.getServiceName(), provides.getEndpointName());
        }
        catch (WSDLException e) {
            throw new PEtALSCDKException("Can not auto-generate a WSDL document", (Throwable)e);
        }
    }

    private static final URL getWsdlLocation(String installRoot, Provides provides) throws PEtALSCDKException {
        String wsdlFileLocation = null;
        URL wsdlLocation = null;
        wsdlFileLocation = provides.getWsdl();
        if (StringHelper.isNullOrEmpty(provides.getWsdl())) {
            return null;
        }
        try {
            wsdlLocation = new URL(provides.getWsdl());
        }
        catch (MalformedURLException e) {
            File wsdlFile = new File(installRoot, wsdlFileLocation);
            if (!wsdlFile.exists()) {
                throw new PEtALSCDKException("Can not retrieve WSDL document from location : " + wsdlFileLocation);
            }
            try {
                wsdlLocation = wsdlFile.toURI().toURL();
            }
            catch (MalformedURLException e1) {
                // empty catch block
            }
        }
        return wsdlLocation;
    }

    private static final void validateDescription(Description wsdlDescription, Provides provides) throws JBIException {
        block6: {
            try {
                Service ss = (Service)wsdlDescription.getService(provides.getServiceName());
                if (ss == null) {
                    throw new JBIException("Failed to find provided service '" + provides.getServiceName() + "' in the WSDL description");
                }
                Endpoint e = (Endpoint)ss.getEndpoint(provides.getEndpointName());
                if (e == null) {
                    throw new JBIException("Failed to find provided endpoint '" + provides.getEndpointName() + "' in the WSDL description");
                }
                if (ss.getInterface() != null && ((InterfaceType)ss.getInterface()).getQName() != null) {
                    if (!((InterfaceType)ss.getInterface()).getQName().equals(provides.getInterfaceName())) {
                        throw new JBIException("Failed to match provided interface '" + provides.getInterfaceName() + "'. Found '" + ((InterfaceType)ss.getInterface()).getQName() + "' in the WSDL description");
                    }
                    break block6;
                }
                throw new JBIException("Failed to find an interface in WSDL description bound the provided service " + ss.getQName());
            }
            catch (WSDLException e) {
                throw new JBIException("Failed to parse the WSDL description bound to the provided service '" + provides.getEndpointName() + "'", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deploy(String serviceUnitName, String suRootPath) throws DeploymentException {
        String result;
        this.logger.log(Level.INFO, "Deploy Service Unit '" + serviceUnitName + "'");
        if (this.serviceUnitDataHandlers.containsKey(serviceUnitName)) {
            this.logger.log(Level.SEVERE, "Service Unit '" + serviceUnitName + "' not deployed");
            return ManagementMessageUtil.getComponentTaskResult(this.component.getContext().getComponentName(), "deploy", "FAILED", "1", "A service unit with the name {1} is already deployed", new String[]{serviceUnitName});
        }
        File jbiXmlFile = new File(suRootPath, "META-INF" + File.separator + "jbi.xml");
        Throwable exception = null;
        Jbi jbiDescriptor = null;
        InputStream jbiDescriptorInputStream = null;
        try {
            String jbiXmlString = this.processProperties(jbiXmlFile);
            jbiDescriptorInputStream = new ByteArrayInputStream(jbiXmlString.getBytes());
            jbiDescriptor = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)jbiDescriptorInputStream);
        }
        catch (CDKJBIDescriptorException e) {
            exception = e;
        }
        catch (PEtALSCDKException e) {
            exception = e;
        }
        catch (IOException e) {
            exception = e;
        }
        finally {
            try {
                if (jbiDescriptorInputStream != null) {
                    jbiDescriptorInputStream.close();
                }
            }
            catch (IOException ex) {}
        }
        if (exception == null) {
            ServiceUnitDataHandler handler = new ServiceUnitDataHandler(serviceUnitName, suRootPath, jbiDescriptor);
            this.logger.log(Level.FINE, "Register a data handler for SU '" + serviceUnitName + "'");
            this.serviceUnitDataHandlers.put(serviceUnitName, handler);
            try {
                this.processConsumesNodes(handler);
                this.processProvidesNodes(handler);
                this.doDeploy(serviceUnitName, suRootPath, jbiDescriptor);
            }
            catch (Exception e) {
                this.logger.log(Level.FINE, "Unregister the data handler for SU : " + serviceUnitName);
                for (ServiceEndpoint endpoint : handler.getServiceEndpoints().values()) {
                    try {
                        this.component.getContext().deactivateEndpoint(endpoint);
                    }
                    catch (JBIException e1) {
                        this.logger.log(Level.WARNING, "Error during deployment cleanup of Service unit '" + serviceUnitName + "'", e);
                    }
                }
                this.serviceUnitDataHandlers.remove(serviceUnitName);
                exception = e;
            }
        }
        if (exception == null) {
            result = ManagementMessageUtil.getComponentTaskResult(this.component.getContext().getComponentName(), "deploy", "SUCCESS");
            this.logger.log(Level.INFO, "Service Unit '" + serviceUnitName + "' deployed");
        } else {
            result = ManagementMessageUtil.getComponentTaskResult(this.component.getContext().getComponentName(), "deploy", "FAILED", "ERROR", "1", "Failed to deploy Service Unit : {1}", new String[]{serviceUnitName}, ExceptionUtil.getExtendedMessage((Exception)exception));
            this.logger.log(Level.SEVERE, "Service Unit '" + serviceUnitName + "' failed to deploy", exception);
        }
        return result;
    }

    public Consumes getConsumesForEndpoint(String endpointName) {
        for (ServiceUnitDataHandler dataHandler : this.serviceUnitDataHandlers.values()) {
            for (Consumes consumes : dataHandler.getDescriptor().getServices().getConsumes()) {
                if (!endpointName.equals(consumes.getEndpointName())) continue;
                return consumes;
            }
        }
        return null;
    }

    public Consumes getConsumesForInterface(QName interfaceName) {
        for (ServiceUnitDataHandler dataHandler : this.serviceUnitDataHandlers.values()) {
            for (Consumes consumes : dataHandler.getDescriptor().getServices().getConsumes()) {
                if (!interfaceName.equals(consumes.getInterfaceName())) continue;
                return consumes;
            }
        }
        return null;
    }

    public Consumes getConsumesForService(QName serviceName) {
        for (ServiceUnitDataHandler dataHandler : this.serviceUnitDataHandlers.values()) {
            for (Consumes consumes : dataHandler.getDescriptor().getServices().getConsumes()) {
                if (!serviceName.equals(consumes.getServiceName())) continue;
                return consumes;
            }
        }
        return null;
    }

    public Consumes getConsumesFromDestination(String endpointName, QName serviceName, QName interfaceName) {
        Consumes result = null;
        if (endpointName != null) {
            result = this.getConsumesForEndpoint(endpointName);
        }
        if (result == null) {
            if (serviceName != null) {
                result = this.getConsumesForService(serviceName);
            }
            if (result == null && interfaceName != null) {
                result = this.getConsumesForInterface(interfaceName);
            }
        }
        return result;
    }

    public Set<ServiceEndpoint> getEndpointsForServiceUnit(String serviceUnitName) {
        HashSet<ServiceEndpoint> result = new HashSet<ServiceEndpoint>();
        for (ServiceEndpointKey key : ((ServiceUnitDataHandler)this.serviceUnitDataHandlers.get(serviceUnitName)).getServiceEndpoints().keySet()) {
            result.add(((ServiceUnitDataHandler)this.serviceUnitDataHandlers.get(serviceUnitName)).getServiceEndpoints().get(key));
        }
        return result;
    }

    public Provides getProvidesFromEndpoint(ServiceEndpoint serviceEndpoint) {
        if (serviceEndpoint != null) {
            ServiceEndpointKey serviceEndpointKey = new ServiceEndpointKey(serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName());
            for (ServiceUnitDataHandler dataHandler : this.serviceUnitDataHandlers.values()) {
                Provides provides = dataHandler.getEpJBIDesc().get(serviceEndpointKey);
                if (provides == null) continue;
                return provides;
            }
        }
        return null;
    }

    public Document getServiceDescription(ServiceEndpoint serviceEndpoint) {
        for (ServiceUnitDataHandler dataHandler : this.serviceUnitDataHandlers.values()) {
            Document serviceDescription = dataHandler.getEndpointDescription(serviceEndpoint);
            if (serviceDescription == null) continue;
            return serviceDescription;
        }
        return null;
    }

    public Map<String, ServiceUnitDataHandler> getServiceUnitDataHandlers() {
        return this.serviceUnitDataHandlers;
    }

    public ServiceUnitDataHandler getSUDataHandlerForConsumes(Consumes consumes) {
        for (ServiceUnitDataHandler dataHandler : this.serviceUnitDataHandlers.values()) {
            for (Consumes consumesElement : dataHandler.getDescriptor().getServices().getConsumes()) {
                if (!consumes.equals(consumesElement)) continue;
                return dataHandler;
            }
        }
        return null;
    }

    public ServiceUnitDataHandler getSUDataHandlerForEndpoint(ServiceEndpoint endpoint) {
        ServiceEndpointKey key = new ServiceEndpointKey(endpoint.getServiceName(), endpoint.getEndpointName());
        for (ServiceUnitDataHandler dataHandler : this.serviceUnitDataHandlers.values()) {
            for (ServiceEndpointKey k : dataHandler.getEpJBIDesc().keySet()) {
                if (!key.equals(k)) continue;
                return dataHandler;
            }
        }
        return null;
    }

    public ServiceUnitDataHandler getSUDataHandlerForProvides(Provides provides) {
        for (ServiceUnitDataHandler dataHandler : this.serviceUnitDataHandlers.values()) {
            for (Provides providesElement : dataHandler.getDescriptor().getServices().getProvides()) {
                if (!provides.equals(providesElement)) continue;
                return dataHandler;
            }
        }
        return null;
    }

    public ServiceUnitDataHandler getSUDataHandlerForService(Object service) {
        ServiceUnitDataHandler suDataHandler = null;
        if (service instanceof Consumes) {
            suDataHandler = this.getSUDataHandlerForConsumes((Consumes)service);
        } else if (service instanceof Provides) {
            suDataHandler = this.getSUDataHandlerForProvides((Provides)service);
        }
        return suDataHandler;
    }

    public void init(String serviceUnitName, String suRootPath) throws DeploymentException {
        this.logger.log(Level.INFO, "Init Service Unit '" + serviceUnitName + "'");
        try {
            this.doInit(serviceUnitName, suRootPath);
        }
        catch (PEtALSCDKException e) {
            throw new DeploymentException("Failed to init the Service Unit '" + serviceUnitName + "'", (Throwable)e);
        }
    }

    public void shutDown(String serviceUnitName) throws DeploymentException {
        this.logger.log(Level.INFO, "Shut down Service Unit '" + serviceUnitName + "'");
        try {
            this.doShutdown(serviceUnitName);
        }
        catch (PEtALSCDKException e) {
            throw new DeploymentException("Failed to shut down the Service Unit '" + serviceUnitName + "'", (Throwable)e);
        }
    }

    public void start(String serviceUnitName) throws DeploymentException {
        this.logger.log(Level.INFO, "Start Service Unit '" + serviceUnitName + "'");
        try {
            this.doStart(serviceUnitName);
        }
        catch (PEtALSCDKException e) {
            throw new DeploymentException("Failed to start the Service Unit '" + serviceUnitName + "'", (Throwable)e);
        }
    }

    public void stop(String serviceUnitName) throws DeploymentException {
        this.logger.log(Level.INFO, "Stop Service Unit '" + serviceUnitName + "'");
        try {
            this.doStop(serviceUnitName);
        }
        catch (PEtALSCDKException e) {
            throw new DeploymentException("Failed to stop the Service Unit '" + serviceUnitName + "'", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String undeploy(String serviceUnitName, String suRootPath) throws DeploymentException {
        String result;
        this.logger.log(Level.INFO, "Undeploy Service Unit " + serviceUnitName);
        Throwable exception = null;
        ServiceUnitDataHandler handler = (ServiceUnitDataHandler)this.serviceUnitDataHandlers.get(serviceUnitName);
        for (ServiceEndpoint endpoint : handler.getServiceEndpoints().values()) {
            try {
                this.component.getContext().deactivateEndpoint(endpoint);
            }
            catch (JBIException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                this.logger.log(Level.WARNING, "Several errors during undeployment of Service unit '" + serviceUnitName + "'", e);
            }
        }
        try {
            this.doUndeploy(serviceUnitName);
        }
        catch (PEtALSCDKException e) {
            if (exception == null) {
                exception = e;
            } else {
                this.logger.log(Level.WARNING, "Several errors during undeployment of Service unit '" + serviceUnitName + "'", e);
            }
        }
        finally {
            this.serviceUnitDataHandlers.remove(serviceUnitName);
        }
        if (exception == null) {
            result = ManagementMessageUtil.getComponentTaskResult(this.component.getContext().getComponentName(), "undeploy", "SUCCESS");
            this.logger.log(Level.INFO, "Service unit '" + serviceUnitName + "' undeploy");
        } else {
            result = ManagementMessageUtil.getComponentTaskResult(this.component.getContext().getComponentName(), "undeploy", "FAILED", "ERROR", "1", "Failed to undeploy Service Unit {1}", new String[]{serviceUnitName}, ExceptionUtil.getExtendedMessage((Exception)exception));
            this.logger.log(Level.SEVERE, "Service unit '" + serviceUnitName + "' failed to undeploy", exception);
        }
        return result;
    }

    protected void doDeploy(String serviceUnitName, String suRootPath, Jbi jbiDescriptor) throws PEtALSCDKException {
    }

    protected void doInit(String serviceUnitName, String suRootPath) throws PEtALSCDKException {
    }

    protected void doShutdown(String serviceUnitName) throws PEtALSCDKException {
    }

    protected void doStart(String serviceUnitName) throws PEtALSCDKException {
    }

    protected void doStop(String serviceUnitName) throws PEtALSCDKException {
    }

    protected void doUndeploy(String serviceUnitName) throws PEtALSCDKException {
    }

    private void processConsumesNodes(ServiceUnitDataHandler handler) throws JBIException {
        Jbi descriptor = handler.getDescriptor();
        List consumesList = descriptor.getServices().getConsumes();
        for (Consumes consumes : consumesList) {
            this.processInterceptors(handler, consumes);
        }
    }

    private void processInterceptors(ServiceUnitDataHandler handler, Object service) throws JBIException {
        SUInterceptors suInterceptors = null;
        if (service instanceof Consumes) {
            suInterceptors = ((Consumes)service).getSuInterceptors();
        } else if (service instanceof Provides) {
            suInterceptors = ((Provides)service).getSuInterceptors();
        }
        MessageInterceptorManager interceptorManager = this.component.getComponentConfiguration().getPropertiesFile() != null && !StringHelper.isNullOrEmpty(this.component.getComponentConfiguration().getPropertiesFile().getValue()) ? new MessageInterceptorManager(this.component.getComponentConfiguration().getPropertiesFile().getValue(), this.logger) : new MessageInterceptorManager(this.logger);
        List sendSUInterceptors = null;
        List sendResponseSUInterceptors = null;
        List acceptSUInterceptors = null;
        List acceptResponseSUInterceptors = null;
        if (suInterceptors != null) {
            if (suInterceptors.getSend() != null) {
                sendSUInterceptors = suInterceptors.getSend().getInterceptor();
            }
            if (suInterceptors.getSendResponse() != null) {
                sendResponseSUInterceptors = suInterceptors.getSendResponse().getInterceptor();
            }
            if (suInterceptors.getAccept() != null) {
                acceptSUInterceptors = suInterceptors.getAccept().getInterceptor();
            }
            if (suInterceptors.getAcceptResponse() != null) {
                acceptResponseSUInterceptors = suInterceptors.getAcceptResponse().getInterceptor();
            }
        }
        interceptorManager.init(this.component.getInterceptors(), acceptSUInterceptors, sendSUInterceptors, acceptResponseSUInterceptors, sendResponseSUInterceptors);
        handler.addMessageInterceptorManager(service, interceptorManager);
    }

    private String processProperties(File jbiFile) throws IOException, PEtALSCDKException {
        FileInputStream jbiFileInputStream = new FileInputStream(jbiFile);
        String jbiString = UtilFactory.getSourceUtil().createString((Source)new StreamSource(jbiFileInputStream));
        jbiFileInputStream.close();
        if (this.component.getComponentConfiguration().getPropertiesFile() != null && !StringHelper.isNullOrEmpty(this.component.getComponentConfiguration().getPropertiesFile().getValue())) {
            Properties componentProperties = PropertiesUtil.loadProperties((String)this.component.getComponentConfiguration().getPropertiesFile().getValue());
            for (Map.Entry<Object, Object> entry : componentProperties.entrySet()) {
                jbiString = jbiString.replaceAll("\\$\\{" + entry.getKey() + "\\}", (String)entry.getValue());
            }
        }
        return jbiString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceEndpoint processProvidesNode(ServiceUnitDataHandler handler, Provides provides) throws CDKJBIDescriptorException, WSDLException, IOException, JBIException {
        URL wsdlLocation = AbstractServiceUnitManager.getWsdlLocation(handler.getInstallRoot(), provides);
        Description wsdlDescription = AbstractServiceUnitManager.getWsdlDescription(wsdlLocation, provides);
        String endpointName = provides.getEndpointName();
        if ("autogenerate".equals(endpointName)) {
            endpointName = UtilFactory.getIdUtil().createId(false);
            provides.setEndpointName(endpointName);
            File jbiXmlFile = new File(handler.getInstallRoot(), "META-INF" + File.separator + "jbi.xml");
            FileOutputStream jbiOutputStream = new FileOutputStream(jbiXmlFile);
            try {
                JBIDescriptorBuilder.buildXmlJBIdescriptor((Jbi)handler.getDescriptor(), (OutputStream)jbiOutputStream);
            }
            finally {
                ((OutputStream)jbiOutputStream).close();
            }
            Service service = (Service)wsdlDescription.getService(provides.getServiceName());
            Endpoint autogeneratedEndpoint = (Endpoint)service.getEndpoint("autogenerate");
            if (autogeneratedEndpoint != null) {
                autogeneratedEndpoint.setName(endpointName);
            }
            if (wsdlLocation != null) {
                String wsdlString = UtilFactory.getWSDLUtil().convertDescriptionToString(wsdlDescription);
                FileOutputStream wsdlOutputStream = new FileOutputStream(new File(wsdlLocation.getFile()));
                try {
                    ((OutputStream)wsdlOutputStream).write(wsdlString.getBytes());
                }
                finally {
                    ((OutputStream)wsdlOutputStream).close();
                }
            }
        }
        Document wsdlDocument = UtilFactory.getWSDLUtil().convertDescriptionToDocument(wsdlDescription);
        if (provides.getValidateWsdl() == null || provides.getValidateWsdl().isValue()) {
            this.logger.fine("Validating the provided WSDL description");
            AbstractServiceUnitManager.validateDescription(wsdlDescription, provides);
        }
        this.processInterceptors(handler, provides);
        handler.addEndpointDescription(provides.getServiceName(), endpointName, wsdlDocument);
        handler.addJBIDescription(provides.getServiceName(), endpointName, provides);
        ServiceEndpoint ep = this.component.getContext().activateEndpoint(provides.getServiceName(), endpointName);
        handler.addServiceEndpoint(ep);
        return ep;
    }

    private void processProvidesNodes(ServiceUnitDataHandler handler) throws WSDLException, CDKJBIDescriptorException, IOException, JBIException {
        Jbi descriptor = handler.getDescriptor();
        List providesList = descriptor.getServices().getProvides();
        for (Provides provides : providesList) {
            ServiceEndpoint sep = this.processProvidesNode(handler, provides);
            this.logger.log(Level.INFO, "New Service Endpoint deployed : " + sep);
        }
    }
}

