/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.BaseHashIndex;
import org.h2.index.Cursor;
import org.h2.index.HashCursor;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;
import org.h2.util.IntIntHashMap;
import org.h2.util.ValueHashMap;
import org.h2.value.Value;

public class HashIndex
extends BaseHashIndex {
    private ValueHashMap<Integer> rows;
    private IntIntHashMap intMap;
    private TableData tableData;

    public HashIndex(TableData tableData, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        super(tableData, n, string, indexColumnArray, indexType);
        this.tableData = tableData;
        this.reset();
    }

    private void reset() {
        if (this.columns.length == 1 && this.columns[0].getType() == 4) {
            this.intMap = new IntIntHashMap();
        } else {
            this.rows = ValueHashMap.newInstance(this.table.getDatabase());
        }
    }

    public void truncate(Session session) {
        this.reset();
    }

    public void add(Session session, Row row) throws SQLException {
        if (this.intMap != null) {
            int n = row.getValue(this.columns[0].getColumnId()).getInt();
            this.intMap.put(n, (int)row.getKey());
        } else {
            Value value = this.getKey(row);
            Integer n = this.rows.get(value);
            if (n != null) {
                throw this.getDuplicateKeyException();
            }
            this.rows.put(this.getKey(row), (int)row.getKey());
        }
    }

    public void remove(Session session, Row row) throws SQLException {
        if (this.intMap != null) {
            int n = row.getValue(this.columns[0].getColumnId()).getInt();
            this.intMap.remove(n);
        } else {
            this.rows.remove(this.getKey(row));
        }
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        Integer n;
        int n2;
        int n3;
        if (searchRow == null || searchRow2 == null) {
            throw Message.throwInternalError();
        }
        Row row = this.intMap != null ? ((n3 = this.intMap.get(n2 = searchRow.getValue(this.columns[0].getColumnId()).getInt())) != -1 ? this.tableData.getRow(session, n3) : null) : ((n = this.rows.get(this.getKey(searchRow))) == null ? null : this.tableData.getRow(session, n.intValue()));
        return new HashCursor(row);
    }

    public long getRowCount(Session session) {
        return this.getRowCountApproximation();
    }

    public long getRowCountApproximation() {
        return this.intMap != null ? (long)this.intMap.size() : (long)this.rows.size();
    }
}

