/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.schema.api.abstractElmt;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.logging.Logger;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.SchemaReader;
import org.ow2.easywsdl.schema.api.absItf.AbsItfInclude;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaImpl;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaReader;
import org.ow2.easywsdl.schema.impl.Constants;

public abstract class AbstractIncludeImpl<E, S extends AbsItfSchema>
extends AbstractSchemaElementImpl<E>
implements AbsItfInclude<S> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(AbstractIncludeImpl.class.getName());
    protected S schema;

    public AbstractIncludeImpl(E model, Map<SchemaReader.FeatureConstants, Object> features, Map<URI, AbsItfSchema> imports, URI baseURI, AbstractSchemaReader reader) throws SchemaException {
        super(model, null);
        Object obj;
        URI schemaLocation = this.getLocationURI();
        if (features != null && ((Boolean)(obj = features.get((Object)SchemaReader.FeatureConstants.IMPORT_DOCUMENTS))).booleanValue()) {
            this.retrieveInclude(schemaLocation, features, imports, baseURI, reader);
        }
        if (this.schema != null) {
            ((AbstractSchemaImpl)this.schema).setFeatures(features);
        }
    }

    public AbstractIncludeImpl(E model, AbstractSchemaElementImpl parent, Map<URI, AbsItfSchema> imports, URI baseURI, AbstractSchemaReader reader) throws SchemaException {
        super(model, parent);
        URI schemaLocation = this.getLocationURI();
        if (this.parent != null) {
            if (((AbstractSchemaImpl)this.parent).getFeatures() != null) {
                if (((AbstractSchemaImpl)this.parent).getFeatures().get((Object)SchemaReader.FeatureConstants.IMPORT_DOCUMENTS) != null && ((Boolean)((AbstractSchemaImpl)this.parent).getFeatures().get((Object)SchemaReader.FeatureConstants.IMPORT_DOCUMENTS)).booleanValue()) {
                    this.retrieveInclude(schemaLocation, ((AbstractSchemaImpl)this.parent).getFeatures(), imports, baseURI, reader);
                } else if (imports != null && !imports.isEmpty() && imports.get(schemaLocation) != null) {
                    this.schema = imports.get(schemaLocation);
                }
            } else if (imports != null && imports.get(schemaLocation) != null) {
                this.schema = imports.get(schemaLocation);
            }
        }
        if (parent != null && this.schema != null) {
            ((AbstractSchemaImpl)this.schema).setFeatures(((AbstractSchemaImpl)this.parent).getFeatures());
        }
    }

    private void retrieveInclude(URI originalSchemaLocation, Map<SchemaReader.FeatureConstants, Object> features, Map<URI, AbsItfSchema> imports, URI baseURI, AbstractSchemaReader reader) throws SchemaException {
        if (originalSchemaLocation != null) {
            try {
                URI schemaLocation = null;
                schemaLocation = Constants.XML_URI.equals(originalSchemaLocation) ? this.getClass().getClassLoader().getResource("schema/xml.xsd").toURI().normalize() : originalSchemaLocation;
                if (reader.getImportList().containsKey(schemaLocation)) {
                    LOG.warning("This import is already include : " + schemaLocation.toString() + ". This probably mean there's a cyclic import");
                    this.schema = reader.getImportList().get(schemaLocation);
                } else {
                    reader.getImportList().put(schemaLocation, null);
                    if (imports != null && imports.containsKey(schemaLocation)) {
                        this.schema = imports.get(schemaLocation);
                    } else {
                        reader.setFeatures(features);
                        this.schema = reader.readExternalPart(schemaLocation, baseURI, imports, false);
                    }
                }
                reader.getImportList().put(schemaLocation, (AbsItfSchema)this.schema);
            }
            catch (SchemaException e) {
                throw new SchemaException("the imported document cannot be import at: " + originalSchemaLocation.toString(), e);
            }
            catch (URISyntaxException e) {
                throw new SchemaException("the imported document cannot be import at: " + originalSchemaLocation.toString() + " because the URI is invalid", e);
            }
            catch (MalformedURLException e) {
                throw new SchemaException("the imported document cannot be import at: " + originalSchemaLocation.toString() + " because the URI is invalid", e);
            }
        }
    }

    @Override
    public S getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(S schema) {
        this.schema = schema;
    }

    public S getParentSchema() {
        return (S)this.parent.getSchema();
    }
}

