/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.engine.orchestra;

import java.net.URL;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.util.wsdl.WsdlUtil;
import org.ow2.orchestra.wsdl.WsdlsInfos;

public final class BPELProcessEnvironment {
    public ProcessDefinition processDefinition;
    public final EnvironmentFactory environmentFactory;
    public final URL bpelProcessURL;
    public final String bpelProcessName;
    public final URL wsdlURL;
    public final Definition wsdlDef;
    public final List<URL> externalsWsdls;

    public BPELProcessEnvironment(URL bpelProcessName, URL wsdlURL, List<URL> externalsWsdls, EnvironmentFactory environmentFactory) {
        this.environmentFactory = environmentFactory;
        this.bpelProcessURL = bpelProcessName;
        this.wsdlURL = wsdlURL;
        this.wsdlDef = WsdlUtil.readWsdl((URL)this.wsdlURL);
        this.externalsWsdls = externalsWsdls;
        this.bpelProcessName = BPELProcessEnvironment.extractProcessNameFromURL(this.bpelProcessURL);
    }

    private static String extractProcessNameFromURL(URL processURL) {
        String result = null;
        if (processURL != null) {
            String path = processURL.getPath();
            int index = path.lastIndexOf("/");
            index = index > 0 ? index : 0;
            result = path.substring(index);
        }
        return result;
    }

    public boolean isRequestResponse(WsdlsInfos wsdlsInfos, QName portTypeQName, String operationName) {
        PortType pt = wsdlsInfos.getPortType(portTypeQName);
        if (pt == null) {
            throw new OrchestraRuntimeException("PortType '" + portTypeQName + "' not found : cannot define if it is a request/response" + " call or a oneWay call.");
        }
        List operations = pt.getOperations();
        for (Operation op : operations) {
            if (!op.getName().equals(operationName)) continue;
            return op.getOutput() != null;
        }
        throw new OrchestraRuntimeException("Operation '" + operationName + "' not found in portType '" + portTypeQName + "' : cannot define if it is a request/response call or a oneWay call.");
    }
}

