/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.engine.orchestra;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.Deployment;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.jmx.RemoteDeployerImpl;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.util.DeploymentUtil;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.engine.orchestra.BPELProcessEnvironment;
import org.ow2.petals.engine.orchestra.util.WSDLAnalyzer;

public final class OrchestraSUManager
extends AbstractServiceUnitManager {
    private static final String BPEL_PROPERTY = "bpel";
    private Map<String, Jbi> descriptorMap;
    private final Logger logger;
    private EnvironmentFactory environmentFactory;
    private String suRootPath;
    private Map<String, BPELProcessEnvironment> bpelProcessMap;

    public Logger getLogger() {
        return this.logger;
    }

    public OrchestraSUManager(AbstractComponent component, EnvironmentFactory environmentFactory, Map<String, BPELProcessEnvironment> bpelProcessMap, Logger logger) {
        super(component);
        this.environmentFactory = environmentFactory;
        this.logger = logger;
        this.bpelProcessMap = bpelProcessMap;
        this.descriptorMap = Collections.synchronizedMap(new HashMap());
    }

    protected void doDeploy(String serviceUnitName, String suRootPath, Jbi jbiDescriptor) throws PEtALSCDKException {
        super.doDeploy(serviceUnitName, suRootPath, jbiDescriptor);
        this.onSUDeployed(serviceUnitName, suRootPath, jbiDescriptor);
    }

    protected void doUndeploy(String serviceUnitName) throws PEtALSCDKException {
        this.onSUUndeployed(serviceUnitName);
        super.doUndeploy(serviceUnitName);
    }

    public void onSUDeployed(String serviceUnitName, String jbiSuRootPath, Jbi jbiDescriptor) throws PEtALSCDKException {
        this.logger.info("Perform BPEL-Processes deployment on Orchestra server");
        this.suRootPath = jbiSuRootPath;
        this.descriptorMap.put(serviceUnitName, jbiDescriptor);
        this.createBPELProcessEnvironmentsForServiceUnit(jbiDescriptor);
        List providesList = jbiDescriptor.getServices().getProvides();
        for (Provides provides : providesList) {
            BPELProcessEnvironment bpelProcessEnv = this.bpelProcessMap.get(provides.getServiceName() + provides.getEndpointName());
            this.deployProcessToOrchestra(provides.getServiceName(), bpelProcessEnv);
            this.logger.info("The BPEL Process " + bpelProcessEnv.bpelProcessName + " has been succesfully deployed on Orchestra server and is available on the endpoint " + provides.getServiceName() + provides.getEndpointName());
        }
        this.logger.info("BPEL-Processes deployment on Orchestra server has been performed");
    }

    public void onSUUndeployed(String serviceUnitName) throws PEtALSCDKException {
        this.logger.info("Perform BPEL-Processes undeployment on Orchestra server");
        List providesList = this.descriptorMap.remove(serviceUnitName).getServices().getProvides();
        for (Provides provides : providesList) {
            BPELProcessEnvironment bpelProcessEnv = this.bpelProcessMap.remove(provides.getServiceName() + provides.getEndpointName());
            try {
                this.undeployProcessToOrchestra(bpelProcessEnv);
            }
            catch (Exception e) {
                this.logger.warning("Unable to undeploy process to orchestra :");
                e.printStackTrace();
            }
            this.logger.info("The BPEL Process " + bpelProcessEnv.bpelProcessName + " has been succesfully undeployed on Orchestra server");
        }
        this.logger.info("BPEL-Processes undeployment on Orchestra server has been performed");
    }

    private void createBPELProcessEnvironmentsForServiceUnit(Jbi jbiDescriptor) throws PEtALSCDKException {
        List providesList = jbiDescriptor.getServices().getProvides();
        try {
            for (Provides provides : providesList) {
                BPELProcessEnvironment bpelContext = null;
                ConfigurationExtensions props = new ConfigurationExtensions(provides.getAny());
                String bpelProcessName = props.get((Object)BPEL_PROPERTY);
                String wsdlName = provides.getWsdl();
                ArrayList<URL> externalWsdls = WSDLAnalyzer.getExternalWsdlUrls(this.suRootPath, WSDLAnalyzer.getResourceAsURL(this.suRootPath, wsdlName));
                bpelContext = this.createBPELProcessEnvironment(bpelProcessName, wsdlName, externalWsdls);
                this.bpelProcessMap.put(provides.getServiceName() + provides.getEndpointName(), bpelContext);
                this.logger.fine("A new BPELProcessEnvironment has been created for process " + bpelProcessName);
            }
        }
        catch (MalformedURLException e) {
            throw new PEtALSCDKException(e.getMessage());
        }
    }

    private BPELProcessEnvironment createBPELProcessEnvironment(String bpelProcessName, String wsdlName, ArrayList<URL> externalWsdls) throws MalformedURLException {
        if (bpelProcessName == null || bpelProcessName.equals("")) {
            throw new IllegalArgumentException("the BPEL process cannot be null in jbi descriptor");
        }
        if (wsdlName == null || wsdlName.equals("")) {
            throw new IllegalArgumentException("the WSDL name cannot be null in jbi descriptor");
        }
        return new BPELProcessEnvironment(WSDLAnalyzer.getResourceAsURL(this.suRootPath, bpelProcessName), WSDLAnalyzer.getResourceAsURL(this.suRootPath, wsdlName), externalWsdls, this.environmentFactory);
    }

    public void deployProcessToOrchestra(QName processName, BPELProcessEnvironment bpelProcessEnv) {
        this.logger.info("Deployment of the BPEL process " + bpelProcessEnv.bpelProcessName + " on Orchestra server");
        RemoteDeployerImpl remoteDeployer = new RemoteDeployerImpl();
        ArrayList<URL> wsdls = new ArrayList<URL>();
        for (URL externalWsdl : bpelProcessEnv.externalsWsdls) {
            wsdls.add(externalWsdl);
        }
        if (bpelProcessEnv.wsdlURL != null) {
            wsdls.add(bpelProcessEnv.wsdlURL);
        }
        Deployment bpelDeployment = DeploymentUtil.generateDeployment((URL)bpelProcessEnv.bpelProcessURL, wsdls);
        bpelProcessEnv.processDefinition = remoteDeployer.deploy(bpelDeployment);
    }

    public void undeployProcessToOrchestra(BPELProcessEnvironment bpelProcessEnv) throws MessagingException {
        RemoteDeployerImpl remoteDeployerMBean = new RemoteDeployerImpl();
        try {
            Set processInstanciesList = remoteDeployerMBean.findProcessInstances(bpelProcessEnv.processDefinition.getProcessDefinitionUUID());
            for (ProcessInstance processInstance : processInstanciesList) {
                this.logger.info("Stopping process instance : " + processInstance.getProcessInstanceUUID());
                try {
                    remoteDeployerMBean.exit(processInstance.getProcessInstanceUUID());
                }
                catch (InstanceNotFoundException e) {
                    this.logger.warning("Unable to exit process instance : " + processInstance.getProcessInstanceUUID());
                    e.printStackTrace();
                }
            }
        }
        catch (ProcessNotFoundException e) {
            this.logger.warning("Unable to find process : " + bpelProcessEnv.processDefinition.getProcessDefinitionUUID());
            e.printStackTrace();
        }
        this.logger.info("undeploying process : " + bpelProcessEnv.processDefinition.getProcessDefinitionUUID());
        remoteDeployerMBean.undeploy(bpelProcessEnv.processDefinition.getUUID());
    }
}

