/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.engine.orchestra.jbi;

import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessagingException;
import javax.security.auth.Subject;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.ow2.orchestra.exception.FaultWithMessageVariable;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.itf.Invoker;
import org.ow2.orchestra.util.BpelSOAPUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.engine.orchestra.util.Sender;
import org.w3c.dom.Element;

public class JBIInvoker
implements Invoker {
    private static Logger logger;
    private static DeliveryChannel channel;
    private static Sender sender;
    private Subject securitySubject = null;

    public static final void init(ComponentContext context, DeliveryChannel deliveryChannel, Logger log) {
        logger = log;
        channel = deliveryChannel;
        logger.log(Level.FINEST, "Creation of Sender");
        sender = new Sender(context, channel, logger);
    }

    public MessageVariable invoke(OperationKey operationKey, Element partnerEndPointReference, MessageVariable message, Set<Definition> wsdlDefinitions) {
        MessageVariable messageReturned = null;
        try {
            logger.log(Level.FINEST, "Entering in jbi invoke method");
            Operation operation = this.getOperation(operationKey, wsdlDefinitions);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Bpel message corresponding to the jbi request: " + message);
            }
            ExchangeImpl request = null;
            request = new ExchangeImpl(channel.createExchangeFactory().createExchange(Message.MEPConstants.IN_OUT_PATTERN.value()));
            request.setOperation(QName.valueOf(operationKey.getOperationName()));
            request.getInMessage().setSecuritySubject(this.securitySubject);
            try {
                request.setInMessageContent(BpelSOAPUtil.buildDocumentSOAPMessage((String)operationKey.getOperationName(), (MessageVariable)message).getSOAPBody().extractContentAsDocument());
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
            messageReturned = sender.send(partnerEndPointReference, (Exchange)request, operation);
            logger.log(Level.FINEST, "Exit of the jbi invoke method");
        }
        catch (FaultWithMessageVariable e) {
            throw e;
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        return messageReturned;
    }

    private Operation getOperation(OperationKey operationKey, Set<Definition> wsdlDefinitions) {
        PortType portType = null;
        Operation operation = null;
        Iterator<Definition> it = wsdlDefinitions.iterator();
        while (it.hasNext() && portType == null) {
            portType = it.next().getPortType(operationKey.getPortTypeQName());
        }
        if (portType != null) {
            operation = portType.getOperation(operationKey.getOperationName(), null, null);
        }
        return operation;
    }

    public final Subject getSecuritySubjet() {
        return this.securitySubject;
    }

    public final void setSecuritySubjet(Subject securitySubject1) {
        this.securitySubject = securitySubject1;
    }

    public MessageVariable invoke(OperationKey arg0, Element arg1, MessageVariable arg2, Set<Definition> arg3, Properties arg4) {
        return this.invoke(arg0, arg1, arg2, arg3);
    }
}

