/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.engine.orchestra.jbi;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.ReceivingService;
import org.ow2.orchestra.util.BpelSOAPUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.engine.orchestra.BPELProcessEnvironment;
import org.ow2.petals.engine.orchestra.OrchestraEngineException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JBIReceiver {
    private static Logger logger;

    public static void setLogger(Logger log) {
        logger = log;
    }

    public static void onJBIMessageReceived(BPELProcessEnvironment bpelProcessEnv, Exchange exchange) throws MessagingException, OrchestraEngineException {
        logger.finest("send the received jbi message to the Orchestra server");
        logger.finest("called endpoint service: " + exchange.getEndpoint().getServiceName());
        logger.finest("called operation: " + exchange.getOperation());
        QName portTypeQName = exchange.getEndpoint().getInterfaces()[0];
        String operationName = exchange.getOperation().getLocalPart();
        Operation operation = bpelProcessEnv.wsdlDef.getPortType(portTypeQName).getOperation(operationName, null, null);
        Message inputMessage = bpelProcessEnv.wsdlDef.getMessage(operation.getInput().getMessage().getQName());
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("received jbi message: " + inputMessage);
        }
        MessageVariable incomingMessage = BpelSOAPUtil.buildMessageFromDocumentSOAPBodyElement(inputMessage.getParts().values(), (Element)exchange.getInMessageContentAsDocument().getDocumentElement());
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("corresponding bpel message: " + incomingMessage);
        }
        MessageCarrier messageCarrier = new MessageCarrier();
        OperationKey operationKey = new OperationKey(bpelProcessEnv.processDefinition.getProcessDefinitionUUID(), portTypeQName, operationName);
        logger.log(Level.INFO, "handle process...");
        BpelExecution bpelExecution = ReceivingService.handle((MessageVariable)incomingMessage, (OperationKey)operationKey, (MessageCarrier)messageCarrier);
        logger.log(Level.INFO, "Process ID : " + bpelExecution.getProcessInstanceUUID());
        MessageVariable responseMessage = messageCarrier.getMessage();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("bpel response message = " + responseMessage);
        }
        if (messageCarrier.hasFault()) {
            QName faultQName = messageCarrier.getFaultQName();
            logger.info("Chain reply a fault : " + faultQName);
            Fault fault = exchange.createFault();
            try {
                SOAPFactory fact = SOAPFactory.newInstance();
                SOAPFault sFault = fact.createFault();
                sFault.setFaultString("Chain reply a fault");
                sFault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
                Detail detail = sFault.addDetail();
                detail.addChildElement(fact.createElement((Element)responseMessage.getParts().values().iterator().next()));
                fault.setContent((Source)new DOMSource((Node)sFault));
                exchange.setFault(fault);
            }
            catch (SOAPException e) {
                logger.warning("Unable to transform BPEL Message Fault into JBI message fault : " + e.getMessage());
                throw new MessagingException((Throwable)e);
            }
        }
        try {
            exchange.setOutMessageContent(BpelSOAPUtil.buildDocumentSOAPMessage((String)operationName, (MessageVariable)responseMessage).getSOAPBody().extractContentAsDocument());
        }
        catch (SOAPException e) {
            logger.warning("Unable to transform BPEL Message into JBI message : " + e.getMessage());
            throw new MessagingException((Throwable)e);
        }
    }
}

