/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.engine.orchestra.listener;

import java.util.Map;
import java.util.logging.Level;
import javax.jbi.messaging.MessagingException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.engine.orchestra.BPELProcessEnvironment;
import org.ow2.petals.engine.orchestra.OrchestraEngine;
import org.ow2.petals.engine.orchestra.OrchestraEngineException;
import org.ow2.petals.engine.orchestra.jbi.JBIReceiver;

public final class JBIListener
extends AbstractJBIListener {
    private Map<String, BPELProcessEnvironment> bpelProcessMap;

    public void init() {
        this.bpelProcessMap = ((OrchestraEngine)this.getComponent()).getBPELProcessEnvironmentMap();
    }

    public boolean onJBIMessage(Exchange exchange) {
        String endpointFullName = exchange.getEndpoint().getServiceName() + exchange.getEndpoint().getEndpointName();
        BPELProcessEnvironment bpelProcessEnv = this.bpelProcessMap.get(endpointFullName);
        if (bpelProcessEnv == null) {
            String msg = "No process definition found for endpoint " + endpointFullName;
            this.getLogger().log(Level.SEVERE, msg);
            exchange.setError((Exception)((Object)new MessagingException(msg)));
        } else {
            try {
                this.getLogger().info("Start a new instance or continue an existing instance of the process " + bpelProcessEnv.bpelProcessName + " for the Exchange " + exchange.getExchangeId());
                this.getLogger().info("and wait for the process instance response");
                JBIReceiver.onJBIMessageReceived(bpelProcessEnv, exchange);
                this.getLogger().info("the " + bpelProcessEnv.bpelProcessName + " BPEL process instance is terminated for the Exchange " + exchange.getExchangeId());
            }
            catch (OrchestraEngineException e) {
                this.getLogger().log(Level.SEVERE, "OrchestraEngineException: Message can not be processed, set the Exchange status as Error", (Throwable)((Object)e));
                exchange.setError((Exception)((Object)e));
            }
            catch (OrchestraRuntimeException e) {
                this.getLogger().log(Level.SEVERE, "OrchestraException: Message can not be processed", e);
                try {
                    exchange.setFault((Throwable)e);
                }
                catch (MessagingException e1) {
                    e1.printStackTrace();
                }
            }
            catch (MessagingException e) {
                this.getLogger().log(Level.SEVERE, "MessagingException: Message can not be processed, set the Exchange status as Error", e);
                exchange.setError((Exception)((Object)e));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getLogger().log(Level.SEVERE, "Set the Exchange status as Error", e.getMessage());
                exchange.setError(e);
            }
        }
        return true;
    }
}

