/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.engine.orchestra.util;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.ow2.orchestra.exception.FaultWithMessageVariable;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.BpelSOAPUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.engine.orchestra.OrchestraEngineException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Sender {
    private Logger logger;
    private DeliveryChannel channel;
    private ComponentContext context;

    public Sender(ComponentContext context, DeliveryChannel channel, Logger logger) {
        this.logger = logger;
        this.channel = channel;
        this.context = context;
    }

    public final MessageVariable send(Element partner, Exchange msgIn, Operation operation) {
        MessageVariable messageReturned = null;
        this.logger.finest("Send a JBI message");
        String endpointName = null;
        QName service = null;
        this.logger.finest("message mep : " + msgIn.getPattern());
        if (partner != null) {
            endpointName = this.getEndPointName(partner);
            service = this.getService(partner);
            if (service != null) {
                this.logger.info("Set the service to invoke: " + service);
                msgIn.setService(service);
                if (endpointName != null) {
                    try {
                        ServiceEndpoint endpoint = this.resolveEndPoint(service, endpointName);
                        this.logger.info("Set the endpoint to invoke: " + endpoint.getEndpointName());
                        msgIn.setEndpoint(endpoint);
                    }
                    catch (OrchestraEngineException e) {
                        this.logger.severe("Error during endpoint resolving.");
                        throw new OrchestraRuntimeException((Throwable)((Object)e));
                    }
                }
            }
        } else {
            this.logger.finest("partner is null: research the service by its interface");
        }
        this.logger.finest("Satus: " + msgIn.getStatus());
        this.logger.finest("Consumer Role? " + msgIn.isConsumerRole());
        try {
            this.channel.sendSync(((ExchangeImpl)msgIn).getMessageExchange());
        }
        catch (MessagingException e) {
            this.logger.severe("Error during call inside the bus : " + e.getMessage());
            throw new OrchestraRuntimeException((Throwable)e);
        }
        if (msgIn.getError() != null || msgIn.isErrorStatus()) {
            this.logger.info("Fault : " + msgIn.getFault().toString());
            this.logger.info("Error : " + msgIn.getError());
            this.logger.info("Status : " + msgIn.isErrorStatus());
            if (msgIn.getError() != null) {
                throw new OrchestraRuntimeException((Throwable)msgIn.getError());
            }
        }
        this.logger.log(Level.INFO, "Receive response from: " + msgIn.getEndpoint());
        if (msgIn.getFault() != null) {
            this.logger.info("Fault in the JBI message.");
            Fault fault = (Fault)operation.getFaults().values().iterator().next();
            try {
                Transformer trans = TransformerFactory.newInstance().newTransformer();
                DOMResult result = new DOMResult();
                trans.transform(msgIn.getFault().getContent(), result);
                Element faultDoc = ((Document)result.getNode()).getDocumentElement();
                messageReturned = BpelSOAPUtil.buildMessageFromDocumentSOAPBodyElement((Collection)fault.getMessage().getOrderedParts(null), (Element)((Element)faultDoc.getElementsByTagName("detail").item(0).getFirstChild()));
            }
            catch (TransformerException e) {
                this.logger.warning("Error during transformation : JBI fault to BPEL one.");
                e.printStackTrace();
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Throwing BPEL message fault '" + fault.getName() + "'.");
                this.logger.finest(messageReturned + "");
            }
            throw new FaultWithMessageVariable(QName.valueOf(fault.getName()), messageReturned);
        }
        if (operation.getOutput() != null) {
            try {
                messageReturned = BpelSOAPUtil.buildMessageFromDocumentSOAPBodyElement((Collection)operation.getOutput().getMessage().getOrderedParts(null), (Element)msgIn.getOutMessageContentAsDocument().getDocumentElement());
            }
            catch (MessagingException e) {
                this.logger.severe("Error during message transformation (BPEL->JBI).");
                throw new OrchestraRuntimeException((Throwable)e);
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("bpel message returned: " + messageReturned);
            }
        }
        this.logger.finest("JBI message sent");
        return messageReturned;
    }

    public final QName getService(Element ii) {
        this.logger.log(Level.FINEST, "Entering in getService method");
        Element serviceRefElem = ii;
        Element endpointRef = (Element)serviceRefElem.getElementsByTagName("EndpointReference").item(0);
        for (int i = 0; i < serviceRefElem.getChildNodes().getLength(); ++i) {
            Element element;
            Node node = serviceRefElem.getChildNodes().item(i);
            if (!(node instanceof Element) || !(element = (Element)node).getNodeName().contains("EndpointReference")) continue;
            endpointRef = element;
        }
        Element serviceElmt = (Element)endpointRef.getElementsByTagName("ServiceName").item(0);
        String serviceName = null;
        String prefixName = null;
        if (serviceElmt.getTextContent().indexOf(":") > -1) {
            serviceName = serviceElmt.getTextContent().substring(serviceElmt.getTextContent().indexOf(":") + 1).trim();
            prefixName = serviceElmt.getTextContent().substring(0, serviceElmt.getTextContent().indexOf(":")).trim();
        } else {
            serviceName = serviceElmt.getTextContent();
        }
        String serviceNamespace = serviceElmt.lookupNamespaceURI(prefixName);
        if (serviceNamespace == null) {
            String prefixTmp = null;
            NamedNodeMap list = serviceElmt.getAttributes();
            for (int i = 0; i < list.getLength(); ++i) {
                prefixTmp = list.item(i).getNodeName().indexOf(":") > -1 ? list.item(i).getNodeName().substring(list.item(i).getNodeName().indexOf(":") + 1) : list.item(i).getNodeName();
                if (prefixName == null || !prefixName.equals(prefixTmp)) continue;
                serviceNamespace = list.item(i).getNodeValue();
            }
        }
        QName service = new QName(serviceNamespace, serviceName.trim());
        this.logger.log(Level.FINEST, "service name: " + service);
        this.logger.log(Level.FINEST, "Exit of the getService method");
        return service;
    }

    public final String getEndPointName(Element ii) {
        String endpointName = null;
        this.logger.log(Level.FINEST, "Entering in getEndPointName method");
        Element serviceRefElem = ii;
        Element endpointRef = null;
        if (serviceRefElem.getElementsByTagName("EndpointReference").getLength() > 0) {
            endpointRef = (Element)serviceRefElem.getElementsByTagName("EndpointReference").item(0);
        } else {
            for (int i = 0; i < serviceRefElem.getChildNodes().getLength(); ++i) {
                Element element;
                Node node = serviceRefElem.getChildNodes().item(i);
                if (!(node instanceof Element) || !(element = (Element)node).getNodeName().contains("EndpointReference")) continue;
                endpointRef = element;
            }
        }
        if (endpointRef != null) {
            Node endpoint = null;
            if (endpointRef.getElementsByTagName("Address").getLength() > 0) {
                endpoint = (Element)endpointRef.getElementsByTagName("Address").item(0);
            }
            if (endpoint != null) {
                endpointName = endpoint.getTextContent();
            }
        }
        this.logger.log(Level.FINEST, "endpoint name found: " + endpointName);
        this.logger.log(Level.FINEST, "Exit of the getEndPointName method");
        return endpointName;
    }

    public final ServiceEndpoint resolveEndPoint(QName service, String endpointName) throws OrchestraEngineException {
        this.logger.log(Level.FINEST, "find the endPoint in the JBI environment");
        this.logger.log(Level.FINEST, "service name: " + service);
        this.logger.log(Level.FINEST, "endpoint name: " + endpointName);
        ServiceEndpoint endpoint = this.context.getEndpoint(service, endpointName);
        if (endpoint == null) {
            throw new OrchestraEngineException("endpoint (" + service + "-" + endpointName + ") not found in the JBI environment");
        }
        this.logger.log(Level.FINEST, "endpoint service found: " + endpoint);
        return endpoint;
    }
}

