/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.api.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;

public class PropertiesUtil {
    public static final Properties loadProperties(String propertiesFilePath) throws PEtALSCDKException {
        Properties properties = new Properties();
        if (propertiesFilePath != null) {
            InputStream propFileStream = null;
            try {
                propFileStream = PropertiesUtil.loadPropertiesFileFromUrl(new URL(propertiesFilePath));
            }
            catch (MalformedURLException e) {
                propFileStream = PropertiesUtil.loadPropertiesFileFromRelativePath(propertiesFilePath);
            }
            if (propFileStream != null) {
                try {
                    properties.load(propFileStream);
                }
                catch (IOException e) {
                    throw new PEtALSCDKException("Cannot find properties at location : " + propertiesFilePath);
                }
            } else {
                throw new PEtALSCDKException("Cannot find properties at location : " + propertiesFilePath);
            }
        }
        return properties;
    }

    public static void fillPlaceHolder(String propertiesFilePath, Map<String, String> extensions) throws PEtALSCDKException {
        Properties externalProperties = PropertiesUtil.loadProperties(propertiesFilePath);
        PropertiesUtil.fillPlaceHolder(externalProperties, extensions);
    }

    public static void fillPlaceHolder(Properties fromProperties, Map<String, String> extensions) {
        for (Map.Entry<String, String> entry : extensions.entrySet()) {
            String entryValue = entry.getValue();
            String key = entry.getKey();
            if (entryValue == null || entryValue.indexOf("${") < 0) continue;
            List<String> placeHolderKeys = PropertiesUtil.extractPlaceHolderKeys(entryValue);
            String newEntryValue = PropertiesUtil.fillPlaceHolder(entryValue, placeHolderKeys, fromProperties);
            extensions.put(key, newEntryValue);
        }
    }

    public static List<String> extractPlaceHolderKeys(String entryValue) {
        String[] keys;
        ArrayList<String> result = new ArrayList<String>();
        for (String string : keys = entryValue.split("[${]")) {
            if (string.indexOf("}") < 0) continue;
            result.add(string.split("[}]")[0]);
        }
        return result;
    }

    public static String fillPlaceHolder(String entryValue, List<String> placeHolderKeys, Properties fromProperties) {
        String result = entryValue;
        for (String key : placeHolderKeys) {
            String extPropertyValue = fromProperties.getProperty(key);
            if (extPropertyValue != null) {
                result = result.replace("${" + key + "}", extPropertyValue);
                continue;
            }
            result = result.replace("${" + key + "}", "");
        }
        return result;
    }

    private static final InputStream loadPropertiesFileFromRelativePath(String propertiesFilePath) {
        File propFile;
        InputStream result = null;
        String petalsHome = System.getenv("PETALS_HOME");
        if (petalsHome != null && (propFile = new File(petalsHome, propertiesFilePath)).exists()) {
            try {
                return new FileInputStream(propFile);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        return result;
    }

    private static final InputStream loadPropertiesFileFromUrl(URL url) {
        InputStream result = null;
        try {
            result = PropertiesUtil.getInputStream(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static final InputStream getInputStream(URL url) throws PEtALSCDKException {
        URLConnection connection = null;
        InputStream is = null;
        try {
            connection = url.openConnection();
            is = connection.getInputStream();
        }
        catch (IOException e) {
            throw new PEtALSCDKException("Can not get InputStream from URL " + url, e);
        }
        return is;
    }
}

