/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework;

import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.component.framework.ComponentWsdl;
import org.ow2.petals.component.framework.api.Interceptor;
import org.ow2.petals.component.framework.api.PetalsComponent;
import org.ow2.petals.component.framework.api.Wsdl;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.notification.NotificationBrokerController;
import org.ow2.petals.component.framework.jbidescriptor.CDKJBIDescriptorException;
import org.ow2.petals.component.framework.jbidescriptor.JBIDescriptorBuilder;
import org.ow2.petals.component.framework.jbidescriptor.generated.Component;
import org.ow2.petals.component.framework.jbidescriptor.generated.ComponentInterceptor;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.mbean.InterceptorManager;
import org.ow2.petals.component.framework.mbean.MBeanHelper;
import org.ow2.petals.component.framework.mbean.RuntimeConfigurationNotifier;
import org.ow2.petals.component.framework.notification.NotificationService;
import org.ow2.petals.component.framework.process.JBIAcceptorManager;
import org.ow2.petals.component.framework.process.JBIProcessorManager;
import org.ow2.petals.component.framework.process.async.AsyncMessageManager;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.util.ServiceEndpointKey;
import org.ow2.petals.component.framework.util.StringHelper;
import org.ow2.petals.component.framework.util.UtilFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public abstract class AbstractComponent
implements PetalsComponent {
    protected ComponentContext context;
    private org.ow2.petals.component.framework.api.notification.NotificationService notificationService;
    private JBIAcceptorManager acceptorManager;
    private AsyncMessageManager asyncManager;
    private DeliveryChannel channel;
    private ConfigurationExtensions componentExtensions;
    private Map<ServiceEndpointKey, ServiceEndpoint> componentServiceEndpoints;
    private InterceptorManager interceptorManager;
    private Map<String, Interceptor> interceptors;
    private Jbi jbiComponentConfiguration;
    private Logger logger;
    private Wsdl nativeWsdl;
    private JBIProcessorManager processorManager;
    private RuntimeConfigurationNotifier runtimeConfigurationNotifier;
    private AbstractServiceUnitManager suManager;

    public AsyncMessageManager getAsyncManager() {
        return this.asyncManager;
    }

    public DeliveryChannel getChannel() {
        return this.channel;
    }

    public Component getComponentConfiguration() {
        return this.jbiComponentConfiguration.getComponent();
    }

    public ConfigurationExtensions getComponentExtensions() {
        return this.componentExtensions;
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public ObjectName getExtensionMBeanName() {
        return null;
    }

    public Interceptor getInterceptor(String name) {
        Interceptor interceptor = null;
        if (this.interceptors != null) {
            interceptor = this.interceptors.get(name);
        }
        return interceptor;
    }

    public Map<String, Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public ComponentLifeCycle getLifeCycle() {
        return this;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Wsdl getNativeWsdl() {
        return this.nativeWsdl;
    }

    @Deprecated
    public NotificationBrokerController getNotificationBrokerController() {
        return this.notificationService.getNotificationBrokerController();
    }

    public Document getServiceDescription(ServiceEndpoint endpoint) {
        if (endpoint == null) {
            return null;
        }
        try {
            if (this.componentServiceEndpoints != null && !this.componentServiceEndpoints.isEmpty() && this.componentServiceEndpoints.get(new ServiceEndpointKey(endpoint.getServiceName(), endpoint.getEndpointName())) != null) {
                if (this.nativeWsdl != null && UtilFactory.getWSDLUtil().isDescriptionContaining(this.nativeWsdl.getDescription(), endpoint)) {
                    return this.nativeWsdl.getDocument();
                }
                if (this.getNotificationBrokerController() != null) {
                    if (this.getNotificationBrokerController().getNotificationProducer() != null && this.getNotificationBrokerController().getNotificationProducer().getWsdl() != null && this.getNotificationBrokerController().getNotificationProducer().getWsdl().getDescription() != null && UtilFactory.getWSDLUtil().isDescriptionContaining(this.getNotificationBrokerController().getNotificationProducer().getWsdl().getDescription(), endpoint)) {
                        return this.getNotificationBrokerController().getNotificationProducer().getWsdl().getDocument();
                    }
                    if (this.getNotificationBrokerController().getNotificationConsumer() != null && this.getNotificationBrokerController().getNotificationConsumer().getWsdl() != null && this.getNotificationBrokerController().getNotificationConsumer().getWsdl().getDescription() != null && UtilFactory.getWSDLUtil().isDescriptionContaining(this.getNotificationBrokerController().getNotificationConsumer().getWsdl().getDescription(), endpoint)) {
                        return this.getNotificationBrokerController().getNotificationConsumer().getWsdl().getDocument();
                    }
                }
            }
        }
        catch (WSDLException e) {
            this.logger.warning("Unable to found the endpoint managed by the component: " + e.getMessage() + ". Search it into the Service Unit Manager...");
        }
        return this.suManager.getServiceDescription(endpoint);
    }

    public ServiceUnitManager getServiceUnitManager() {
        return this.suManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(ComponentContext compContext) throws JBIException {
        this.context = compContext;
        this.logger = this.context.getLogger("", this.getResourceBundleName());
        this.logger.info("Init component...");
        this.channel = this.context.getDeliveryChannel();
        File jbiXmlFile = new File(compContext.getInstallRoot() + File.separator + "META-INF" + File.separator + "jbi.xml");
        try {
            File wsdlFile;
            FileInputStream jbiInputStream = new FileInputStream(jbiXmlFile);
            try {
                this.jbiComponentConfiguration = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)jbiInputStream);
            }
            finally {
                try {
                    jbiInputStream.close();
                }
                catch (IOException e) {}
            }
            this.componentExtensions = this.jbiComponentConfiguration.getComponent().getPropertiesFile() != null && !StringHelper.isNullOrEmpty(this.jbiComponentConfiguration.getComponent().getPropertiesFile().getValue()) ? new ConfigurationExtensions(this.jbiComponentConfiguration.getComponent().getAny(), this.jbiComponentConfiguration.getComponent().getPropertiesFile().getValue()) : new ConfigurationExtensions(this.jbiComponentConfiguration.getComponent().getAny());
            this.runtimeConfigurationNotifier = new RuntimeConfigurationNotifier(this.jbiComponentConfiguration, jbiXmlFile, this.logger);
            this.interceptors = this.loadInterceptors();
            this.interceptorManager = new InterceptorManager(this, this.jbiComponentConfiguration, jbiXmlFile);
            if (this.suManager == null) {
                this.suManager = this.createServiceUnitManager();
            }
            if ((wsdlFile = new File(compContext.getWorkspaceRoot() + File.separator + "native-service" + File.separator + "component.wsdl")) != null && wsdlFile.exists()) {
                Description description = UtilFactory.getWSDLUtil().createWsdlDescription(wsdlFile.toURI().toURL());
                this.nativeWsdl = new ComponentWsdl(description);
            }
            this.notificationService = new NotificationService(this);
            this.notificationService.init();
            this.componentServiceEndpoints = new ConcurrentHashMap<ServiceEndpointKey, ServiceEndpoint>();
        }
        catch (CDKJBIDescriptorException e) {
            throw new JBIException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new JBIException((Throwable)e);
        }
        catch (PEtALSCDKException e) {
            throw new JBIException((Throwable)e);
        }
        catch (WSDLException e) {
            throw new JBIException((Throwable)e);
        }
        catch (WSNotificationException e) {
            throw new JBIException((Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new JBIException((Throwable)e);
        }
        this.logger.fine("Calling initialization method on component implementation...");
        this.doInit();
        this.logger.fine("Specific initialization done.");
        this.processorManager = new JBIProcessorManager(this, this.runtimeConfigurationNotifier, this.logger);
        this.acceptorManager = new JBIAcceptorManager(this, this.processorManager, this.runtimeConfigurationNotifier, this.logger);
        this.asyncManager = new AsyncMessageManager(this.logger, this.processorManager);
        this.logger.info("Component initialized");
    }

    public boolean isExchangeWithConsumerOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
        return true;
    }

    public boolean isExchangeWithProviderOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
        return true;
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutDown() throws JBIException {
        this.logger.info("Shut down component...");
        try {
            this.logger.fine("Calling specific shut down...");
            this.doShutdown();
            this.logger.fine("Specific shut down done.");
        }
        finally {
            this.nativeWsdl = null;
            this.notificationService = null;
            if (this.componentServiceEndpoints != null) {
                this.componentServiceEndpoints.clear();
                this.componentServiceEndpoints = null;
            }
            this.channel = null;
            this.runtimeConfigurationNotifier = null;
            this.interceptors = null;
            this.interceptorManager = null;
            this.acceptorManager = null;
            this.processorManager = null;
            this.asyncManager = null;
        }
        this.logger.info("Component shut down");
    }

    public final void start() throws JBIException {
        this.logger.info("Start component...");
        if (this.channel == null) {
            this.channel = this.context.getDeliveryChannel();
        }
        this.registerRuntimeConfigMBean();
        this.registerInterceptorManagerMBean();
        this.processorManager.start();
        this.acceptorManager.start();
        this.asyncManager.start();
        this.activateServiceEndpointList();
        this.notificationService.start();
        this.logger.fine("Calling specific start...");
        this.doStart();
        this.logger.info("Component started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws JBIException {
        this.logger.info("Stop component...");
        try {
            this.logger.fine("Calling specific stop...");
            this.doStop();
            this.logger.fine("Specific stop done.");
        }
        finally {
            this.notificationService.stop();
            this.deactivateServiceEndpointList();
            this.unregisterRuntimeConfigurationMBean();
            this.unregisterInterceptorManagerMBean();
            this.acceptorManager.stop();
            this.processorManager.stop();
            this.asyncManager.stop();
        }
        this.logger.info("Component stopped");
    }

    protected abstract AbstractServiceUnitManager createServiceUnitManager();

    protected void doInit() throws JBIException {
    }

    protected void doShutdown() throws JBIException {
    }

    protected void doStart() throws JBIException {
    }

    protected void doStop() throws JBIException {
    }

    protected String getResourceBundleName() {
        return null;
    }

    public ServiceEndpoint activateEndpoint(QName serviceName, String endpointName) throws JBIException {
        ServiceEndpointKey key = new ServiceEndpointKey(serviceName, endpointName);
        this.componentServiceEndpoints.put(key, new ComponentServiceEndpoint(serviceName, endpointName));
        ServiceEndpoint se = this.context.activateEndpoint(serviceName, endpointName);
        this.componentServiceEndpoints.put(key, se);
        return se;
    }

    private void activateServiceEndpointList() throws JBIException {
        try {
            Iterator iterator;
            QName serviceName = null;
            String endpointName = null;
            List endpointList = null;
            if (this.nativeWsdl != null && (endpointList = UtilFactory.getWSDLUtil().getEndpointList(this.nativeWsdl.getDescription())) != null && (iterator = endpointList.iterator()) != null) {
                while (iterator.hasNext()) {
                    Endpoint endpoint = (Endpoint)iterator.next();
                    if (endpoint == null) continue;
                    serviceName = ((Service)endpoint.getService()).getQName();
                    endpointName = endpoint.getName();
                    this.activateEndpoint(serviceName, endpointName);
                }
            }
        }
        catch (WSDLException e) {
            throw new JBIException("Unable to activate the endpoints managed by the component", (Throwable)e);
        }
    }

    private void deactivateServiceEndpointList() throws JBIException {
        if (this.componentServiceEndpoints != null) {
            for (ServiceEndpointKey key : this.componentServiceEndpoints.keySet()) {
                this.deactivateEndpoint(this.componentServiceEndpoints.get(key));
            }
            this.componentServiceEndpoints.clear();
        }
    }

    public void deactivateEndpoint(ServiceEndpoint serviceEndpoint) throws JBIException {
        this.context.deactivateEndpoint(serviceEndpoint);
        this.componentServiceEndpoints.remove(new ServiceEndpointKey(serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName()));
    }

    private final Map<String, Interceptor> loadInterceptors() {
        HashMap<String, Interceptor> interceptors = new HashMap<String, Interceptor>();
        if (this.jbiComponentConfiguration.getComponent().getComponentInterceptors() != null) {
            for (ComponentInterceptor componentInterceptor : this.jbiComponentConfiguration.getComponent().getComponentInterceptors().getInterceptor()) {
                try {
                    this.logger.info("Loading interceptor : " + componentInterceptor.getName());
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(componentInterceptor.getClazz());
                    Interceptor itc = (Interceptor)clazz.newInstance();
                    ConfigurationExtensions configurationExtensions = this.jbiComponentConfiguration.getComponent().getPropertiesFile() != null && !StringHelper.isNullOrEmpty(this.jbiComponentConfiguration.getComponent().getPropertiesFile().getValue()) ? new ConfigurationExtensions(componentInterceptor.getParam(), this.jbiComponentConfiguration.getComponent().getPropertiesFile().getValue()) : new ConfigurationExtensions(componentInterceptor.getParam());
                    itc.init((PetalsComponent)this, componentInterceptor.getName(), componentInterceptor.isActive(), (Map)configurationExtensions, this.logger);
                    interceptors.put(componentInterceptor.getName(), itc);
                }
                catch (PEtALSCDKException e) {
                    this.logger.log(Level.WARNING, "Could not load or initialize interceptor '" + componentInterceptor.getName() + "' from class '" + componentInterceptor.getClazz() + "', this interceptor is skipped. Cause : ", e);
                }
                catch (ClassNotFoundException e) {
                    this.logger.log(Level.WARNING, "Could not load or initialize interceptor '" + componentInterceptor.getName() + "' from class '" + componentInterceptor.getClazz() + "', this interceptor is skipped. Cause : ", e);
                }
                catch (InstantiationException e) {
                    this.logger.log(Level.WARNING, "Could not load or initialize interceptor '" + componentInterceptor.getName() + "' from class '" + componentInterceptor.getClazz() + "', this interceptor is skipped. Cause : ", e);
                }
                catch (IllegalAccessException e) {
                    this.logger.log(Level.WARNING, "Could not load or initialize interceptor '" + componentInterceptor.getName() + "' from class '" + componentInterceptor.getClazz() + "', this interceptor is skipped. Cause : ", e);
                }
                catch (ClassCastException e) {
                    this.logger.log(Level.WARNING, "Could not load or initialize interceptor '" + componentInterceptor.getName() + "' from class '" + componentInterceptor.getClazz() + "', this interceptor is skipped. Cause : ", e);
                }
            }
        }
        return interceptors;
    }

    private void registerInterceptorManagerMBean() throws JBIException {
        ObjectName mbeanName = this.context.getMBeanNames().createCustomComponentMBeanName("interceptors_" + this.context.getComponentName());
        this.interceptorManager.setMBeanName(mbeanName);
        MBeanHelper.registerMBean(this.context.getMBeanServer(), mbeanName, this.interceptorManager);
    }

    private void registerRuntimeConfigMBean() throws JBIException {
        ObjectName runtimeConfigurationMBeanName = this.context.getMBeanNames().createCustomComponentMBeanName("runtime_configuration_" + this.context.getComponentName());
        this.runtimeConfigurationNotifier.setMBeanName(runtimeConfigurationMBeanName);
        MBeanHelper.registerMBean(this.context.getMBeanServer(), runtimeConfigurationMBeanName, this.runtimeConfigurationNotifier);
    }

    private void unregisterInterceptorManagerMBean() throws JBIException {
        MBeanHelper.unregisterMBean(this.context.getMBeanServer(), this.interceptorManager.getMBeanName());
    }

    private void unregisterRuntimeConfigurationMBean() throws JBIException {
        MBeanHelper.unregisterMBean(this.context.getMBeanServer(), this.runtimeConfigurationNotifier.getMBeanName());
    }

    public org.ow2.petals.component.framework.api.notification.NotificationService getNotificationService() {
        return this.notificationService;
    }

    private static class ComponentServiceEndpoint
    implements ServiceEndpoint {
        private QName s = null;
        private String e = null;

        public ComponentServiceEndpoint(QName serviceName, String endpointName) {
            this.s = serviceName;
            this.e = endpointName;
        }

        public DocumentFragment getAsReference(QName operationName) {
            return null;
        }

        public String getEndpointName() {
            return this.e;
        }

        public QName[] getInterfaces() {
            return null;
        }

        public QName getServiceName() {
            return this.s;
        }
    }
}

