/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.constants;

import java.net.URI;

public enum SoapEnvelope {
    SOAP11_NS("http://schemas.xmlsoap.org/soap/envelope/"),
    SOAP12_NS("http://www.w3.org/2003/05/soap-envelope");

    private final String nameSpace;
    private final URI soapURI;

    public static SoapEnvelope valueOf(URI pattern) {
        SoapEnvelope result = null;
        if (pattern != null) {
            for (SoapEnvelope soap : SoapEnvelope.values()) {
                if (!soap.nameSpace.equals(pattern.toString())) continue;
                result = soap;
            }
        }
        return result;
    }

    private SoapEnvelope(String nameSpace) {
        this.nameSpace = nameSpace;
        this.soapURI = URI.create(nameSpace);
    }

    public URI value() {
        return this.soapURI;
    }
}

