/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.notification;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.namespace.QName;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.notification.Sender;
import org.ow2.petals.component.framework.api.notification.StatusListener;

public class AsyncSender
implements org.ow2.petals.component.framework.api.notification.AsyncSender {
    private Sender sender;
    private StatusListener listener;
    private ExecutorService executor;

    public AsyncSender(Sender sender, StatusListener listener) {
        this.sender = sender;
        this.listener = listener;
        this.executor = Executors.newCachedThreadPool();
    }

    public StatusListener getStatusListener() {
        return this.listener;
    }

    public void send(final DestroyRegistration destroyRegistration) throws PEtALSCDKException {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        DestroyRegistrationResponse response = AsyncSender.this.sender.send(destroyRegistration);
                        if (AsyncSender.this.getStatusListener() != null) {
                            AsyncSender.this.getStatusListener().onUnregistered(response);
                        }
                    }
                    catch (Exception e) {
                        if (AsyncSender.this.getStatusListener() == null) break block3;
                        AsyncSender.this.getStatusListener().onException(e);
                    }
                }
            }
        });
    }

    public void send(final DestroyRegistration destroyRegistration, final SOAParameterType soaParameterType) throws PEtALSCDKException {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        DestroyRegistrationResponse response = AsyncSender.this.sender.send(destroyRegistration, soaParameterType);
                        if (AsyncSender.this.getStatusListener() != null) {
                            AsyncSender.this.getStatusListener().onUnregistered(response);
                        }
                    }
                    catch (Exception e) {
                        if (AsyncSender.this.getStatusListener() == null) break block3;
                        AsyncSender.this.getStatusListener().onException(e);
                    }
                }
            }
        });
    }

    public void send(final RegisterPublisher registerPublisher) throws PEtALSCDKException {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        RegisterPublisherResponse response = AsyncSender.this.sender.send(registerPublisher);
                        if (AsyncSender.this.getStatusListener() != null) {
                            AsyncSender.this.getStatusListener().onRegistered(response);
                        }
                    }
                    catch (Exception e) {
                        if (AsyncSender.this.getStatusListener() == null) break block3;
                        AsyncSender.this.getStatusListener().onException(e);
                    }
                }
            }
        });
    }

    public void send(final Subscribe subscribe, final QName targetServName, final String targetEpName) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        SubscribeResponse response = AsyncSender.this.sender.send(subscribe, targetServName, targetEpName);
                        if (AsyncSender.this.getStatusListener() != null) {
                            AsyncSender.this.getStatusListener().onSubscribed(response);
                        }
                    }
                    catch (Exception e) {
                        if (AsyncSender.this.getStatusListener() == null) break block3;
                        AsyncSender.this.getStatusListener().onException(e);
                    }
                }
            }
        });
    }

    public void send(final Subscribe subscribe) throws PEtALSCDKException {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        SubscribeResponse response = AsyncSender.this.sender.send(subscribe);
                        if (AsyncSender.this.getStatusListener() != null) {
                            AsyncSender.this.getStatusListener().onSubscribed(response);
                        }
                    }
                    catch (Exception e) {
                        if (AsyncSender.this.getStatusListener() == null) break block3;
                        AsyncSender.this.getStatusListener().onException(e);
                    }
                }
            }
        });
    }

    public void send(final Unsubscribe unsubscribe) throws PEtALSCDKException {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        UnsubscribeResponse response = AsyncSender.this.sender.send(unsubscribe);
                        if (AsyncSender.this.getStatusListener() != null) {
                            AsyncSender.this.getStatusListener().onUnsubscribed(response);
                        }
                    }
                    catch (Exception e) {
                        if (AsyncSender.this.getStatusListener() == null) break block3;
                        AsyncSender.this.getStatusListener().onException(e);
                    }
                }
            }
        });
    }

    public void send(final Notify notify, final EndpointReferenceType consumerReference) throws PEtALSCDKException {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        AsyncSender.this.sender.send(notify, consumerReference);
                    }
                    catch (Exception e) {
                        if (AsyncSender.this.getStatusListener() == null) break block2;
                        AsyncSender.this.getStatusListener().onException(e);
                    }
                }
            }
        });
    }

    public void abort() throws PEtALSCDKException {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public boolean isStopped() {
        if (this.executor != null) {
            return this.executor.isShutdown();
        }
        return true;
    }
}

