/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.notification;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.notification.LifeCyle;
import org.ow2.petals.component.framework.notification.NotificationContext;
import org.ow2.petals.component.framework.notification.NotificationService;
import org.ow2.petals.component.framework.notification.NotificationStorageService;
import org.ow2.petals.component.framework.notification.Sender;
import org.ow2.petals.component.framework.util.RetryTaskExecutor;
import org.ow2.petals.component.framework.util.StringHelper;

public class WrappedSender
extends Sender
implements org.ow2.petals.component.framework.api.notification.Sender,
LifeCyle {
    private Logger logger;
    private final NotificationStorageService storageService;
    private final NotificationContext notificationContext;
    private ExecutorService registrationExecutor;
    private ExecutorService executor;
    private NotificationService notificationService;

    public WrappedSender(ComponentContext componentContext, NotificationService notificationService, NotificationStorageService storageService, NotificationContext notificationContext, Logger logger) throws WSNotificationException, MessagingException {
        super(componentContext);
        this.notificationService = notificationService;
        this.storageService = storageService;
        this.notificationContext = notificationContext;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Notify notify, EndpointReferenceType consumerReference) throws WSAddressingException, WSNotificationExtensionException, WSNotificationException, MessagingException, PEtALSCDKException {
        if (!this.isRegistered()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Not registered as publisher, persist the notification for future send");
            }
            this.persist(notify);
        } else {
            boolean failure = false;
            try {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "Normal notification sending...");
                }
                super.send(notify, consumerReference);
            }
            catch (MessagingException e) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "Can not send the notification", e);
                } else {
                    this.logger.warning("Can not send the notification");
                }
                failure = true;
            }
            catch (PEtALSCDKException e) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "Can not send the notification", e);
                } else {
                    this.logger.warning("Can not send the notification");
                }
                failure = true;
            }
            finally {
                if (failure) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "A problem occured during notification emission, persist the notification for future emission");
                    }
                    this.persist(notify);
                }
            }
        }
    }

    private boolean isRegistered() {
        return this.notificationContext.isRegistered();
    }

    @Override
    public RegisterPublisherResponse send(RegisterPublisher registerPublisher) throws MessagingException, WSNotificationException, PEtALSCDKException {
        RegisterPublisherResponse response = null;
        RegistrationTask registrationTask = new RegistrationTask(registerPublisher);
        Future<RegisterPublisherResponse> f = this.registrationExecutor.submit(registrationTask);
        try {
            response = f.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        if (response != null) {
            this.notificationService.onRegistered(response);
        }
        return response;
    }

    @Override
    public DestroyRegistrationResponse send(DestroyRegistration destroyRegistration) throws MessagingException, WSNotificationException, PEtALSCDKException {
        DestroyRegistrationResponse result = super.send(destroyRegistration);
        if (result == null) {
            throw new WSNotificationException("Unregister publisher on broker failed");
        }
        this.notificationService.onUnregistered(result);
        return result;
    }

    @Override
    public SubscribeResponse send(Subscribe subscribe) throws MessagingException, WSNotificationException, PEtALSCDKException {
        return this.send(subscribe, null, null);
    }

    @Override
    public SubscribeResponse send(Subscribe subscribe, QName targetServName, String targetEpName) throws MessagingException, WSNotificationException, PEtALSCDKException {
        SubscribeResponse response = null;
        SubscribeTask subscribeTask = new SubscribeTask(subscribe, targetServName, targetEpName);
        Future<SubscribeResponse> f = this.executor.submit(subscribeTask);
        try {
            response = f.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        if (response != null) {
            this.notificationService.onSubscribed(response);
        }
        return response;
    }

    @Override
    public UnsubscribeResponse send(Unsubscribe unsubscribe) throws MessagingException, WSNotificationException, PEtALSCDKException {
        UnsubscribeResponse result = super.send(unsubscribe);
        if (result != null) {
            this.notificationService.onUnsubscribed(result);
        }
        return result;
    }

    private void persist(Notify notify) {
        try {
            this.storageService.store(notify);
        }
        catch (PEtALSCDKException e) {
            e.printStackTrace();
        }
    }

    public void init() throws PEtALSCDKException {
    }

    public void start() throws PEtALSCDKException {
        this.registrationExecutor = Executors.newSingleThreadExecutor();
        this.executor = Executors.newCachedThreadPool();
    }

    public void stop() throws PEtALSCDKException {
        if (this.registrationExecutor != null) {
            this.registrationExecutor.shutdownNow();
        }
        this.registrationExecutor = null;
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.executor = null;
    }

    class SubscribeTask
    implements Callable<SubscribeResponse> {
        private Subscribe subscribe;
        private QName serviceName;
        private String epName;
        private RetryTaskExecutor executor;

        public SubscribeTask(Subscribe subscribe, QName targetServName, String targetEpName) {
            this.subscribe = subscribe;
            this.serviceName = targetServName;
            this.epName = targetEpName;
        }

        @Override
        public SubscribeResponse call() throws Exception {
            SubscribeResponse result = null;
            this.executor = new RetryTaskExecutor("Subscribe task", WrappedSender.this.logger, WrappedSender.this.notificationContext.getMinDelay(), WrappedSender.this.notificationContext.getMaxDelay(), WrappedSender.this.notificationContext.getDelayFactor(), TimeUnit.SECONDS, WrappedSender.this.notificationContext.getNbRetry());
            Callable<SubscribeResponse> callable = new Callable<SubscribeResponse>(){

                @Override
                public SubscribeResponse call() throws Exception {
                    if (WrappedSender.this.logger.isLoggable(Level.FINE)) {
                        WrappedSender.this.logger.fine("Trying to register myself to the notification producer as notification receiver...");
                    }
                    if (SubscribeTask.this.serviceName == null || StringHelper.isNullOrEmpty(SubscribeTask.this.epName)) {
                        return WrappedSender.super.send(SubscribeTask.this.subscribe);
                    }
                    return WrappedSender.super.send(SubscribeTask.this.subscribe, SubscribeTask.this.serviceName, SubscribeTask.this.epName);
                }
            };
            try {
                result = this.executor.tryExecute(callable);
            }
            catch (Exception e) {
                WrappedSender.this.logger.fine(e.getMessage());
            }
            return result;
        }
    }

    class RegistrationTask
    implements Callable<RegisterPublisherResponse> {
        private RetryTaskExecutor executor;
        private final RegisterPublisher registerPublisher;

        public RegistrationTask(RegisterPublisher registerPublisher) {
            this.registerPublisher = registerPublisher;
        }

        @Override
        public RegisterPublisherResponse call() throws Exception {
            RegisterPublisherResponse result = null;
            this.executor = new RetryTaskExecutor("Register publisher task", WrappedSender.this.logger, WrappedSender.this.notificationContext.getMinDelay(), WrappedSender.this.notificationContext.getMaxDelay(), WrappedSender.this.notificationContext.getDelayFactor(), TimeUnit.SECONDS, WrappedSender.this.notificationContext.getNbRetry());
            Callable<RegisterPublisherResponse> callable = new Callable<RegisterPublisherResponse>(){

                @Override
                public RegisterPublisherResponse call() throws Exception {
                    if (WrappedSender.this.logger.isLoggable(Level.FINE)) {
                        WrappedSender.this.logger.fine("Trying to register myself as publisher to the broker...");
                    }
                    return WrappedSender.super.send(RegistrationTask.this.registerPublisher);
                }
            };
            try {
                result = this.executor.tryExecute(callable);
            }
            catch (Exception e) {
                WrappedSender.this.logger.fine(e.getMessage());
            }
            return result;
        }

        public void cancel() {
            this.executor.cancel();
        }
    }
}

