/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.notification.filter.messagecontent;

import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.QueryExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.ow2.petals.component.framework.notification.filter.AbstractFilter;

public class EndpointFilter
extends AbstractFilter {
    private List<SOAParameterType> soaParameterList = null;

    public EndpointFilter(Subscribe subscribe) throws WSNotificationExtensionException, WSNotificationException {
        super(subscribe);
        SOAParameterType soaParameter = null;
        if (this.filterType != null) {
            List queryExpressionList = this.filterType.getMessageContentList();
            for (QueryExpressionType queryExpression : queryExpressionList) {
                soaParameter = WsnSpecificTypeHelper.getSOAParameter((QueryExpressionType)queryExpression);
                if (soaParameter == null) continue;
                if (this.soaParameterList == null) {
                    this.soaParameterList = new CopyOnWriteArrayList<SOAParameterType>();
                }
                this.soaParameterList.add(soaParameter);
            }
        }
    }

    public boolean isNotifiable(Object content) {
        ServiceEndpoint serviceEndpoint = null;
        if (this.soaParameterList != null) {
            for (SOAParameterType soaParameter : this.soaParameterList) {
                if (content == null || !(content instanceof ServiceEndpoint)) {
                    return false;
                }
                serviceEndpoint = (ServiceEndpoint)content;
                if (soaParameter.getInterface() != null && !soaParameter.getInterface().equals(serviceEndpoint.getInterfaces()[0])) {
                    return false;
                }
                if (soaParameter.getService() != null && !soaParameter.getService().equals(serviceEndpoint.getServiceName())) {
                    return false;
                }
                if (soaParameter.getEndpoint() == null || soaParameter.getEndpoint().equals(serviceEndpoint.getEndpointName())) continue;
                return false;
            }
        }
        return true;
    }
}

