/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.notification.notify;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.notification.NotificationBrokerController;
import org.ow2.petals.component.framework.api.notification.notify.Notify;
import org.w3c.dom.Document;

public class ComponentNotify
implements Notify {
    protected NotificationBrokerController notificationBrokerController = null;
    protected Logger logger = null;

    public ComponentNotify(NotificationBrokerController notificationBrokerController, Logger logger) {
        this.notificationBrokerController = notificationBrokerController;
        this.logger = logger;
    }

    public void process(Document document, String topic, EndpointReferenceType subscriptionReference) {
        if (this.notificationBrokerController != null) {
            try {
                this.notificationBrokerController.notify(document, topic, subscriptionReference);
            }
            catch (WSNotificationException e) {
                this.logger.info("Unable to send a notification");
                this.logger.fine("Detail on the notification error: " + e.getMessage());
            }
            catch (WSAddressingException e) {
                this.logger.info("Unable to send a notification");
                this.logger.fine("Detail on the notification error: " + e.getMessage());
            }
            catch (WSDLException e) {
                this.logger.info("Unable to send a notification");
                this.logger.fine("Detail on the notification error: " + e.getMessage());
            }
            catch (PEtALSCDKException e) {
                this.logger.info("Unable to send a notification");
                this.logger.fine("Detail on the notification error: " + e.getMessage());
            }
            catch (MessagingException e) {
                this.logger.info("Unable to send a notification");
                this.logger.fine("Detail on the notification error: " + e.getMessage());
            }
            catch (WSNotificationExtensionException e) {
                this.logger.info("Unable to send a notification");
                this.logger.fine("Detail on the notification error: " + e.getMessage());
            }
        }
    }
}

