/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.notification.subscriptionpolicy;

import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionPolicyType;
import com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.api.notification.subscriptionpolicy.SubscriptionPolicy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ContextSubscriptionPolicy
implements SubscriptionPolicy {
    private Exchange exchange = null;
    private Integer status = null;
    private ContextPolicyType contextPolicy = null;

    public void setStatus(int status) {
        this.status = status;
    }

    public ContextSubscriptionPolicy(Subscribe subscribe) throws WSNotificationExtensionException {
        SubscriptionPolicyType subscriptionPolicy = subscribe.getSubscriptionPolicy();
        if (subscriptionPolicy != null) {
            this.contextPolicy = WsnSpecificTypeHelper.getContextPolicyType((SubscriptionPolicyType)subscriptionPolicy);
        }
    }

    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    public Document applyPolicy(Document document) {
        Element root;
        if (this.contextPolicy != null && this.exchange != null && this.status != null && (root = document.getDocumentElement()) != null) {
            if (this.contextPolicy.isInterface().booleanValue()) {
                root.setAttribute("interface", this.exchange.getEndpoint().getInterfaces()[0].toString());
            }
            if (this.contextPolicy.isService().booleanValue()) {
                root.setAttribute("service", this.exchange.getEndpoint().getServiceName().toString());
            }
            if (this.contextPolicy.isEndpoint().booleanValue()) {
                root.setAttribute("endpoint", this.exchange.getEndpoint().getEndpointName());
            }
            if (this.contextPolicy.isMeuuid().booleanValue()) {
                root.setAttribute("meuuid", this.exchange.getExchangeId());
            }
            if (this.contextPolicy.isNotifDate().booleanValue()) {
                root.setAttribute("notifDate", Long.toString(System.currentTimeMillis()));
            }
            if (this.contextPolicy.isCorrelationId().booleanValue() && this.exchange.getProperty("org.ow2.petals.propagate.correlation") != null && this.exchange.getProperty("org.ow2.petals.propagate.correlation") instanceof String) {
                String correlationId = (String)this.exchange.getProperty("org.ow2.petals.propagate.correlation");
                root.setAttribute("correlationId", correlationId);
            }
            if (this.contextPolicy.isStatus().booleanValue()) {
                root.setAttribute("status", this.status.toString());
            }
        }
        this.exchange = null;
        this.status = null;
        return document;
    }
}

