/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.notification.subscriptionpolicy;

import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionPolicyType;
import com.ebmwebsourcing.wsstar.notification.extension.api.XsltStyleSheetType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.petals.component.framework.api.notification.subscriptionpolicy.SubscriptionPolicy;
import org.ow2.petals.component.framework.util.UtilFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XSLTSubscriptionPolicy
implements SubscriptionPolicy {
    private Logger logger = null;
    private Transformer transformer = null;

    public XSLTSubscriptionPolicy(Subscribe subscribe, Logger logger) throws WSNotificationExtensionException, TransformerFactoryConfigurationError, TransformerException, ParserConfigurationException {
        DOMSource source;
        Element element;
        XsltStyleSheetType xsltStyleSheet;
        this.logger = logger;
        SubscriptionPolicyType subscriptionPolicy = subscribe.getSubscriptionPolicy();
        if (subscriptionPolicy != null && (xsltStyleSheet = WsnSpecificTypeHelper.getXsltStyleSheetType((SubscriptionPolicyType)subscriptionPolicy)) != null && (element = xsltStyleSheet.getStyleSheet()) != null && (source = new DOMSource(element)) != null) {
            this.transformer = UtilFactory.getXSLTUtil().createTransformer((Source)source);
        }
    }

    public Document applyPolicy(Document document) {
        try {
            if (this.transformer != null) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("original document: " + this.toString(document));
                }
                document = UtilFactory.getXSLTUtil().transformDocument(document, this.transformer);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("transformed document: " + this.toString(document));
                }
            }
        }
        catch (TransformerException e) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return document;
    }

    private String toString(Document document) throws TransformerException {
        DOMSource domSource = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(domSource, result);
        transformer.reset();
        return writer.toString();
    }
}

