/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.Interceptor;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.interceptor.MessageInterceptorManager;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;

public class MessageInterceptorProcessor {
    protected AbstractComponent component;
    protected Logger logger;

    public MessageInterceptorProcessor(AbstractComponent component, Logger logger) {
        this.component = component;
        this.logger = logger;
    }

    public void intercept(Exchange exchange, Object service, Message.InterceptorPhase interceptorPhase) throws PEtALSCDKException {
        this.logger.fine("Intercepting message processing on " + interceptorPhase);
        this.checkInterceptorPhase(interceptorPhase, service);
        AbstractServiceUnitManager suManager = (AbstractServiceUnitManager)this.component.getServiceUnitManager();
        ServiceUnitDataHandler dataHandler = suManager.getSUDataHandlerForService(service);
        if (dataHandler != null) {
            MessageInterceptorManager messageInterceptorManager = dataHandler.getMessageInterceptorManager(service);
            if (Message.InterceptorPhase.ACCEPT.equals((Object)interceptorPhase)) {
                ((ExchangeImpl)exchange).setCheckRole(false);
            }
            this.intercept(exchange, service, messageInterceptorManager, interceptorPhase);
            if (Message.InterceptorPhase.ACCEPT.equals((Object)interceptorPhase)) {
                ((ExchangeImpl)exchange).setCheckRole(true);
            }
        }
    }

    private void checkInterceptorPhase(Message.InterceptorPhase interceptorPhase, Object service) throws PEtALSCDKException {
        if (Message.InterceptorPhase.ACCEPT.equals((Object)interceptorPhase) || Message.InterceptorPhase.ACCEPT_RESPONSE.equals((Object)interceptorPhase)) {
            if (!(service instanceof Provides)) {
                throw new PEtALSCDKException("The InterceptorPhase is not a Provides InterceptorPhase");
            }
        } else if (!(service instanceof Consumes)) {
            throw new PEtALSCDKException("The InterceptorPhase is not a Consumes InterceptorPhase");
        }
    }

    private void intercept(Exchange exchange, Object service, MessageInterceptorManager messageInterceptorManager, Message.InterceptorPhase interceptorPhase) {
        Map<String, Interceptor> interceptors = null;
        Map<String, ConfigurationExtensions> additionalConfiguration = null;
        if (interceptorPhase == Message.InterceptorPhase.ACCEPT) {
            interceptors = messageInterceptorManager.getInputOrderedInterceptors();
            additionalConfiguration = messageInterceptorManager.getInputAdditionalConfiguration();
        } else if (interceptorPhase == Message.InterceptorPhase.SEND) {
            interceptors = messageInterceptorManager.getOutputOrderedInterceptors();
            additionalConfiguration = messageInterceptorManager.getOutputAdditionalConfiguration();
        } else if (interceptorPhase == Message.InterceptorPhase.ACCEPT_RESPONSE) {
            interceptors = messageInterceptorManager.getInputResponseOrderedInterceptors();
            additionalConfiguration = messageInterceptorManager.getInputResponseAdditionalConfiguration();
        } else if (interceptorPhase == Message.InterceptorPhase.SEND_RESPONSE) {
            interceptors = messageInterceptorManager.getOutputResponseOrderedInterceptors();
            additionalConfiguration = messageInterceptorManager.getOutputResponseAdditionalConfiguration();
        } else {
            throw new IllegalArgumentException("Unknown InterceptorPhase: " + interceptorPhase.toString());
        }
        for (Map.Entry<String, Interceptor> entry : interceptors.entrySet()) {
            Interceptor interceptor = entry.getValue();
            String interceptorName = entry.getKey();
            this.logger.fine("Calling message interceptor " + interceptorName);
            HashMap finalParameters = new HashMap();
            finalParameters.putAll(interceptor.getComponentParameters());
            if (additionalConfiguration.get(interceptorName) != null) {
                finalParameters.putAll((Map)additionalConfiguration.get(interceptorName));
            }
            if (interceptorPhase == Message.InterceptorPhase.ACCEPT) {
                this.logger.fine("Intercepting message on accept InterceptorPhase");
                interceptor.handleMessageAccept(exchange, (Provides)service, finalParameters);
                continue;
            }
            if (interceptorPhase == Message.InterceptorPhase.SEND) {
                this.logger.fine("Intercepting message on send InterceptorPhase");
                interceptor.handleMessageSent(exchange, (Consumes)service, finalParameters);
                continue;
            }
            if (interceptorPhase == Message.InterceptorPhase.ACCEPT_RESPONSE) {
                this.logger.fine("Intercepting message on accept response InterceptorPhase");
                interceptor.handleMessageAcceptResponse(exchange, (Provides)service, finalParameters);
                continue;
            }
            if (interceptorPhase != Message.InterceptorPhase.SEND_RESPONSE) continue;
            this.logger.fine("Intercepting message on send response InterceptorPhase");
            interceptor.handleMessageSentResponse(exchange, (Consumes)service, finalParameters);
        }
    }
}

