/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.su;

import java.util.List;
import javax.jbi.management.DeploymentException;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.bc.AbstractBindingComponent;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.process.ExternalListenerManager;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;

public class BindingComponentServiceUnitManager
extends AbstractServiceUnitManager {
    private final ExternalListenerManager externalListenerManager;

    public BindingComponentServiceUnitManager(AbstractBindingComponent bindingComponent) {
        super(bindingComponent);
        this.externalListenerManager = new ExternalListenerManager(this.component);
    }

    @Override
    public void init(String serviceUnitName, String suRootPath) throws DeploymentException {
        super.init(serviceUnitName, suRootPath);
        try {
            this.externalListenerManager.createListeners(serviceUnitName, this.getConsumesForSU(serviceUnitName));
        }
        catch (PEtALSCDKException e) {
            String msg = "Failed to initialize SU : " + serviceUnitName;
            this.logger.severe(msg);
            throw new DeploymentException(msg, (Throwable)e);
        }
    }

    @Override
    public void start(String serviceUnitName) throws DeploymentException {
        super.start(serviceUnitName);
        try {
            this.externalListenerManager.startListening(serviceUnitName);
        }
        catch (PEtALSCDKException e) {
            String msg = "Failed to start SU : " + serviceUnitName;
            this.logger.severe(msg);
            throw new DeploymentException(msg, (Throwable)e);
        }
    }

    @Override
    public void stop(String serviceUnitName) throws DeploymentException {
        try {
            this.externalListenerManager.stopListening(serviceUnitName);
        }
        catch (PEtALSCDKException e) {
            String msg = "Failed to stop SU : " + serviceUnitName;
            this.logger.severe(msg);
            throw new DeploymentException(msg, (Throwable)e);
        }
        super.stop(serviceUnitName);
    }

    @Override
    public String undeploy(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        this.externalListenerManager.removeListeners(serviceUnitName);
        return super.undeploy(serviceUnitName, serviceUnitRootPath);
    }

    private List<Consumes> getConsumesForSU(String serviceUnitName) throws DeploymentException {
        ServiceUnitDataHandler handler = this.getServiceUnitDataHandlers().get(serviceUnitName);
        if (handler != null) {
            return handler.getDescriptor().getServices().getConsumes();
        }
        throw new DeploymentException("No data handler for su : " + serviceUnitName + ". SU not deployed.");
    }
}

