/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.engine.orchestra.util;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import org.ow2.orchestra.wsdl.WsdlsInfos;
import org.ow2.petals.engine.orchestra.OrchestraEngineException;

public class WSDLAnalyzer {
    public static final String PARAM_RPC = "rpc";
    public static final String PARAM_DOCUMENT = "document";
    public static final String NAMESPACE_URI = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static final QName SOAP_BINDING = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "binding");
    private static final QName SOAP_BODY = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "body");
    private final WsdlsInfos wsdl;

    public WSDLAnalyzer(WsdlsInfos wsdl) {
        this.wsdl = wsdl;
    }

    public final List<Service> findServices(QName portTypeQName) {
        return this.wsdl.getServicesOfPortType(portTypeQName);
    }

    public final Service findFirstCorrespondingService(QName portTypeQName) {
        Service service = null;
        List<Service> servicesList = this.findServices(portTypeQName);
        if (servicesList != null && servicesList.size() > 0) {
            service = servicesList.get(0);
        }
        return service;
    }

    public final List<Binding> getBindings(Service service, QName portTypeQName) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        if (service != null) {
            Collection ports = service.getPorts().values();
            for (Port port : ports) {
                Binding binding = port.getBinding();
                PortType portType = binding.getPortType();
                if (!portType.getQName().equals(portTypeQName)) continue;
                bindings.add(binding);
            }
        }
        return bindings;
    }

    public final List<Binding> getSOAPBindings(Service service, QName portTypeQName) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (Binding binding : this.getBindings(service, portTypeQName)) {
            for (Object elem : binding.getExtensibilityElements()) {
                QName elementQName = ((ExtensibilityElement)elem).getElementType();
                if (!elementQName.equals(SOAP_BINDING)) continue;
                bindings.add(binding);
            }
        }
        return bindings;
    }

    public final Binding getFirstSOAPBindings(Service service, QName portTypeQName) {
        Binding binding = null;
        List<Binding> bindingsList = this.getSOAPBindings(service, portTypeQName);
        if (bindingsList != null && bindingsList.size() > 0) {
            binding = bindingsList.get(0);
        }
        return binding;
    }

    private Binding getFirstBinding(QName portTypeQName) {
        Service service = this.findFirstCorrespondingService(portTypeQName);
        Binding binding = null;
        if (service != null) {
            binding = this.getFirstSOAPBindings(service, portTypeQName);
        }
        return binding;
    }

    public final String getUseForOperation(QName portTypeQName, String operationName) throws OrchestraEngineException {
        String use = null;
        Binding binding = this.getFirstBinding(portTypeQName);
        BindingOperation opBinding = binding.getBindingOperation(operationName, null, null);
        for (Object elem : opBinding.getBindingInput().getExtensibilityElements()) {
            QName elementQName = ((ExtensibilityElement)elem).getElementType();
            if (!elementQName.equals(SOAP_BODY)) continue;
            SOAPBody soapBody = (SOAPBody)elem;
            use = soapBody.getUse();
            break;
        }
        return use;
    }

    public static ArrayList<URL> getExternalWsdlUrls(String directoryName, URL mainWsdlName) throws MalformedURLException {
        File path = new File(directoryName);
        FileFilter wsdlFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".wsdl");
            }
        };
        ArrayList<URL> wsdls = new ArrayList<URL>();
        for (File file : path.listFiles(wsdlFileFilter)) {
            if (file.toURI().toURL().equals(mainWsdlName)) continue;
            wsdls.add(file.toURI().toURL());
        }
        return wsdls;
    }

    public static URL getResourceAsURL(String rootPath, String resourceName) throws MalformedURLException {
        try {
            return new URL(resourceName);
        }
        catch (MalformedURLException e) {
            return new File(rootPath + "/" + resourceName).toURI().toURL();
        }
    }
}

