/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.xml;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.Canonicalizer;

public final class XMLComparator {
    public static String getXMLSHA1Sign(InputStream inputStream, boolean ommitComments) throws Exception {
        Init.init();
        Canonicalizer canonicalizer = null;
        canonicalizer = ommitComments ? Canonicalizer.getInstance("http://www.w3.org/2006/12/xml-c14n11") : Canonicalizer.getInstance("http://www.w3.org/2006/12/xml-c14n11#WithComments");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLPrettyPrinter.prettify(inputStream, (OutputStream)byteArrayOutputStream);
        byte[] bytes = byteArrayOutputStream.toByteArray();
        byte[] canonBytes = canonicalizer.canonicalize(bytes);
        MessageDigest hash = MessageDigest.getInstance("SHA1");
        String hashString = new String(hash.digest(canonBytes));
        return hashString;
    }

    public static int compare(InputStream xml1, InputStream xml2) throws Exception {
        String hash1 = XMLComparator.getXMLSHA1Sign(xml1, true);
        String hash2 = XMLComparator.getXMLSHA1Sign(xml2, true);
        return hash1.compareTo(hash2);
    }
}

