/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.commons.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;

public class InputStreamForker {
    private InputStream originalInputStream;
    private final ForkedInputStream is1;
    private final ForkedInputStream is2;
    protected boolean originalInputStreamClosed = false;

    public InputStreamForker(InputStream originalInputStream) {
        if (originalInputStream == null) {
            throw new IllegalArgumentException("The original input stream is 'null'");
        }
        this.originalInputStream = originalInputStream;
        this.is1 = new ForkedInputStream();
        this.is2 = new ForkedInputStream();
        this.is1.setOtherForkedInputStream(this.is2);
        this.is2.setOtherForkedInputStream(this.is1);
    }

    public InputStream getInputStreamOne() {
        return this.is1;
    }

    public InputStream getInputStreamTwo() {
        return this.is2;
    }

    protected class ForkedInputStream
    extends InputStream {
        private final LinkedList<byte[]> bufferList = new LinkedList();
        private boolean isClosed = false;
        private ForkedInputStream otherForkedInputStream;
        private LinkedList<byte[]> otherBufferList;

        public void setOtherForkedInputStream(ForkedInputStream otherForkedInputStream) {
            this.otherForkedInputStream = otherForkedInputStream;
            this.otherBufferList = this.otherForkedInputStream.getBufferList();
        }

        public LinkedList<byte[]> getBufferList() {
            return this.bufferList;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            InputStreamForker inputStreamForker = InputStreamForker.this;
            synchronized (inputStreamForker) {
                int available = 0;
                Iterator iterator = this.bufferList.iterator();
                while (iterator.hasNext()) {
                    available += ((byte[])iterator.next()).length;
                }
                if (!InputStreamForker.this.originalInputStreamClosed && !this.isClosed) {
                    available += InputStreamForker.this.originalInputStream.available();
                }
                return available;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (!this.isClosed) {
                InputStreamForker inputStreamForker = InputStreamForker.this;
                synchronized (inputStreamForker) {
                    this.isClosed = true;
                    if (this.otherForkedInputStream.isClosed) {
                        InputStreamForker.this.originalInputStream.close();
                        InputStreamForker.this.originalInputStreamClosed = true;
                    }
                }
            }
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read() throws IOException {
            byte[] buffer = new byte[1];
            int nbByteRead = this.read(buffer);
            if (nbByteRead != 1) {
                throw new IOException("No byte read.");
            }
            return buffer[0];
        }

        @Override
        public int read(byte[] cbuf) throws IOException {
            return this.read(cbuf, 0, cbuf.length);
        }

        @Override
        public int read(byte[] cbuf, int off, int len) throws IOException {
            return this.localRead(cbuf, off, len, false);
        }

        @Override
        public long skip(long n) throws IOException, IllegalArgumentException {
            if (n > Long.MAX_VALUE) {
                throw new IllegalArgumentException("Only value lesser 2147483647are accepted.");
            }
            return this.localRead(null, 0, (int)n, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int localRead(byte[] cbuf, int off, int len, boolean skip) throws IOException {
            int remainingLen = len;
            int offset = off;
            InputStreamForker inputStreamForker = InputStreamForker.this;
            synchronized (inputStreamForker) {
                byte[] buffer;
                for (int nbBuffers = this.bufferList.size(); nbBuffers > 0 && remainingLen != 0; --nbBuffers) {
                    buffer = this.bufferList.getFirst();
                    if (remainingLen >= buffer.length) {
                        if (!skip) {
                            System.arraycopy(buffer, 0, cbuf, offset, buffer.length);
                        }
                        this.bufferList.removeFirst();
                        if ((remainingLen -= buffer.length) == 0) {
                            return len;
                        }
                        offset += buffer.length;
                        continue;
                    }
                    if (!skip) {
                        System.arraycopy(buffer, 0, cbuf, offset, remainingLen);
                    }
                    byte[] newBuffer = new byte[buffer.length - remainingLen];
                    System.arraycopy(buffer, remainingLen, newBuffer, 0, buffer.length - remainingLen);
                    this.bufferList.removeFirst();
                    this.bufferList.addFirst(newBuffer);
                    return len;
                }
                if (InputStreamForker.this.originalInputStreamClosed) {
                    throw new IOException("The original InputStream has been closed; cannot read from a closed InputStream.");
                }
                buffer = new byte[remainingLen];
                int byteRead = InputStreamForker.this.originalInputStream.read(buffer, 0, remainingLen);
                if (byteRead != -1) {
                    if (!this.otherForkedInputStream.isClosed()) {
                        if (byteRead == remainingLen) {
                            this.otherBufferList.addLast(buffer);
                        } else {
                            byte[] newBuffer = new byte[byteRead];
                            System.arraycopy(buffer, 0, newBuffer, 0, byteRead);
                            this.otherBufferList.addLast(newBuffer);
                        }
                    }
                    if (!skip) {
                        System.arraycopy(buffer, 0, cbuf, offset, remainingLen);
                    }
                    return len - remainingLen + byteRead;
                }
                if (len == remainingLen) {
                    return -1;
                }
                return len - remainingLen;
            }
        }
    }
}

