/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.commons.threadlocal;

import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;

public final class Transformers {
    private static final ThreadLocal<Transformer> defaultTransformerThreadLocal = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                return TransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException("Failed to create Transformer", e);
            }
        }
    };
    private static final ThreadLocal<Transformer> jvmTransformerThreadLocal = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
                Thread.currentThread().setContextClassLoader(systemClassLoader);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                return transformer;
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException("Failed to create Transformer", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    };
    private static final ThreadLocal<Transformer> xmlWithDeclarationTransformerThreadLocal = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                Properties props = new Properties();
                props.put("omit-xml-declaration", "no");
                props.put("method", "xml");
                transformer.setOutputProperties(props);
                return transformer;
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException("Failed to create Transformer", e);
            }
        }
    };
    private static final ThreadLocal<Transformer> xmlWithoutDeclarationTransformerThreadLocal = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                Properties props = new Properties();
                props.put("omit-xml-declaration", "yes");
                props.put("method", "xml");
                transformer.setOutputProperties(props);
                return transformer;
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException("Failed to create Transformer", e);
            }
        }
    };
    private static final ThreadLocal<Transformer> withoutDeclarationTransformerThreadLocal = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                Properties props = new Properties();
                props.put("omit-xml-declaration", "yes");
                transformer.setOutputProperties(props);
                return transformer;
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException("Failed to create Transformer", e);
            }
        }
    };

    public static final Transformer getDefaultTransformer() {
        return defaultTransformerThreadLocal.get();
    }

    public static final Transformer getXmlWithDeclarationTransformer() {
        return xmlWithDeclarationTransformerThreadLocal.get();
    }

    public static final Transformer getXmlWithoutDeclarationTransformer() {
        return xmlWithoutDeclarationTransformerThreadLocal.get();
    }

    public static final Transformer getWithoutDeclarationTransformer() {
        return withoutDeclarationTransformerThreadLocal.get();
    }
}

