/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.impl.wsdl11;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.wsdl.api.Input;
import org.ow2.easywsdl.wsdl.api.Part;
import org.ow2.easywsdl.wsdl.api.WSDLElement;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractInterfaceTypeImpl;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractOperationImpl;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractParamImpl;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl11.DescriptionImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl11.DocumentationImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl11.MessageImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl11.OperationImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl11.PartImpl;
import org.ow2.easywsdl.wsdl.org.xmlsoap.schemas.wsdl.TDefinitions;
import org.ow2.easywsdl.wsdl.org.xmlsoap.schemas.wsdl.TMessage;
import org.ow2.easywsdl.wsdl.org.xmlsoap.schemas.wsdl.TParam;
import org.ow2.easywsdl.wsdl.org.xmlsoap.schemas.wsdl.TPart;

public class InputImpl
extends AbstractParamImpl<TParam>
implements Input {
    private static final long serialVersionUID = 1L;
    private TMessage correspondingMessage = null;
    private List<Part> parts = new ArrayList<Part>();

    public InputImpl(TParam param, OperationImpl operationImpl) {
        super(param, operationImpl);
        this.operation = operationImpl;
        this.documentation = new DocumentationImpl(((TParam)this.model).getDocumentation(), (AbstractWSDLElementImpl)this);
        this.findCorrespondingMessage();
    }

    private void findCorrespondingMessage() {
        DescriptionImpl desc = (DescriptionImpl)((AbstractInterfaceTypeImpl)((AbstractOperationImpl)this.operation).getInterface()).getDescription();
        for (MessageImpl msg : desc.getMessages()) {
            if (this.getMessageName() == null || !msg.getQName().getLocalPart().equals(this.getMessageName().getLocalPart())) continue;
            this.correspondingMessage = (TMessage)msg.getModel();
        }
        if (this.correspondingMessage != null) {
            this.parts = new ArrayList<Part>();
            for (TPart part : this.correspondingMessage.getPart()) {
                this.parts.add(new PartImpl(part, (WSDLElement)this));
            }
        }
    }

    @Override
    public QName getMessageName() {
        return ((TParam)this.model).getMessage();
    }

    @Override
    public void setMessageName(QName name) {
        ((TParam)this.model).setMessage(name);
        DescriptionImpl desc = (DescriptionImpl)((AbstractInterfaceTypeImpl)((AbstractOperationImpl)this.operation).getInterface()).getDescription();
        if (this.correspondingMessage == null) {
            this.findCorrespondingMessage();
        }
        if (this.correspondingMessage == null) {
            this.correspondingMessage = new TMessage();
            this.correspondingMessage.setName(name.getLocalPart());
            MessageImpl mess = new MessageImpl(this.correspondingMessage, desc);
            desc.getMessages().add(mess);
            ((TDefinitions)desc.getModel()).getAnyTopLevelOptionalElement().add(this.correspondingMessage);
        }
    }

    @Override
    public Element getElement() {
        Element res = null;
        if (this.correspondingMessage == null) {
            this.findCorrespondingMessage();
        }
        if (this.parts.size() == 1) {
            res = this.parts.get(0).getElement();
        }
        return res;
    }

    @Override
    public List<Part> getParts() {
        if (this.correspondingMessage == null) {
            this.findCorrespondingMessage();
        }
        return this.parts;
    }

    @Override
    public void setElement(Element element) throws WSDLException {
        if (this.correspondingMessage == null) {
            this.findCorrespondingMessage();
        }
        if (this.correspondingMessage == null) {
            throw new WSDLException("No message is associated to this input");
        }
        this.elementName = element.getQName();
        if (this.correspondingMessage.getPart().size() == 0) {
            TPart part = new TPart();
            part.setName(element.getQName().getLocalPart());
            part.setElement(element.getQName());
            this.parts.add(new PartImpl(part, (WSDLElement)this));
            this.correspondingMessage.getPart().add(part);
        } else {
            TPart part = this.correspondingMessage.getPart().get(0);
            part.setName(element.getQName().getLocalPart());
            part.setElement(element.getQName());
        }
    }

    @Override
    public String getName() {
        return ((TParam)this.model).getName();
    }

    @Override
    public void setName(String name) {
        ((TParam)this.model).setName(name);
    }

    @Override
    public Part getPart(String name) {
        Part res = null;
        if (this.correspondingMessage == null) {
            this.findCorrespondingMessage();
        }
        if (this.parts != null) {
            for (Part p : this.parts) {
                if (!p.getPartQName().getLocalPart().equals(name)) continue;
                res = p;
                break;
            }
        }
        return res;
    }
}

