/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.definition.element.Else;
import org.ow2.orchestra.definition.element.Elseif;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.pvm.Execution;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.model.Node;
import org.ow2.orchestra.runtime.BpelExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class If
extends AbstractBpelActivity {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(If.class.getName());
    protected Expression condition;
    protected NodeImpl activity;
    protected List<Elseif> elseifs;
    protected Else elseField;

    @Override
    public void executeActivity(BpelExecution execution) {
        boolean ifResult = this.condition.getEvaluator().evaluateBoolean(execution);
        if (ifResult) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("if condition : " + this.condition + " evaluated to true");
            }
            execution.createExecution().execute((Node)this.activity);
        } else {
            for (Elseif elseif : this.elseifs) {
                boolean elseifResult = elseif.getCondition().getEvaluator().evaluateBoolean(execution);
                if (!elseifResult) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("elseif condition : " + elseif.getCondition() + " evaluated to true");
                }
                execution.createExecution().execute((Node)elseif.getActivity());
                return;
            }
            if (this.elseField != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Executing else...");
                }
                execution.createExecution().execute((Node)this.elseField.getActivity());
            }
        }
    }

    @Override
    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        if (signal == null) {
            execution.end("ended");
            BpelExecution ifExecution = execution.getParent();
            ifExecution.removeExecution((Execution)execution);
            ifExecution.signal("finished");
        } else if (signal.equals("finished")) {
            this.afterRunned(execution);
        }
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public List<Elseif> getElseifs() {
        return this.elseifs;
    }

    public void setElseifs(List<Elseif> elseifs) {
        this.elseifs = elseifs;
    }

    public Else getElse() {
        return this.elseField;
    }

    public void setElse(Else else1) {
        this.elseField = else1;
    }

    public NodeImpl getActivity() {
        return this.activity;
    }

    public void setActivity(NodeImpl activity) {
        this.activity = activity;
    }

    @Override
    public ActivityType getType() {
        return ActivityType.IF;
    }
}

