/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.Scope;
import org.ow2.orchestra.facade.data.def.ProcessActivityDefinitionData;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.pvm.internal.model.ObservableElementImpl;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.MessageCarrierRepository;
import org.ow2.orchestra.services.ReplierKey;
import org.ow2.orchestra.services.handlers.FinishedInstanceHandler;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Process
extends Scope {
    private static final Logger LOG = Logger.getLogger(Process.class.getName());

    @Override
    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        if (signal == null) {
            super.signal(execution, null, parameters);
            return;
        }
        this.afterRunned(execution);
        if (execution.isActive()) {
            ObservableElementImpl parent = execution.getNode().getParent();
            if (parent == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("End of bpel process execution");
                }
                if (execution.getParent() != null) {
                    throw new IllegalStateException("Child execution reaches the end of process !");
                }
                if (execution.getWaitingExecutions() != null && !execution.getWaitingExecutions().isEmpty()) {
                    throw new IllegalStateException("Execution reaches the end of process, but child executions are still waiting for a trigger !");
                }
                execution.end();
            }
            Process.endProcessInstance(execution);
        }
    }

    public static void endProcessInstance(BpelExecution execution) {
        for (ReplierKey replierKey : execution.getRepliers().keySet()) {
            MessageCarrierRepository.throwMissingReply(replierKey);
        }
        FinishedInstanceHandler handler = EnvTool.get(FinishedInstanceHandler.class, "finished-instance-handler");
        handler.handleFinishedInstance(execution.getProcessInstanceData());
    }

    public ProcessActivityDefinitionData createDefinitionData(BpelProcess bpelProcess) {
        return new ProcessActivityDefinitionData(bpelProcess.getProcessDefinitionData(), this.uuid, null, this.name, null);
    }

    @Override
    public void beforeRunning(BpelExecution bpelExecution) {
        ProcessInstanceUUID activityInstanceUUID = bpelExecution.getProcessInstanceUUID();
        bpelExecution.setStartedDate(new Date());
        bpelExecution.setActivityInstanceUUID((ActivityInstanceUUID)activityInstanceUUID);
        bpelExecution.setProcessInstanceState(ActivityState.RUNNING);
        EnvTool.getRecorder().recordInstanceStarted(bpelExecution.getProcessInstanceData());
    }

    @Override
    public void afterRunned(BpelExecution bpelExecution) {
        bpelExecution.setProcessInstanceState(ActivityState.FINISHED);
        EnvTool.getRecorder().recordInstanceEnded(bpelExecution.getProcessInstanceData());
    }
}

