/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.AbstractActivity;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.definition.activity.EventHandlerActivity;
import org.ow2.orchestra.definition.element.CorrelationSet;
import org.ow2.orchestra.definition.element.PartnerLink;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.facade.data.def.ScopeActivityDefinitionData;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.ScopeState;
import org.ow2.orchestra.parsing.binding.exception.CorrelationSetNotFoundException;
import org.ow2.orchestra.pvm.Execution;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.model.Node;
import org.ow2.orchestra.pvm.model.OpenExecution;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.runtime.VariableRuntime;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.var.MessageVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scope
extends AbstractBpelActivity {
    private static final long serialVersionUID = -1892215735882878127L;
    public static final int MAIN_ACTIVITY = 0;
    public static final int EVENT_ACTIVITY = 1;
    public static final int TERMINATION_ACTIVITY = 2;
    public static final int COMPENSATION_ACTIVITY = 3;
    public static final int CATCHALL_ACTIVITY = 4;
    public static final int BIGGEST_ACTIVITY_INDEX = 5;
    public static final String SCOPE_FINISHED_SIGNAL = "scope-finished";
    protected List<String> listOfVariableToBeInitialized;
    protected boolean isolated = false;
    protected boolean exitOnStandardFault;
    protected Map<String, Variable> variables;
    protected Map<String, PartnerLink> partnerLinks;
    protected Set<String> messageExchanges;
    protected Map<String, CorrelationSet> correlationSets;
    protected NodeImpl scopeNode;

    @Override
    public void executeActivity(BpelExecution execution) {
        Map additionalVariables;
        ScopeRuntime sr = new ScopeRuntime(this, execution, UUID.randomUUID().toString());
        execution.pushScopeRuntime(sr);
        if (this.listOfVariableToBeInitialized != null) {
            for (String variableName : this.listOfVariableToBeInitialized) {
                execution.getVariableByName(variableName).initializeXmlType(execution);
            }
        }
        if ((additionalVariables = (Map)execution.getVariable("additionnalScopeVariables")) != null) {
            for (Map.Entry var : additionalVariables.entrySet()) {
                VariableRuntime varRun = execution.getVariableByName((String)var.getKey());
                if (var.getValue() instanceof MessageVariable) {
                    varRun.setValue((MessageVariable)var.getValue());
                } else {
                    varRun.setValue(var.getValue(), false);
                }
                varRun.updated(execution.getActivityInstanceUUID());
            }
            execution.removeVariable("additionnalScopeVariables");
        }
        this.executeEventHandlers(execution);
        sr.setState(ScopeState.RUNNING);
        this.executeMainActivity(execution);
    }

    protected void executeEventHandlers(BpelExecution execution) {
        List nodes = execution.getNode().getNodes();
        execution.createExecution().execute((Node)nodes.get(1));
    }

    public void executeMainActivity(BpelExecution execution) {
        List nodes = execution.getNode().getNodes();
        Node mainActivityNode = (Node)nodes.get(0);
        execution.createExecution().execute(mainActivityNode);
    }

    @Override
    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        if (signal == null) {
            execution.end("ended");
            BpelExecution scopeExecution = execution.getParent();
            scopeExecution.removeExecution((Execution)execution);
            if (scopeExecution.isActive()) {
                scopeExecution.signal("finished");
            } else if (scopeExecution.getExecutions() != null) {
                for (OpenExecution scopeChildExecution : new ArrayList(scopeExecution.getExecutions())) {
                    if (!scopeChildExecution.getNode().equals(this.scopeNode.getNodes().get(1))) continue;
                    if (scopeChildExecution.getExecutions().isEmpty()) {
                        ((BpelExecution)scopeChildExecution).signal(SCOPE_FINISHED_SIGNAL);
                        continue;
                    }
                    EventHandlerActivity eventHandlerActivity = (EventHandlerActivity)((NodeImpl)scopeChildExecution.getNode()).getBehaviour();
                    eventHandlerActivity.cancelEvents((BpelExecution)scopeChildExecution);
                }
            }
        } else if (signal.equals("finished")) {
            ScopeRuntime scopeRuntime = execution.popScopeRuntime(true);
            switch (scopeRuntime.getState()) {
                case RUNNING: {
                    scopeRuntime.setState(ScopeState.COMPLETED_SUCCESSFUL);
                    break;
                }
                case TERMINATING: 
                case HANDLING_FAULT: {
                    scopeRuntime.setState(ScopeState.COMPLETED_UNSUCCESSFUL);
                    break;
                }
                case COMPLETED_SUCCESSFUL: 
                case COMPLETED_UNSUCCESSFUL: {
                    break;
                }
                default: {
                    Misc.unreachableStatement((String)("Unexpected scope state: " + scopeRuntime.getState()));
                }
            }
            AbstractActivity parentActivity = (AbstractActivity)execution.getNode().getParentNode().getBehaviour();
            if (parentActivity.getType().equals((Object)ActivityType.FOR_EACH)) {
                execution.createVariable("scopeState", scopeRuntime.getState());
            }
            this.afterRunned(execution);
        }
    }

    public CorrelationSet findCorrelationSet(String correlationSetName) throws CorrelationSetNotFoundException {
        if (this.correlationSets != null && this.correlationSets.containsKey(correlationSetName)) {
            return this.correlationSets.get(correlationSetName);
        }
        if (this.enclosingScope != null) {
            return this.enclosingScope.findCorrelationSet(correlationSetName);
        }
        throw new CorrelationSetNotFoundException("correlation " + correlationSetName + " declaration not found");
    }

    public PartnerLink findPartnerLink(String partnerLinkName) {
        if (this.partnerLinks != null && this.partnerLinks.containsKey(partnerLinkName)) {
            return this.partnerLinks.get(partnerLinkName);
        }
        if (this.enclosingScope != null) {
            return this.enclosingScope.findPartnerLink(partnerLinkName);
        }
        return null;
    }

    public Variable findVariable(String variableName) {
        if (this.variables != null && this.variables.containsKey(variableName)) {
            return this.variables.get(variableName);
        }
        if (this.enclosingScope != null) {
            return this.enclosingScope.findVariable(variableName);
        }
        return null;
    }

    public void addVariableToBeInitialized(String variableName) {
        if (this.listOfVariableToBeInitialized == null) {
            this.listOfVariableToBeInitialized = new ArrayList<String>();
        }
        this.listOfVariableToBeInitialized.add(variableName);
    }

    public Variable getVariable(String variableName) {
        return this.variables.get(variableName);
    }

    public Map<String, PartnerLink> getPartnerLinks() {
        return this.partnerLinks;
    }

    public Map<String, Variable> getVariables() {
        return this.variables;
    }

    public boolean isExitOnStandardFault() {
        return this.exitOnStandardFault;
    }

    public void setExitOnStandardFault(boolean exitOnStandardFault) {
        this.exitOnStandardFault = exitOnStandardFault;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public void setIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    public void setPartnerLinks(Map<String, PartnerLink> partnerLinks) {
        this.partnerLinks = partnerLinks;
    }

    public void setVariables(Map<String, Variable> variables) {
        this.variables = variables;
    }

    public Set<String> getMessageExchanges() {
        return this.messageExchanges;
    }

    public void setMessageExchanges(Set<String> messageExchanges) {
        this.messageExchanges = messageExchanges;
    }

    public Map<String, CorrelationSet> getCorrelationSets() {
        return this.correlationSets;
    }

    public void setCorrelationSets(Map<String, CorrelationSet> correlationSets) {
        this.correlationSets = correlationSets;
    }

    public NodeImpl getScopeNode() {
        return this.scopeNode;
    }

    public void setScopeNode(NodeImpl scopeNode) {
        this.scopeNode = scopeNode;
    }

    public String toString() {
        return Scope.class.getName() + "[listOfVariableToBeInitialized: " + this.listOfVariableToBeInitialized + ", isolated: " + this.isolated + ", exitOnStandardFault: " + this.exitOnStandardFault + ", variables: " + this.variables + ", partnerLinks: " + this.partnerLinks + ", messageExchanges: " + this.messageExchanges + ", correlationSets: " + this.correlationSets + "]";
    }

    @Override
    public ActivityType getType() {
        return ActivityType.SCOPE;
    }

    public ScopeActivityDefinitionData createDefinitionData(BpelProcess bpelProcess) {
        return new ScopeActivityDefinitionData(bpelProcess.getProcessDefinitionData(), this.uuid, null, this.name, null);
    }
}

