/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.element;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.element.FromTo;
import org.ow2.orchestra.facade.def.Variant;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.PartnerLinkRuntime;
import org.ow2.orchestra.runtime.VariableRuntime;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class To
extends FromTo {
    private static Logger log = Logger.getLogger(To.class.getName());

    public void setValue(BpelExecution execution, Object value, boolean keepSrcElementName) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Setting to value of " + this.toString());
        }
        if (value instanceof MessageVariable) {
            String toMessageVariableName = null;
            if (this.variant == Variant.VAR) {
                toMessageVariableName = this.variable;
            } else if (this.variant == Variant.EXPR) {
                throw new OrchestraRuntimeException("Unsupported from message to Expression");
            }
            VariableRuntime var = execution.getVariableByName(toMessageVariableName);
            MessageVariable fromMessage = (MessageVariable)value;
            var.setValue(fromMessage.duplicate());
            var.updated(execution.getActivityInstanceUUID());
            return;
        }
        if (this.variant == Variant.EXPR) {
            String variableName = this.expression.getEvaluator().assign(execution, value, keepSrcElementName);
            if (variableName != null) {
                VariableRuntime var = execution.getVariableByName(variableName);
                var.updated(execution.getActivityInstanceUUID());
            }
        } else if (this.variant == Variant.VAR) {
            VariableRuntime var = execution.getVariableByName(this.variable);
            if (this.part == null) {
                if (this.variableQuery == null) {
                    var.setValue(value, keepSrcElementName);
                } else {
                    Element contextNode = (Element)var.getValue();
                    this.variableQuery.getEvaluator().assign(contextNode, execution, value, keepSrcElementName);
                }
            } else if (this.variableQuery == null) {
                MessageVariable mess = (MessageVariable)var.getValue();
                mess.setPart(this.part, value, keepSrcElementName);
            } else {
                Element contextNode = ((MessageVariable)var.getValue()).getPartValue(this.part);
                this.variableQuery.getEvaluator().assign(contextNode, execution, value, keepSrcElementName);
            }
            var.updated(execution.getActivityInstanceUUID());
        } else if (this.variant == Variant.PROP) {
            Element contextNode = this.getContextNode(execution);
            this.propertyQuery.getEvaluator().assign(contextNode, value, execution, keepSrcElementName);
            execution.getVariableByName(this.variable).updated(execution.getActivityInstanceUUID());
        } else if (this.variant == Variant.PLNK) {
            PartnerLinkRuntime partnerLinkRuntime = execution.getPartnerLinkRuntime(this.partnerLink);
            if (this.endpointReference != null) {
                if (this.endpointReference.equals("myRole")) {
                    partnerLinkRuntime.setMyRoleEndPointReference((Element)value);
                } else {
                    partnerLinkRuntime.setPartnerRoleEndPointReference((Element)value, execution.getActivityInstanceUUID());
                }
            } else {
                partnerLinkRuntime.setPartnerRoleEndPointReference((Element)value, execution.getActivityInstanceUUID());
            }
        } else {
            throw new OrchestraRuntimeException("Unknow VARIANT TYPE : " + this.variant);
        }
    }

    public String toString() {
        String result = "<to";
        if (this.expressionLanguage != null) {
            result = result + "  expressionLanguage=\"" + this.expressionLanguage + "\"";
        }
        if (this.variable != null) {
            result = result + "  variable=\"" + this.variable + "\"";
        }
        if (this.part != null) {
            result = result + "  part=\"" + this.part + "\"";
        }
        if (this.property != null) {
            result = result + "  property=\"" + this.property + "\"";
        }
        if (this.partnerLink != null) {
            result = result + "  partnerLink=\"" + this.partnerLink + "\"";
        }
        result = result + ">\n";
        if (this.variableQuery != null) {
            result = result + this.variableQuery.toString();
        }
        if (this.expression != null) {
            result = result + this.expression.toString();
        }
        result = result + "</to>\n";
        return result;
    }
}

