/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade.uuid;

import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.util.Misc;

public abstract class IdFactory {
    private IdFactory() {
    }

    public static ProcessInstanceUUID getNewInstanceUUID(ProcessDefinitionUUID processUUID, int instanceCount) {
        ProcessInstanceUUID processInstanceUUID = new ProcessInstanceUUID(processUUID + "$" + instanceCount);
        return processInstanceUUID;
    }

    public static ProcessDefinitionUUID getNewProcessUUID(String targetNamespace, String name, String version) {
        ProcessDefinitionUUID processDefinitionUUID = new ProcessDefinitionUUID(version);
        return processDefinitionUUID;
    }

    public static ActivityInstanceUUID getNewActivityInstanceUUID(ProcessInstanceUUID processInstanceUUID) {
        ActivityInstanceUUID activityUUID = new ActivityInstanceUUID(Misc.getUniqueId((String)(processInstanceUUID + "$")));
        return activityUUID;
    }

    public static ActivityDefinitionUUID getNewActivityDefinitionUUID(ProcessDefinitionUUID processUUID, int activityCount) {
        ActivityDefinitionUUID activityDefinitionUUID = new ActivityDefinitionUUID(processUUID, activityCount, ActivityType.UNKNOWN_ACTIVITY, null);
        return activityDefinitionUUID;
    }
}

