/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import org.ow2.orchestra.env.EnvFactoryRepository;
import org.ow2.orchestra.facade.Deployment;
import org.ow2.orchestra.facade.data.runtime.JobData;
import org.ow2.orchestra.facade.def.ActivityDefinition;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.exception.ActivityInstanceNotFoundException;
import org.ow2.orchestra.facade.exception.ActivityNotFoundException;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.exception.JobNotFoundException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.exception.OrchestraWrapperException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.jmx.commands.DeployCommand;
import org.ow2.orchestra.jmx.commands.ExitInstanceCommand;
import org.ow2.orchestra.jmx.commands.FindActivityInstancesCommand;
import org.ow2.orchestra.jmx.commands.FindJobsWithExceptionCommand;
import org.ow2.orchestra.jmx.commands.FindProcessDefinitionsCommand;
import org.ow2.orchestra.jmx.commands.FindProcessInstancesCommand;
import org.ow2.orchestra.jmx.commands.GetActivityDefinitionCommand;
import org.ow2.orchestra.jmx.commands.GetActivityInstanceCommand;
import org.ow2.orchestra.jmx.commands.GetProcessDefinitionCommand;
import org.ow2.orchestra.jmx.commands.GetProcessInstanceCommand;
import org.ow2.orchestra.jmx.commands.InitializeCommand;
import org.ow2.orchestra.jmx.commands.ResumeInstanceCommand;
import org.ow2.orchestra.jmx.commands.RetryJobCommand;
import org.ow2.orchestra.jmx.commands.SuspendInstanceCommand;
import org.ow2.orchestra.jmx.commands.UndeployCommand;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.util.DeploymentUtil;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteDeployerImpl
implements RemoteDeployerMBean {
    protected CommandService getCommandService() {
        EnvironmentFactory environmentFactory = EnvFactoryRepository.get();
        Misc.badStateIfNull((Object)environmentFactory, (String)"environmentFactory is null.");
        return (CommandService)environmentFactory.get(CommandService.class);
    }

    public <T> T execute(Command<T> command) {
        return (T)this.getCommandService().execute(command);
    }

    public ProcessDefinition deploy(Deployment bpelDeployment) {
        return (ProcessDefinition)this.getCommandService().execute((Command)new DeployCommand(bpelDeployment));
    }

    public boolean undeploy(QName processQName) {
        return (Boolean)this.getCommandService().execute((Command)new UndeployCommand(processQName));
    }

    public boolean undeploy(ProcessDefinitionUUID pduuid) {
        return (Boolean)this.getCommandService().execute((Command)new UndeployCommand(pduuid));
    }

    public List<ProcessDefinition> findProcessDefinitions() {
        return (List)this.getCommandService().execute((Command)new FindProcessDefinitionsCommand());
    }

    public List<ProcessDefinition> findProcessDefinitions(ProcessState state) {
        return (List)this.getCommandService().execute((Command)new FindProcessDefinitionsCommand(state));
    }

    public List<ProcessDefinition> findProcessDefinitions(QName processName, ProcessState state) {
        return (List)this.getCommandService().execute((Command)new FindProcessDefinitionsCommand(state, processName));
    }

    public List<ProcessDefinition> findProcessDefinitions(QName processName) {
        return (List)this.getCommandService().execute((Command)new FindProcessDefinitionsCommand(processName));
    }

    public ProcessDefinition getProcessDefinition(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        try {
            return (ProcessDefinition)this.getCommandService().execute((Command)new GetProcessDefinitionCommand(processUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ProcessNotFoundException) {
                throw (ProcessNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    public ActivityDefinition getActivityDefinition(ActivityDefinitionUUID activityDefUUID) throws ActivityNotFoundException {
        try {
            return (ActivityDefinition)this.getCommandService().execute((Command)new GetActivityDefinitionCommand(activityDefUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ActivityNotFoundException) {
                throw (ActivityNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessDefinition deployBar(byte[] barFile) {
        try {
            ZipEntry zipFile;
            new File(System.getProperty("java.io.tmpdir")).mkdirs();
            File tmpDir = File.createTempFile("orch", null, null);
            tmpDir.delete();
            if (!tmpDir.mkdirs()) {
                throw new IOException("Cannot create the temporary directory '" + tmpDir + "'.");
            }
            ArrayList<URL> wsdlUrls = new ArrayList<URL>();
            URL bpelFile = null;
            ByteArrayInputStream in = new ByteArrayInputStream(barFile);
            ZipInputStream zipInput = new ZipInputStream(in);
            while ((zipFile = zipInput.getNextEntry()) != null) {
                File outFile = new File(tmpDir.getAbsolutePath() + File.separator + zipFile.getName());
                FileOutputStream outputFile = new FileOutputStream(outFile);
                try {
                    int c;
                    while ((c = zipInput.read()) != -1) {
                        outputFile.write(c);
                    }
                }
                finally {
                    outputFile.close();
                }
                if (zipFile.getName().endsWith(".wsdl")) {
                    wsdlUrls.add(outFile.toURI().toURL());
                    continue;
                }
                if (!zipFile.getName().endsWith(".bpel")) continue;
                if (bpelFile != null) {
                    throw new OrchestraRuntimeException("Bar contains more than one bpel file.");
                }
                bpelFile = outFile.toURI().toURL();
            }
            zipInput.close();
            ((InputStream)in).close();
            Deployment deployment = DeploymentUtil.generateDeployment(bpelFile, wsdlUrls);
            ProcessDefinition process = this.deploy(deployment);
            Misc.deleteDir((File)tmpDir);
            return process;
        }
        catch (IOException e) {
            throw new OrchestraRuntimeException("Unable to deploy bar", (Throwable)e);
        }
    }

    public void initialize() {
        this.getCommandService().execute((Command)new InitializeCommand());
    }

    public Set<ActivityInstance> findActivityInstances(ProcessInstanceUUID processUUID) throws InstanceNotFoundException {
        try {
            return (Set)this.getCommandService().execute((Command)new FindActivityInstancesCommand(processUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    public Set<ActivityInstance> findActivityInstances(ProcessInstanceUUID processUUID, ActivityState activityState) throws InstanceNotFoundException {
        try {
            return (Set)this.getCommandService().execute((Command)new FindActivityInstancesCommand(processUUID, activityState));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    public Set<ProcessInstance> findProcessInstances() {
        return (Set)this.getCommandService().execute((Command)new FindProcessInstancesCommand());
    }

    public Set<ProcessInstance> findProcessInstances(ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException {
        try {
            return (Set)this.getCommandService().execute((Command)new FindProcessInstancesCommand(processDefinitionUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ProcessNotFoundException) {
                throw (ProcessNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    public Set<ProcessInstance> findProcessInstances(ProcessDefinitionUUID processDefinitionUUID, ActivityState processInstanceState) throws ProcessNotFoundException {
        try {
            return (Set)this.getCommandService().execute((Command)new FindProcessInstancesCommand(processDefinitionUUID, processInstanceState));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ProcessNotFoundException) {
                throw (ProcessNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    public Set<ProcessInstance> findProcessInstances(ActivityState processInstanceState) {
        return (Set)this.getCommandService().execute((Command)new FindProcessInstancesCommand(processInstanceState));
    }

    public ProcessInstance getProcessInstance(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        try {
            return (ProcessInstance)this.getCommandService().execute((Command)new GetProcessInstanceCommand(processInstanceUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    public ActivityInstance getActivityInstance(ActivityInstanceUUID activityInstanceUUID) throws ActivityInstanceNotFoundException {
        try {
            return (ActivityInstance)this.getCommandService().execute((Command)new GetActivityInstanceCommand(activityInstanceUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ActivityInstanceNotFoundException) {
                throw (ActivityInstanceNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    public void exit(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        InstanceNotFoundException infe = (InstanceNotFoundException)this.getCommandService().execute((Command)new ExitInstanceCommand(processInstanceUUID));
        if (infe != null) {
            throw infe;
        }
    }

    public void resume(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        InstanceNotFoundException infe = (InstanceNotFoundException)this.getCommandService().execute((Command)new ResumeInstanceCommand(processInstanceUUID));
        if (infe != null) {
            throw infe;
        }
    }

    public void suspend(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        InstanceNotFoundException infe = (InstanceNotFoundException)this.getCommandService().execute((Command)new SuspendInstanceCommand(processInstanceUUID));
        if (infe != null) {
            throw infe;
        }
    }

    public List<JobData> findJobsWithException() {
        return (List)this.getCommandService().execute((Command)new FindJobsWithExceptionCommand());
    }

    public void retryJob(JobData jobData, int retries) throws JobNotFoundException {
        if (!((Boolean)this.getCommandService().execute((Command)new RetryJobCommand(retries, jobData))).booleanValue()) {
            throw new JobNotFoundException(jobData);
        }
    }
}

