/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx.commands;

import java.util.HashSet;
import java.util.Set;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.facade.runtime.impl.ProcessInstanceImpl;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FindProcessInstancesCommand
implements Command<Set<ProcessInstance>> {
    final ProcessDefinitionUUID processDefinitionUUID;
    final ActivityState processInstanceState;

    public FindProcessInstancesCommand(ProcessDefinitionUUID processDefinitionUUID, ActivityState processInstanceState) {
        this.processDefinitionUUID = processDefinitionUUID;
        this.processInstanceState = processInstanceState;
    }

    public FindProcessInstancesCommand(ProcessDefinitionUUID processDefinitionUUID) {
        this.processDefinitionUUID = processDefinitionUUID;
        this.processInstanceState = null;
    }

    public FindProcessInstancesCommand(ActivityState processInstanceState) {
        this.processDefinitionUUID = null;
        this.processInstanceState = processInstanceState;
    }

    public FindProcessInstancesCommand() {
        this.processDefinitionUUID = null;
        this.processInstanceState = null;
    }

    public Set<ProcessInstance> execute(Environment environment) {
        HashSet<ProcessInstance> result = new HashSet<ProcessInstance>();
        Querier querier = EnvTool.getQuerier();
        Set<ProcessFullInstance> processFullInstances = this.processDefinitionUUID != null && this.processInstanceState != null ? querier.findProcessInstances(this.processDefinitionUUID, this.processInstanceState) : (this.processDefinitionUUID != null ? querier.findProcessInstances(this.processDefinitionUUID) : (this.processInstanceState != null ? querier.findProcessInstances(this.processInstanceState) : querier.findProcessInstances()));
        for (ProcessFullInstance processFullInstance : processFullInstances) {
            result.add((ProcessInstance)new ProcessInstanceImpl((ProcessInstance)processFullInstance));
        }
        return result;
    }
}

