/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.exception.StaticAnalysisException;
import org.ow2.orchestra.facade.def.full.impl.ProcessFullDefinitionImpl;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.wsdl.WsdlDefinitions;
import org.ow2.orchestra.parsing.binding.AssignBinding;
import org.ow2.orchestra.parsing.binding.CompensateBinding;
import org.ow2.orchestra.parsing.binding.CompensateScopeBinding;
import org.ow2.orchestra.parsing.binding.DefinitionKeeper;
import org.ow2.orchestra.parsing.binding.EmptyBinding;
import org.ow2.orchestra.parsing.binding.ExitBinding;
import org.ow2.orchestra.parsing.binding.ExtensionActivityBinding;
import org.ow2.orchestra.parsing.binding.FlowBinding;
import org.ow2.orchestra.parsing.binding.ForEachBinding;
import org.ow2.orchestra.parsing.binding.IfBinding;
import org.ow2.orchestra.parsing.binding.InvokeBinding;
import org.ow2.orchestra.parsing.binding.PickBinding;
import org.ow2.orchestra.parsing.binding.ProcessBinding;
import org.ow2.orchestra.parsing.binding.ReceiveBinding;
import org.ow2.orchestra.parsing.binding.RepeatUntilBinding;
import org.ow2.orchestra.parsing.binding.ReplyBinding;
import org.ow2.orchestra.parsing.binding.RethrowBinding;
import org.ow2.orchestra.parsing.binding.ScopeBinding;
import org.ow2.orchestra.parsing.binding.SequenceBinding;
import org.ow2.orchestra.parsing.binding.ThrowBinding;
import org.ow2.orchestra.parsing.binding.ValidateBinding;
import org.ow2.orchestra.parsing.binding.WaitBinding;
import org.ow2.orchestra.parsing.binding.WhileBinding;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.util.UrlEntity;
import org.ow2.orchestra.pvm.internal.xml.Binding;
import org.ow2.orchestra.pvm.internal.xml.Bindings;
import org.ow2.orchestra.pvm.internal.xml.Entity;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.runtime.FaultHandlerThatExits;
import org.ow2.orchestra.util.StaticAnalysisFault;
import org.ow2.orchestra.util.StyleSheetRepository;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.wsdl.BpelWsdlParser;
import org.ow2.orchestra.wsdl.WsdlsInfos;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelParser
extends Parser
implements ErrorHandler {
    private static final String RESSOURCES_DIR = "";
    private static final String[] SCHEMA_RESOURCES = new String[]{"wsdl.xsd", "xml-schema.xsd", "ws-bpel_abstract_common_base.xsd", "ws-bpel_executable.xsd"};
    public static final String CATEGORY_ACTIVITY = "activities";
    private static Bindings defaultBindings = BpelParser.getDefaultBindings();
    private static String[] schemaSources = BpelParser.getSchemaSources();
    private static Map<String, Entity> defaultEntities = BpelParser.getDefaultEntities();
    private BpelWsdlParser wsdlParser = null;

    public BpelParser() {
        super(defaultBindings, defaultEntities);
        this.getDocumentBuilderFactory().setNamespaceAware(true);
        this.wsdlParser = new BpelWsdlParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parseDocumentElement(Element processElement, Parse parse) {
        BpelProcess bpelProcess = this.parseProcessAttributes(processElement, parse);
        parse.pushObject((Object)bpelProcess);
        try {
            bpelProcess.setStyleSheetRepository((StyleSheetRepository)parse.findObject(StyleSheetRepository.class));
            bpelProcess.setWsdlInfos((WsdlsInfos)parse.findObject(WsdlsInfos.class));
            FaultHandlerThatExits faultHandlerThatExits = new FaultHandlerThatExits();
            faultHandlerThatExits.setExceptionClassName(BpelFaultException.class.getName());
            bpelProcess.addExceptionHandler(faultHandlerThatExits);
            List elements = XmlUtil.elements((Element)processElement);
            if (elements == null || elements.isEmpty()) {
                parse.addProblem("no elements in process");
                BpelProcess bpelProcess2 = bpelProcess;
                return bpelProcess2;
            }
            this.parseProcessElements(processElement, bpelProcess, parse);
            NodeImpl processScope = (NodeImpl)this.parseElement(processElement, parse, CATEGORY_ACTIVITY);
            bpelProcess.setInitial(processScope);
        }
        finally {
            parse.popObject();
        }
        return bpelProcess;
    }

    private BpelProcess parseProcessAttributes(Element processElement, Parse parse) {
        String name = XmlUtil.attribute((Element)processElement, (String)"name");
        String targetNamespace = XmlUtil.attribute((Element)processElement, (String)"targetNamespace");
        DefinitionKeeper definitionKeeper = (DefinitionKeeper)parse.findObject(DefinitionKeeper.class);
        long version = definitionKeeper.getProcessId();
        BpelProcess bpelProcess = new BpelProcess(name, targetNamespace, version);
        String queryLanguage = XmlUtil.attribute((Element)processElement, (String)"queryLanguage");
        bpelProcess.setQueryLanguage(queryLanguage);
        String expressionLanguage = XmlUtil.attribute((Element)processElement, (String)"expressionLanguage");
        bpelProcess.setExpressionLanguage(expressionLanguage);
        ProcessDefinitionUUID processDefinitionUUID = bpelProcess.getUUID();
        ProcessFullDefinitionImpl processFullDefinition = new ProcessFullDefinitionImpl(processDefinitionUUID, targetNamespace, name, queryLanguage, expressionLanguage, new Date());
        definitionKeeper.setProcessFullDefinition(processFullDefinition);
        return bpelProcess;
    }

    private void parseProcessElements(Element processElement, BpelProcess bpelProcess, Parse parse) {
        List importElements;
        Element extensions = XmlUtil.element((Element)processElement, (String)"extensions");
        if (extensions != null) {
            parse.addProblem("extensions element not yet supported on process");
        }
        if ((importElements = XmlUtil.elements((Element)processElement, (String)"import")) != null) {
            for (Element importElement : importElements) {
                this.parseImportElement(importElement, bpelProcess, parse);
            }
        }
    }

    private void parseImportElement(Element importElement, BpelProcess bpelProcess, Parse parse) {
        String namespace = null;
        if (importElement.hasAttribute("namespace")) {
            namespace = importElement.getAttribute("namespace");
        }
        String importType = null;
        if (importElement.hasAttribute("importType")) {
            importType = importElement.getAttribute("importType");
        }
        if (importType == null) {
            parse.addProblem("missing importType attribute in import element " + XmlUtil.toString((Node)importElement));
        } else if (importType.equals("http://schemas.xmlsoap.org/wsdl/")) {
            WsdlDefinitions wsdlDefinitions = (WsdlDefinitions)parse.findObject(WsdlDefinitions.class);
            Set definitionsForNS = null;
            if (wsdlDefinitions != null) {
                definitionsForNS = wsdlDefinitions.getWsdlDefinitions(namespace);
            }
            if (definitionsForNS == null) {
                parse.addProblem("No wsdl file to import in import element " + XmlUtil.toString((Node)importElement));
            } else {
                for (Definition wsdlDef : definitionsForNS) {
                    if (namespace == null && wsdlDef.getTargetNamespace() != null) {
                        parse.addProblem("invalid namespace in imported wsdl (SA00012) : no target namespace expected, got \"" + wsdlDef.getTargetNamespace() + "\"");
                    } else if (namespace != null && !namespace.equals(wsdlDef.getTargetNamespace())) {
                        parse.addProblem("invalid namespace in imported wsdl (SA00011) : expected \"" + namespace + "\", got \"" + wsdlDef.getTargetNamespace() + "\"");
                    }
                    Map portTypes = wsdlDef.getAllPortTypes();
                    for (PortType pt : portTypes.values()) {
                        List operations = pt.getOperations();
                        for (int index = 0; index < operations.size(); ++index) {
                            Operation op = (Operation)operations.get(index);
                            String name = op.getName();
                            int cmpt = 1;
                            for (int i = index + 1; i < operations.size(); ++i) {
                                if (!((Operation)operations.get(i)).getName().equals(name)) continue;
                                ++cmpt;
                            }
                            if (cmpt <= true) continue;
                            String message = StaticAnalysisFault.getMessage("SA00002", "  PartnerLink " + pt.getQName().toString() + " has " + cmpt + " operations with name " + name);
                            parse.addProblem(message, (Exception)((Object)new StaticAnalysisException("SA00002")));
                        }
                    }
                    this.wsdlParser.parse(wsdlDef, parse, bpelProcess.getQueryLanguage(), bpelProcess, bpelProcess.getWsdlInfos());
                }
            }
        } else {
            parse.addProblem("unsupported importType attribute in import element " + XmlUtil.toString((Node)importElement));
        }
    }

    public synchronized DocumentBuilderFactory getDocumentBuilderFactory() {
        this.documentBuilderFactory = this.newDocumentBuilderFactory();
        this.documentBuilderFactory.setNamespaceAware(true);
        this.documentBuilderFactory.setValidating(true);
        this.documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        this.documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        this.documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaSources);
        return this.documentBuilderFactory;
    }

    public static Bindings getDefaultBindings() {
        Bindings bindings = new Bindings();
        bindings.addBinding((Binding)new ProcessBinding());
        bindings.addBinding((Binding)new SequenceBinding());
        bindings.addBinding((Binding)new ScopeBinding());
        bindings.addBinding((Binding)new ReceiveBinding());
        bindings.addBinding((Binding)new ReplyBinding());
        bindings.addBinding((Binding)new FlowBinding());
        bindings.addBinding((Binding)new EmptyBinding());
        bindings.addBinding((Binding)new AssignBinding());
        bindings.addBinding((Binding)new InvokeBinding());
        bindings.addBinding((Binding)new IfBinding());
        bindings.addBinding((Binding)new CompensateBinding());
        bindings.addBinding((Binding)new CompensateScopeBinding());
        bindings.addBinding((Binding)new ExitBinding());
        bindings.addBinding((Binding)new ForEachBinding());
        bindings.addBinding((Binding)new PickBinding());
        bindings.addBinding((Binding)new RepeatUntilBinding());
        bindings.addBinding((Binding)new ThrowBinding());
        bindings.addBinding((Binding)new RethrowBinding());
        bindings.addBinding((Binding)new ValidateBinding());
        bindings.addBinding((Binding)new WaitBinding());
        bindings.addBinding((Binding)new WhileBinding());
        bindings.addBinding((Binding)new ExtensionActivityBinding());
        return bindings;
    }

    protected static QName getBPELQName(String localName) {
        return new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", localName);
    }

    public static Set<QName> getAllActivityQNames() {
        Set allActivityTagNames = BpelParser.getDefaultBindings().getTagNames(CATEGORY_ACTIVITY);
        HashSet<QName> allActivityQNames = new HashSet<QName>();
        for (String tagName : allActivityTagNames) {
            allActivityQNames.add(BpelParser.getBPELQName(tagName));
        }
        return allActivityQNames;
    }

    private static Map<String, Entity> getDefaultEntities() {
        HashMap<String, Entity> defaultSchemaCatalog = new HashMap<String, Entity>();
        ClassLoader resourceLoader = BpelParser.class.getClassLoader();
        defaultSchemaCatalog.put("http://schemas.xmlsoap.org/wsdl/", (Entity)new UrlEntity("wsdl.xsd", resourceLoader));
        defaultSchemaCatalog.put("http://www.w3.org/2001/XMLSchema", (Entity)new UrlEntity("xml-schema.xsd", resourceLoader));
        defaultSchemaCatalog.put("http://www.w3.org/2001/xml.xsd", (Entity)new UrlEntity("xml-schema.xsd", resourceLoader));
        defaultSchemaCatalog.put("http://docs.oasis-open.org/wsbpel/2.0/process/abstract", (Entity)new UrlEntity("ws-bpel_abstract_common_base.xsd", resourceLoader));
        defaultSchemaCatalog.put("http://docs.oasis-open.org/wsbpel/2.0/process/executable", (Entity)new UrlEntity("ws-bpel_executable.xsd", resourceLoader));
        return defaultSchemaCatalog;
    }

    private static String[] getSchemaSources() {
        String[] schemas = new String[SCHEMA_RESOURCES.length];
        ClassLoader resourceLoader = BpelParser.class.getClassLoader();
        for (int i = 0; i < SCHEMA_RESOURCES.length; ++i) {
            schemas[i] = resourceLoader.getResource(SCHEMA_RESOURCES[i]).toExternalForm();
        }
        return schemas;
    }

    protected void setErrorHandler(DocumentBuilder documentBuilder) {
        documentBuilder.setErrorHandler(this);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void checkProblems(String description, Parse parse) {
        try {
            super.checkProblems(description, parse);
        }
        catch (PvmException e) {
            throw new OrchestraRuntimeException(e.getMessage(), (Throwable)e);
        }
    }
}

