/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing.binding;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.definition.activity.Flow;
import org.ow2.orchestra.definition.activity.Scope;
import org.ow2.orchestra.definition.element.Link;
import org.ow2.orchestra.definition.element.PartnerLink;
import org.ow2.orchestra.definition.element.Source;
import org.ow2.orchestra.definition.element.Target;
import org.ow2.orchestra.exception.StaticAnalysisException;
import org.ow2.orchestra.facade.def.full.BaseFCTFullDefinition;
import org.ow2.orchestra.facade.def.full.BpelActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.BpelActivityWithChildrenFullDefinition;
import org.ow2.orchestra.facade.def.full.BpelActivityWithSingleChildFullDefinition;
import org.ow2.orchestra.facade.def.full.ElseFullDefinition;
import org.ow2.orchestra.facade.def.full.ElseIfFullDefinition;
import org.ow2.orchestra.facade.def.full.OnAlarmFullDefinition;
import org.ow2.orchestra.facade.def.full.OnEventFullDefinition;
import org.ow2.orchestra.facade.def.full.OnMessageFullDefinition;
import org.ow2.orchestra.facade.def.full.impl.SourceFullImpl;
import org.ow2.orchestra.facade.def.full.impl.TargetFullImpl;
import org.ow2.orchestra.facade.def.full.impl.UnknownActivityFullDefinitionImpl;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.lang.JoinCondition;
import org.ow2.orchestra.parsing.BpelParser;
import org.ow2.orchestra.parsing.binding.DefinitionKeeper;
import org.ow2.orchestra.pvm.activity.Activity;
import org.ow2.orchestra.pvm.activity.ExternalActivity;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.util.TagBinding;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.StaticAnalysisFault;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActivityBinding
extends TagBinding {
    private final ActivityType activityType;

    protected ActivityBinding(String tagName, ActivityType activityType) {
        super(tagName, "http://docs.oasis-open.org/wsbpel/2.0/process/executable", "activities");
        this.activityType = activityType;
    }

    public void setEnclosingScope(AbstractBpelActivity activity, Parse parse) {
        Scope enclosingScope = (Scope)parse.findObject(Scope.class);
        if (enclosingScope != null) {
            activity.setEnclosingScope(enclosingScope);
        }
    }

    protected void parseStandardAttributes(Element activityElement, AbstractBpelActivity activity, Parse parse) {
        String name = XmlUtil.attribute((Element)activityElement, (String)"name");
        if (name == null) {
            name = "unnamed";
        }
        activity.setName(name);
        String suppressJoinFailureSt = XmlUtil.attribute((Element)activityElement, (String)"suppressJoinFailure");
        AbstractBpelActivity enclosingActivity = (AbstractBpelActivity)parse.findObject(AbstractBpelActivity.class);
        boolean defaultSuppressJoinFailure = false;
        if (enclosingActivity != null) {
            defaultSuppressJoinFailure = enclosingActivity.isSuppressJoinFailure();
        }
        boolean suppressJoinFailure = BpelUtil.booleanValue(suppressJoinFailureSt, defaultSuppressJoinFailure);
        activity.setSuppressJoinFailure(suppressJoinFailure);
        DefinitionKeeper definitionKeeper = (DefinitionKeeper)parse.findObject(DefinitionKeeper.class);
        ProcessDefinitionUUID processDefinitionUUID = definitionKeeper.getProcessFullDefinition().getUUID();
        Object activityDefinitionUUID = null;
        activityDefinitionUUID = activity.getType().equals((Object)ActivityType.PROCESS) ? processDefinitionUUID : new ActivityDefinitionUUID(processDefinitionUUID, definitionKeeper.getNextActivityCount(), this.activityType, name);
        activity.setUuid((ActivityDefinitionUUID)activityDefinitionUUID);
        BpelActivityFullDefinition activityFullDefinition = this.createActivityFullDefinition(processDefinitionUUID, (ActivityDefinitionUUID)activityDefinitionUUID, name, parse);
        activityFullDefinition.setSuppressJoinFailure(suppressJoinFailure);
        Object parentObject = definitionKeeper.getParent();
        if (parentObject != null) {
            if (parentObject instanceof BpelActivityWithChildrenFullDefinition) {
                BpelActivityWithChildrenFullDefinition activityWithChildrenFullDefinition = (BpelActivityWithChildrenFullDefinition)parentObject;
                activityWithChildrenFullDefinition.addEnclosedActivity(activityFullDefinition);
            } else if (parentObject instanceof BpelActivityWithSingleChildFullDefinition) {
                BpelActivityWithSingleChildFullDefinition activityWithSingleChildFullDefinition = (BpelActivityWithSingleChildFullDefinition)parentObject;
                activityWithSingleChildFullDefinition.setEnclosedActivity(activityFullDefinition);
            } else if (parentObject instanceof ElseIfFullDefinition) {
                ((ElseIfFullDefinition)parentObject).setEnclosedActivityFullDefinition(activityFullDefinition);
                ((ElseIfFullDefinition)parentObject).setActivityDefinitionUUID(activityFullDefinition.getUUID());
            } else if (parentObject instanceof ElseFullDefinition) {
                ((ElseFullDefinition)parentObject).setEnclosedActivityFullDefinition(activityFullDefinition);
                ((ElseFullDefinition)parentObject).setActivityDefinitionUUID(activityFullDefinition.getUUID());
            } else if (parentObject instanceof OnMessageFullDefinition) {
                ((OnMessageFullDefinition)parentObject).setEnclosedActivityFullDefinition(activityFullDefinition);
                ((OnMessageFullDefinition)parentObject).setActivityDefinitionUUID(activityFullDefinition.getUUID());
            } else if (parentObject instanceof OnEventFullDefinition) {
                ((OnEventFullDefinition)parentObject).setEnclosedActivityFullDefinition(activityFullDefinition);
                ((OnEventFullDefinition)parentObject).setActivityDefinitionUUID(activityFullDefinition.getUUID());
            } else if (parentObject instanceof OnAlarmFullDefinition) {
                ((OnAlarmFullDefinition)parentObject).setEnclosedActivityFullDefinition(activityFullDefinition);
                ((OnAlarmFullDefinition)parentObject).setActivityDefinitionUUID(activityFullDefinition.getUUID());
            } else if (parentObject instanceof BaseFCTFullDefinition) {
                ((BaseFCTFullDefinition)parentObject).setEnclosedActivity(activityFullDefinition);
            } else {
                Misc.unreachableStatement((String)("parent has bad type " + parentObject.getClass() + " in activity " + activity.getType()));
            }
        }
        definitionKeeper.setActivityFullDefinition(activityFullDefinition);
    }

    public BpelActivityFullDefinition createActivityFullDefinition(ProcessDefinitionUUID processDefinitionUUID, ActivityDefinitionUUID activityDefinitionUUID, String name, Parse parse) {
        return new UnknownActivityFullDefinitionImpl(processDefinitionUUID, activityDefinitionUUID, name);
    }

    protected void parseStandardElements(Element activityElement, AbstractBpelActivity activity, Parse parse) {
        Element targetsElement;
        Element sourcesElement = XmlUtil.element((Element)activityElement, (String)"sources");
        if (sourcesElement != null) {
            List sourceElements = XmlUtil.elements((Element)sourcesElement, (String)"source");
            this.parseSources(sourceElements, parse, activity);
        }
        if ((targetsElement = XmlUtil.element((Element)activityElement, (String)"targets")) != null) {
            List targetElements = XmlUtil.elements((Element)targetsElement, (String)"target");
            this.parseTargets(targetElements, parse, activity);
            DefinitionKeeper definitionKeeper = (DefinitionKeeper)parse.findObject(DefinitionKeeper.class);
            BpelActivityFullDefinition activityFullDefinition = (BpelActivityFullDefinition)definitionKeeper.getActivityFullDefinition();
            Element targetsJoinConditionElement = XmlUtil.element((Element)targetsElement, (String)"joinCondition");
            String expressionLanguage = null;
            String booleanExpression = null;
            if (targetsJoinConditionElement != null) {
                expressionLanguage = XmlUtil.attribute((Element)targetsJoinConditionElement, (String)"expressionLanguage");
                BpelProcess bpelProcess = (BpelProcess)((Object)parse.findObject(BpelProcess.class));
                if (expressionLanguage == null) {
                    expressionLanguage = bpelProcess.getExpressionLanguage();
                }
                JoinCondition joinCondition = new JoinCondition();
                booleanExpression = targetsJoinConditionElement.getTextContent();
                joinCondition.setText(booleanExpression);
                joinCondition.setLanguage(expressionLanguage);
                joinCondition.setNamespaces(BpelUtil.getAllNameSpaces(targetsJoinConditionElement));
                activity.setTargetsJoinCondition(joinCondition);
            }
            activityFullDefinition.setTargetsJoinConditionExpressionLanguage(expressionLanguage);
            activityFullDefinition.setTargetsJoinConditionBooleanExpression(booleanExpression);
        }
    }

    private void parseSources(List<Element> sourceElements, Parse parse, AbstractBpelActivity activity) {
        ArrayList<Source> sources = new ArrayList<Source>();
        if (sourceElements != null) {
            DefinitionKeeper definitionKeeper = (DefinitionKeeper)parse.findObject(DefinitionKeeper.class);
            BpelActivityFullDefinition activityFullDefinition = (BpelActivityFullDefinition)definitionKeeper.getActivityFullDefinition();
            BpelProcess bpelProcess = (BpelProcess)((Object)parse.findObject(BpelProcess.class));
            for (Element sourceElement : sourceElements) {
                String message;
                String linkName = XmlUtil.attribute((Element)sourceElement, (String)"linkName");
                boolean exist = false;
                for (Source source : sources) {
                    if (!source.getLinkName().equals(linkName)) continue;
                    String message2 = StaticAnalysisFault.getMessage("SA00068", "  Activity " + activity.getName() + " defines 2 sources with same link " + linkName);
                    parse.addProblem(message2, (Exception)((Object)new StaticAnalysisException("SA00068")));
                    exist = true;
                    break;
                }
                if (exist) continue;
                Source source = new Source();
                source.setLinkName(linkName);
                Element transitionConditionElement = XmlUtil.element((Element)sourceElement, (String)"transitionCondition");
                String expressionLanguage = null;
                String booleanExpression = null;
                if (transitionConditionElement != null) {
                    expressionLanguage = XmlUtil.attribute((Element)transitionConditionElement, (String)"expressionLanguage");
                    if (expressionLanguage == null) {
                        expressionLanguage = bpelProcess.getExpressionLanguage();
                    }
                    Expression expression = new Expression();
                    expression.setLanguage(expressionLanguage);
                    expression.setNamespaces(BpelUtil.getAllNameSpaces(transitionConditionElement));
                    booleanExpression = transitionConditionElement.getTextContent();
                    expression.setText(booleanExpression);
                    source.setTransitionCondition(expression);
                }
                sources.add(source);
                Flow flow = (Flow)parse.findObject(Flow.class);
                Link link = flow.getLink(linkName);
                if (link == null) {
                    message = StaticAnalysisFault.getMessage("SA00065", "  Activity " + activity.getName() + " defines source with link " + linkName + " that is not defined in enclosing flow");
                    parse.addProblem(message, (Exception)((Object)new StaticAnalysisException("SA00065")));
                } else if (link.getSourceActivity() == null) {
                    link.setSourceActivity(activity);
                    source.setLink(link);
                } else {
                    message = StaticAnalysisFault.getMessage("SA00066", "  Link " + linkName + " has 2 sources defined");
                    parse.addProblem(message, (Exception)((Object)new StaticAnalysisException("SA00066")));
                }
                activityFullDefinition.addSource(new SourceFullImpl(linkName, expressionLanguage, booleanExpression));
            }
        }
        activity.setSources(sources);
    }

    private void parseTargets(List<Element> targetElements, Parse parse, AbstractBpelActivity activity) {
        ArrayList<Target> targets = new ArrayList<Target>();
        if (targetElements != null) {
            DefinitionKeeper definitionKeeper = (DefinitionKeeper)parse.findObject(DefinitionKeeper.class);
            BpelActivityFullDefinition activityFullDefinition = (BpelActivityFullDefinition)definitionKeeper.getActivityFullDefinition();
            for (Element targetElement : targetElements) {
                String message;
                String linkName = XmlUtil.attribute((Element)targetElement, (String)"linkName");
                boolean exist = false;
                for (Target target : targets) {
                    if (!target.getLinkName().equals(linkName)) continue;
                    String message2 = StaticAnalysisFault.getMessage("SA00069", "  Activity " + activity.getName() + " defines 2 targets with same link " + linkName);
                    parse.addProblem(message2, (Exception)((Object)new StaticAnalysisException("SA00069")));
                    exist = true;
                    break;
                }
                if (exist) continue;
                Target target = new Target();
                target.setLinkName(linkName);
                targets.add(target);
                Flow flow = (Flow)parse.findObject(Flow.class);
                Link link = flow.getLink(linkName);
                if (link == null) {
                    message = StaticAnalysisFault.getMessage("SA00065", "  Activity " + activity.getName() + " defines target with link " + linkName + " that is not defined in enclosing flow");
                    parse.addProblem(message, (Exception)((Object)new StaticAnalysisException("SA00065")));
                } else if (link.getTargetActivity() == null) {
                    link.setTargetActivity(activity);
                    target.setLink(link);
                } else {
                    message = StaticAnalysisFault.getMessage("SA00066", "  Link " + linkName + " has 2 targets defined");
                    parse.addProblem(message, (Exception)((Object)new StaticAnalysisException("SA00066")));
                }
                activityFullDefinition.addTarget(new TargetFullImpl(linkName));
            }
        }
        activity.setTargets(targets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseChildrenActivities(Element activityElement, Parse parse, Parser parser) {
        DefinitionKeeper definitionKeeper = (DefinitionKeeper)parse.findObject(DefinitionKeeper.class);
        try {
            definitionKeeper.pushParent();
            Set<QName> allActivityTagNames = BpelParser.getAllActivityQNames();
            List activityElements = XmlUtil.elementsQName((Element)activityElement, allActivityTagNames);
            if (activityElements.size() == 0) {
                parse.addProblem("No activity was specified under this element. Please specify one of " + allActivityTagNames);
                return;
            }
            for (Element childrenElement : activityElements) {
                parser.parseElement(childrenElement, parse, "activities");
            }
        }
        finally {
            definitionKeeper.popParent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeImpl parseChildActivity(Element parentElement, Parse parse, Parser parser) {
        DefinitionKeeper definitionKeeper = (DefinitionKeeper)parse.findObject(DefinitionKeeper.class);
        try {
            Set<QName> allActivityTagNames;
            List activityElements;
            if (!(definitionKeeper.getParent() instanceof ElseIfFullDefinition || definitionKeeper.getParent() instanceof ElseFullDefinition || definitionKeeper.getParent() instanceof OnMessageFullDefinition || definitionKeeper.getParent() instanceof OnEventFullDefinition || definitionKeeper.getParent() instanceof OnAlarmFullDefinition)) {
                definitionKeeper.pushParent();
            }
            if ((activityElements = XmlUtil.elementsQName((Element)parentElement, allActivityTagNames = BpelParser.getAllActivityQNames())).size() == 0) {
                parse.addProblem("No activity was specified under this element. Please specify one of " + allActivityTagNames);
                NodeImpl nodeImpl = null;
                return nodeImpl;
            }
            Element childrenElement = (Element)activityElements.get(0);
            NodeImpl nodeImpl = (NodeImpl)parser.parseElement(childrenElement, parse, "activities");
            return nodeImpl;
        }
        finally {
            if (!(definitionKeeper.getParent() instanceof ElseIfFullDefinition || definitionKeeper.getParent() instanceof ElseFullDefinition || definitionKeeper.getParent() instanceof OnMessageFullDefinition || definitionKeeper.getParent() instanceof OnEventFullDefinition || definitionKeeper.getParent() instanceof OnAlarmFullDefinition)) {
                definitionKeeper.popParent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeImpl createActivityNodeWithChildren(Element activityElement, Parse parse, Parser parser, ExternalActivity activityBehaviour) {
        NodeImpl activityNode = this.createActivityNode(activityElement, parse, parser, activityBehaviour);
        parse.pushObject((Object)activityNode);
        parse.pushObject((Object)activityBehaviour);
        try {
            this.parseChildrenActivities(activityElement, parse, parser);
        }
        finally {
            parse.popObject();
            parse.popObject();
        }
        return activityNode;
    }

    protected NodeImpl createActivityNode(Element activityElement, Parse parse, Parser parser, ExternalActivity activityBehaviour) {
        return this.createActivityNode(this.getNodeName(activityElement), parse, parser, activityBehaviour);
    }

    protected String getNodeName(Element activityElement) {
        return XmlUtil.getTagLocalName((Element)activityElement) + " " + XmlUtil.attribute((Element)activityElement, (String)"name");
    }

    protected String getNodeName(String activityNodeName, String activityName) {
        return activityNodeName + " " + activityName;
    }

    protected NodeImpl createActivityNode(String nodeName, Parse parse, Parser parser, ExternalActivity activityBehaviour) {
        NodeImpl parentNode = (NodeImpl)parse.findObject(NodeImpl.class);
        NodeImpl activityNode = null;
        if (parentNode != null) {
            activityNode = parentNode.createNode(nodeName);
        } else {
            BpelProcess bpelProcess = (BpelProcess)((Object)parse.findObject(BpelProcess.class));
            activityNode = bpelProcess.createNode(nodeName);
        }
        activityNode.setBehaviour((Activity)activityBehaviour);
        return activityNode;
    }

    protected PartnerLink findPartnerLinkDefinition(Parse parse, String partnerLinkName) {
        Scope enclosingScope = (Scope)parse.findObject(Scope.class);
        return enclosingScope.findPartnerLink(partnerLinkName);
    }
}

