/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.element.Correlation;
import org.ow2.orchestra.definition.element.CorrelationSet;
import org.ow2.orchestra.facade.data.runtime.CorrelationSetInitializedData;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.ow2.orchestra.wsdl.PropertyAlias;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationSetRuntime {
    protected static final Logger LOG = Logger.getLogger(CorrelationSetRuntime.class.getName());
    protected String name;
    protected CorrelationSet correlationSetDefinition;
    protected Map<QName, Node> propertyValues;
    protected boolean initialized = false;
    protected ActivityInstanceUUID scopeActivityInstanceUUID;

    protected CorrelationSetRuntime() {
    }

    public CorrelationSetRuntime(CorrelationSet correlationSetDefinition, ActivityInstanceUUID scopeActivityInstanceUUID) {
        this.scopeActivityInstanceUUID = scopeActivityInstanceUUID;
        this.name = correlationSetDefinition.getName();
        this.correlationSetDefinition = correlationSetDefinition;
        this.propertyValues = new HashMap<QName, Node>();
    }

    public Node getPropertyValue(QName propertyName) {
        return this.propertyValues.get(propertyName);
    }

    public void setPropertyValue(QName propertyName, Node value) {
        this.propertyValues.put(propertyName, value.cloneNode(true));
    }

    protected boolean validatePropertyValue(PropertyAlias propertyAlias, MessageVariable message, BpelExecution execution) {
        try {
            Node expectedValue = this.getPropertyValue(propertyAlias.getPropertyName());
            Element partElement = message.getPartValue(propertyAlias.getPart());
            if (partElement == null) {
                return expectedValue == null;
            }
            Node value = partElement;
            if (propertyAlias.getQuery() != null) {
                value = propertyAlias.getQuery().getEvaluator().evaluate(partElement, execution);
            }
            if (value == null) {
                return expectedValue == null;
            }
            if (expectedValue == null) {
                return false;
            }
            boolean valid = BpelUtil.areNodeEquals(expectedValue, value);
            if (LOG.isLoggable(Level.FINEST)) {
                if (!valid) {
                    LOG.finest("Trying to validate CS value: expected " + XmlUtil.toString((Node)expectedValue) + " got " + XmlUtil.toString((Node)value));
                } else {
                    LOG.finest("CS value valid: " + XmlUtil.toString((Node)expectedValue));
                }
            }
            return valid;
        }
        catch (Exception ex) {
            throw new OrchestraRuntimeException("In Correlation: Function call exception:" + ex, (Throwable)ex);
        }
    }

    public boolean validateCSValues(BpelExecution execution, MessageVariable message, QName messageType) {
        List<PropertyAlias> propertyAliases = this.correlationSetDefinition.getPropertyAliasRefs(execution, messageType);
        for (PropertyAlias propertyAlias : propertyAliases) {
            if (this.validatePropertyValue(propertyAlias, message, execution)) continue;
            return false;
        }
        return true;
    }

    public void checkCSValues(BpelExecution execution, MessageVariable message, QName messageType, Correlation.Initiate initiate) {
        if (Correlation.Initiate.yes.equals((Object)initiate) || !this.isInitialized()) {
            this.initiate(execution, message, messageType, initiate);
        } else if (!this.validateCSValues(execution, message, messageType)) {
            throw BpelFaultException.generateBpelFaultException((BpelFaultException.BpelFault)BpelFaultException.BpelFault.correlationViolation, (String)"Correlation consistency constraint violated", null);
        }
    }

    public void initiate(BpelExecution execution, MessageVariable message, QName messageType, Correlation.Initiate initiate) {
        if (this.isInitialized()) {
            if (Correlation.Initiate.yes.equals((Object)initiate)) {
                throw BpelFaultException.generateBpelFaultException((BpelFaultException.BpelFault)BpelFaultException.BpelFault.correlationViolation, (String)"CorrelationSet already initialized and initiate='yes'", null);
            }
            return;
        }
        if (Correlation.Initiate.no.equals((Object)initiate)) {
            throw BpelFaultException.generateBpelFaultException((BpelFaultException.BpelFault)BpelFaultException.BpelFault.correlationViolation, (String)"CorrelationSet not initialized and initiate='no'", null);
        }
        List<PropertyAlias> propertyAliases = execution.getPropertyAliases(this.correlationSetDefinition, messageType);
        for (PropertyAlias propertyAlias : propertyAliases) {
            try {
                Element partElement;
                Node value = partElement = message.getPartValue(propertyAlias.getPart());
                if (propertyAlias.getQuery() != null) {
                    value = propertyAlias.getQuery().getEvaluator().evaluate(partElement, execution);
                }
                this.setPropertyValue(propertyAlias.getPropertyName(), value);
            }
            catch (Exception ex) {
                throw new OrchestraRuntimeException("In Correlation: Function call exception:" + ex, (Throwable)ex);
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Initialized correlation set with values: " + this.propertyValues);
        }
        this.setInitialized(true, execution.getActivityInstanceUUID());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CorrelationSetRuntime)) {
            return false;
        }
        CorrelationSetRuntime corr = (CorrelationSetRuntime)obj;
        return this.name.equals(corr.getName()) && ((Object)this.propertyValues).equals(corr.getPropertyValues());
    }

    public int hashCode() {
        StringBuffer result = new StringBuffer();
        result.append("name=\"" + this.name + "\" properties=\"");
        for (QName property : this.propertyValues.keySet()) {
            result.append(property);
        }
        result.append("\"");
        return result.toString().hashCode();
    }

    public Map<QName, Node> getPropertyValues() {
        return this.propertyValues;
    }

    public void setPropertyValues(Map<QName, Node> propertyValues) {
        this.propertyValues = propertyValues;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CorrelationSet getCorrelationSetDefinition() {
        return this.correlationSetDefinition;
    }

    public void setCorrelationSetDefinition(CorrelationSet correlationSetDefinition) {
        this.correlationSetDefinition = correlationSetDefinition;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized, ActivityInstanceUUID activityInstanceUUID) {
        this.initialized = initialized;
        EnvTool.getRecorder().recordCorrelationSetInitialized(new CorrelationSetInitializedData(this.scopeActivityInstanceUUID, activityInstanceUUID, this.name, this.propertyValues));
    }
}

