/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.env;

import java.util.HashSet;
import java.util.Set;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.internal.spring.SpringEnvironment;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringEnvironmentFactory
extends EnvironmentFactory
implements ApplicationContextAware {
    private static final long serialVersionUID = 1L;
    private ApplicationContext applicationContext;

    @Override
    public SpringEnvironment openEnvironment() {
        return new SpringEnvironment(this);
    }

    @Override
    public boolean has(String key) {
        return this.applicationContext.isSingleton(key);
    }

    @Override
    public Object get(String key) {
        if (this.has(key)) {
            return this.applicationContext.getBean(key);
        }
        return null;
    }

    @Override
    public <T> T get(Class<T> type) {
        String name = ReflectUtil.getUnqualifiedClassName(type);
        name = name.substring(0, 1).toLowerCase() + name.substring(1);
        return (T)this.get(name);
    }

    @Override
    public Set<String> keys() {
        HashSet<String> keys = new HashSet<String>();
        for (String key : this.applicationContext.getBeanDefinitionNames()) {
            if (!this.has(key)) continue;
            keys.add(key);
        }
        return keys;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Object set(String key, Object value) {
        return null;
    }
}

