/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.ejb;

import java.io.Serializable;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.ejb.LocalCommandExecutor;
import org.ow2.orchestra.pvm.internal.ejb.LocalCommandExecutorHome;
import org.ow2.orchestra.pvm.internal.jobexecutor.ExecuteJobCmd;
import org.ow2.orchestra.pvm.internal.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandReceiverMDB
implements MessageDrivenBean,
MessageListener {
    private MessageDrivenContext messageDrivenContext;
    private LocalCommandExecutor commandExecutor;
    private Connection jmsConnection;
    private Destination deadLetterQueue;
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getLog(CommandReceiverMDB.class.getName());

    public void onMessage(Message message) {
        try {
            Command<?> command = CommandReceiverMDB.extractCommand(message);
            if (command == null) {
                this.discard(message);
                return;
            }
            Object result = this.commandExecutor.execute(command);
            Destination replyTo = message.getJMSReplyTo();
            if (replyTo != null && (result instanceof Serializable || result == null)) {
                this.sendResult((Serializable)result, replyTo, message.getJMSMessageID());
            }
        }
        catch (JMSException e) {
            throw new EJBException("could not process message " + message, (Exception)((Object)e));
        }
    }

    private static Command<?> extractCommand(Message message) throws JMSException {
        Command command = null;
        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)message;
            Serializable body = objectMessage.getObject();
            LOG.debug("received object message with body " + body);
            if (body instanceof Command) {
                command = (Command)body;
            } else {
                LOG.info("WARNING: ignoring object message, body is not a command: " + message);
            }
        } else if (message.getObjectProperty("jobId") != null) {
            long jobId = message.getLongProperty("jobId");
            LOG.debug("received message with jobImpl id " + jobId);
            command = new ExecuteJobCmd(jobId);
        } else {
            LOG.info("WARNING: ignoring message, unknown format: " + message);
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discard(Message message) throws JMSException {
        if (this.deadLetterQueue != null) {
            Session jmsSession = this.createSession();
            try {
                jmsSession.createProducer(this.deadLetterQueue).send(message);
            }
            finally {
                jmsSession.close();
            }
        } else {
            this.messageDrivenContext.setRollbackOnly();
        }
    }

    private Session createSession() throws JMSException {
        return this.jmsConnection.createSession(false, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResult(Serializable result, Destination destination, String correlationId) throws JMSException {
        LOG.debug("sending result " + result + " to " + destination);
        Session jmsSession = this.createSession();
        try {
            ObjectMessage resultMessage = jmsSession.createObjectMessage(result);
            resultMessage.setJMSCorrelationID(correlationId);
            jmsSession.createProducer(destination).send((Message)resultMessage);
        }
        finally {
            jmsSession.close();
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext messageDrivenContext) {
        this.messageDrivenContext = messageDrivenContext;
    }

    public void ejbCreate() {
        try {
            InitialContext context = new InitialContext();
            LocalCommandExecutorHome commandExecutorHome = (LocalCommandExecutorHome)context.lookup("java:comp/env/ejb/LocalCommandExecutor");
            ConnectionFactory jmsConnectionFactory = (ConnectionFactory)context.lookup("java:comp/env/jms/CommandConnectionFactory");
            try {
                this.deadLetterQueue = (Destination)context.lookup("java:comp/env/jms/DeadLetterQueue");
            }
            catch (NameNotFoundException e) {
                LOG.info("dead letter queue not specified, messages with unknown formats will be rejected");
            }
            context.close();
            this.commandExecutor = commandExecutorHome.create();
            this.jmsConnection = jmsConnectionFactory.createConnection();
        }
        catch (NamingException e) {
            throw new EJBException("error retrieving managed objects", (Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException("error creating command executor", (Exception)((Object)e));
        }
        catch (JMSException e) {
            throw new EJBException("error creating jms connection", (Exception)((Object)e));
        }
    }

    public void ejbRemove() {
        if (this.jmsConnection != null) {
            try {
                this.jmsConnection.close();
            }
            catch (JMSException e) {
                LOG.debug("could not close jms connection", e);
            }
            this.jmsConnection = null;
        }
        this.commandExecutor = null;
        this.messageDrivenContext = null;
    }
}

